/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.api.internal.ServerApi;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.util.function.Supplier;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;

public class ForgeServerProxy {
    private final ServerApi serverApi = ServerApi.INSTANCE;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final boolean isDedicated;
    public static Supplier<Boolean> isGenerationThreadChecker = null;

    private static LevelAccessor GetLevel(LevelEvent e) {
        return e.getLevel();
    }

    public ForgeServerProxy(boolean isDedicated) {
        this.isDedicated = isDedicated;
        isGenerationThreadChecker = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
    }

    private boolean isValidTime() {
        if (this.isDedicated) {
            return true;
        }
        return !(Minecraft.m_91087_().f_91080_ instanceof TitleScreen);
    }

    private ServerLevelWrapper getLevelWrapper(ServerLevel level) {
        return ServerLevelWrapper.getWrapper(level);
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isValidTime()) {
            this.serverApi.serverTickEvent();
        }
    }

    @SubscribeEvent
    public void dedicatedWorldLoadEvent(ServerAboutToStartEvent event) {
        if (this.isValidTime()) {
            this.serverApi.serverLoadEvent(this.isDedicated);
        }
    }

    @SubscribeEvent
    public void serverWorldUnloadEvent(ServerStoppingEvent event) {
        if (this.isValidTime()) {
            this.serverApi.serverUnloadEvent();
        }
    }

    @SubscribeEvent
    public void serverLevelLoadEvent(LevelEvent.Load event) {
        if (this.isValidTime() && ForgeServerProxy.GetLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelLoadEvent(this.getLevelWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverLevelUnloadEvent(LevelEvent.Unload event) {
        if (this.isValidTime() && ForgeServerProxy.GetLevel((LevelEvent)event) instanceof ServerLevel) {
            this.serverApi.serverLevelUnloadEvent(this.getLevelWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverChunkLoadEvent(ChunkEvent.Load event) {
        if (this.isValidTime() && ForgeServerProxy.GetLevel((LevelEvent)event) instanceof ServerLevel) {
            ServerLevelWrapper wrappedLevel = ServerLevelWrapper.getWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event));
            ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeServerProxy.GetLevel((LevelEvent)event), wrappedLevel);
            this.serverApi.serverChunkLoadEvent(chunk, this.getLevelWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void serverChunkSaveEvent(ChunkEvent.Unload event) {
        if (this.isValidTime() && ForgeServerProxy.GetLevel((LevelEvent)event) instanceof ServerLevel) {
            ServerLevelWrapper wrappedLevel = ServerLevelWrapper.getWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event));
            ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeServerProxy.GetLevel((LevelEvent)event), wrappedLevel);
            this.serverApi.serverChunkSaveEvent(chunk, this.getLevelWrapper((ServerLevel)ForgeServerProxy.GetLevel((LevelEvent)event)));
        }
    }
}

