/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.Logger;

public class ForgeClientProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    private static LevelAccessor GetLevel(LevelEvent e) {
        return e.getLevel();
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientApi.INSTANCE.clientTickEvent();
        }
    }

    @SubscribeEvent
    public void clientLevelLoadEvent(LevelEvent.Load event) {
        LOGGER.info("level load");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel);
        ClientApi.INSTANCE.clientLevelLoadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void clientLevelUnloadEvent(LevelEvent.Load event) {
        LOGGER.info("level unload");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel);
        ClientApi.INSTANCE.clientLevelUnloadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void rightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        LOGGER.trace("interact or block place event at blockPos: " + event.getPos());
        Level level = event.getLevel();
        ChunkAccess chunk = level.m_46865_(event.getPos());
        this.onClientBlockChangeEvent((LevelAccessor)level, chunk);
    }

    @SubscribeEvent
    public void leftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        LOGGER.trace("break or block attack at blockPos: " + event.getPos());
        Level level = event.getLevel();
        ChunkAccess chunk = level.m_46865_(event.getPos());
        this.onClientBlockChangeEvent((LevelAccessor)level, chunk);
    }

    private void onClientBlockChangeEvent(LevelAccessor level, ChunkAccess chunk) {
        if (MC.clientConnectedToDedicatedServer() && chunk != null) {
            IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper((ClientLevel)level);
            ClientApi.INSTANCE.clientChunkBlockChangedEvent(new ChunkWrapper(chunk, (LevelReader)level, wrappedLevel), wrappedLevel);
        }
    }

    @SubscribeEvent
    public void clientChunkLoadEvent(ChunkEvent.Load event) {
        if (ForgeClientProxy.GetLevel((LevelEvent)event) instanceof ClientLevel) {
            IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper((ClientLevel)ForgeClientProxy.GetLevel((LevelEvent)event));
            ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeClientProxy.GetLevel((LevelEvent)event), wrappedLevel);
            ClientApi.INSTANCE.clientChunkLoadEvent(chunk, ClientLevelWrapper.getWrapper((ClientLevel)ForgeClientProxy.GetLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void clientChunkUnloadEvent(ChunkEvent.Unload event) {
        if (ForgeClientProxy.GetLevel((LevelEvent)event) instanceof ClientLevel) {
            IClientLevelWrapper wrappedLevel = ClientLevelWrapper.getWrapper((ClientLevel)ForgeClientProxy.GetLevel((LevelEvent)event));
            ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeClientProxy.GetLevel((LevelEvent)event), wrappedLevel);
            ClientApi.INSTANCE.clientChunkSaveEvent(chunk, ClientLevelWrapper.getWrapper((ClientLevel)ForgeClientProxy.GetLevel((LevelEvent)event)));
        }
    }

    @SubscribeEvent
    public void registerKeyBindings(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        ClientApi.INSTANCE.keyPressedEvent(event.getKey());
    }

    public static void setupNetworkingListeners(FMLClientSetupEvent event) {
    }

    public static boolean isReceivedProtocolVersionAcceptable(String versionString) {
        if (versionString.toLowerCase().contains("allowvanilla")) {
            return true;
        }
        if (versionString.toLowerCase().contains("absent")) {
            return true;
        }
        try {
            int version = Integer.parseInt(versionString);
            return 1 == version;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }
}

