/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.minecraft;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.interfaces.dependencyInjection.IBindable;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.logging.log4j.Level;

public interface IMinecraftClientWrapper
extends IBindable {
    public void clearFrameObjectCache();

    public float getShade(EDhDirection var1);

    public boolean hasSinglePlayerServer();

    public boolean clientConnectedToDedicatedServer();

    public String getCurrentServerName();

    public String getCurrentServerIp();

    public String getCurrentServerVersion();

    public boolean playerExists();

    public UUID getPlayerUUID();

    public DhBlockPos getPlayerBlockPos();

    public DhChunkPos getPlayerChunkPos();

    public ILevelWrapper getWrappedClientWorld();

    @Deprecated
    public File getGameDirectory();

    public IProfilerWrapper getProfiler();

    public ArrayList<ILevelWrapper> getAllServerWorlds();

    public void sendChatMessage(String var1);

    default public void logToChat(Level logLevel, String message) {
        String prefix = "[Distant Horizons] ";
        prefix = logLevel == Level.ERROR ? prefix + "\u00a74" : (logLevel == Level.WARN ? prefix + "\u00a76" : (logLevel == Level.INFO ? prefix + "\u00a7f" : (logLevel == Level.DEBUG ? prefix + "\u00a77" : (logLevel == Level.TRACE ? prefix + "\u00a78" : prefix + "\u00a7f"))));
        prefix = prefix + "\u00a7l\u00a7u";
        prefix = prefix + logLevel.name();
        prefix = prefix + ":\u00a7r ";
        this.sendChatMessage(prefix + message);
    }

    public void crashMinecraft(String var1, Throwable var2);

    public Object getOptionsObject();

    public void executeOnRenderThread(Runnable var1);
}

