/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.file.structure.LocalSaveStructure;
import com.seibel.distanthorizons.core.level.DhServerLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class DhServerWorld
extends AbstractDhWorld
implements IDhServerWorld {
    private final HashMap<IServerLevelWrapper, DhServerLevel> levels;
    public final LocalSaveStructure saveStructure = new LocalSaveStructure();

    public DhServerWorld() {
        super(EWorldEnvironment.Server_Only);
        this.levels = new HashMap();
        LOGGER.info("Started " + DhServerWorld.class.getSimpleName() + " of type " + (Object)((Object)this.environment));
    }

    private void registerNetworkHandlers() {
    }

    public void addPlayer(IServerPlayerWrapper serverPlayer) {
    }

    public void removePlayer(IServerPlayerWrapper serverPlayer) {
    }

    @Override
    public DhServerLevel getOrLoadLevel(ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.levels.computeIfAbsent((IServerLevelWrapper)wrapper, serverLevelWrapper -> {
            File levelFile = this.saveStructure.getLevelFolder(wrapper);
            LodUtil.assertTrue(levelFile != null);
            return new DhServerLevel(this.saveStructure, (IServerLevelWrapper)serverLevelWrapper);
        });
    }

    @Override
    public DhServerLevel getLevel(ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.levels.get(wrapper);
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return this.levels.values();
    }

    @Override
    public void unloadLevel(ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return;
        }
        if (this.levels.containsKey(wrapper)) {
            LOGGER.info("Unloading level {} ", (Object)this.levels.get(wrapper));
            wrapper.onUnload();
            this.levels.remove(wrapper).close();
        }
    }

    @Override
    public void serverTick() {
        this.levels.values().forEach(DhServerLevel::serverTick);
    }

    @Override
    public void doWorldGen() {
        this.levels.values().forEach(DhServerLevel::doWorldGen);
    }

    @Override
    public CompletableFuture<Void> saveAndFlush() {
        return CompletableFuture.allOf((CompletableFuture[])this.levels.values().stream().map(DhServerLevel::saveAsync).toArray(CompletableFuture[]::new));
    }

    @Override
    public void close() {
        for (DhServerLevel level : this.levels.values()) {
            LOGGER.info("Unloading level " + level.getLevelWrapper().getDimensionType().getDimensionName());
            IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
            if (serverLevelWrapper != null) {
                serverLevelWrapper.onUnload();
            }
            level.close();
        }
        this.levels.clear();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment));
    }
}

