/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RateLimitedThreadPoolExecutor
extends ThreadPoolExecutor {
    public volatile double runTimeRatio;
    private final ThreadLocal<Long> runStartNanoTimeRef = ThreadLocal.withInitial(() -> -1L);
    private final ThreadLocal<Long> lastRunDurationNanoTimeRef = ThreadLocal.withInitial(() -> -1L);
    private Runnable onTerminatedEventHandler = null;

    public RateLimitedThreadPoolExecutor(int corePoolSize, double runTimeRatio, ThreadFactory threadFactory) {
        super(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.runTimeRatio = runTimeRatio;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        if (this.runTimeRatio < 1.0 && this.lastRunDurationNanoTimeRef.get() != -1L) {
            try {
                long deltaMs = TimeUnit.NANOSECONDS.toMillis(this.lastRunDurationNanoTimeRef.get());
                Thread.sleep((long)((double)deltaMs / this.runTimeRatio - (double)deltaMs));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.runStartNanoTimeRef.set(System.nanoTime());
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        this.lastRunDurationNanoTimeRef.set(System.nanoTime() - this.runStartNanoTimeRef.get());
    }

    @Override
    protected void terminated() {
        super.terminated();
        if (this.onTerminatedEventHandler != null) {
            this.onTerminatedEventHandler.run();
        }
    }

    public void setOnTerminatedEventHandler(Runnable runnable) {
        this.onTerminatedEventHandler = runnable;
    }
}

