/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.util.objects.DhThreadFactory;
import com.seibel.distanthorizons.core.util.objects.RateLimitedThreadPoolExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static String THREAD_NAME_PREFIX = "DH-";
    public static int MINIMUM_RELATIVE_PRIORITY = -4;
    public static int DEFAULT_RELATIVE_PRIORITY = 0;
    private static final ConcurrentHashMap<String, ConfigChangeListener<Double>> THREAD_CHANGE_LISTENERS_BY_THREAD_NAME = new ConcurrentHashMap();

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, String name, ConfigEntry<Double> runTimeRatioConfigEntry) {
        return ThreadUtil.makeRateLimitedThreadPool(poolSize, name, DEFAULT_RELATIVE_PRIORITY, runTimeRatioConfigEntry);
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, String name, int relativePriority, ConfigEntry<Double> runTimeRatioConfigEntry) {
        DhThreadFactory threadFactory = new DhThreadFactory(THREAD_NAME_PREFIX + name, 5 + relativePriority);
        return ThreadUtil.makeRateLimitedThreadPool(poolSize, threadFactory, runTimeRatioConfigEntry);
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, DhThreadFactory threadFactory, ConfigEntry<Double> runTimeRatioConfigEntry) {
        if (THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.containsKey(threadFactory.threadName)) {
            THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.get(threadFactory.threadName).close();
            THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.remove(threadFactory.threadName);
        }
        if (!threadFactory.threadName.startsWith(THREAD_NAME_PREFIX)) {
            LOGGER.warn("Thread pool with the name [" + threadFactory.threadName + "] is missing the expected Distant Horizons thread prefix [" + THREAD_NAME_PREFIX + "].");
        }
        RateLimitedThreadPoolExecutor executor = ThreadUtil.makeRateLimitedThreadPool(poolSize, runTimeRatioConfigEntry.get(), threadFactory);
        ConfigChangeListener<Double> changeListener = new ConfigChangeListener<Double>(runTimeRatioConfigEntry, newRunTimeRatio -> {
            executor.runTimeRatio = newRunTimeRatio;
        });
        THREAD_CHANGE_LISTENERS_BY_THREAD_NAME.put(threadFactory.threadName, changeListener);
        return executor;
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, String name, Double runTimeRatio, int relativePriority) {
        return new RateLimitedThreadPoolExecutor(poolSize, runTimeRatio, new DhThreadFactory(THREAD_NAME_PREFIX + name, 5 + relativePriority));
    }

    public static RateLimitedThreadPoolExecutor makeRateLimitedThreadPool(int poolSize, Double runTimeRatio, DhThreadFactory threadFactory) {
        return new RateLimitedThreadPoolExecutor(poolSize, runTimeRatio, threadFactory);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name, int relativePriority) {
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DhThreadFactory(THREAD_NAME_PREFIX + name, 5 + relativePriority));
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz, int relativePriority) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), relativePriority);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, String name) {
        return ThreadUtil.makeThreadPool(poolSize, name, DEFAULT_RELATIVE_PRIORITY);
    }

    public static ThreadPoolExecutor makeThreadPool(int poolSize, Class<?> clazz) {
        return ThreadUtil.makeThreadPool(poolSize, clazz.getSimpleName(), DEFAULT_RELATIVE_PRIORITY);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name, int relativePriority) {
        return ThreadUtil.makeThreadPool(1, name, relativePriority);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz, int relativePriority) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), relativePriority);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(String name) {
        return ThreadUtil.makeThreadPool(1, name, DEFAULT_RELATIVE_PRIORITY);
    }

    public static ThreadPoolExecutor makeSingleThreadPool(Class<?> clazz) {
        return ThreadUtil.makeThreadPool(1, clazz.getSimpleName(), DEFAULT_RELATIVE_PRIORITY);
    }
}

