/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.File;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public static File renameCorruptedFile(File file) {
        String corruptedFileName = file.getName() + ".corrupted";
        File corruptedFile = new File(file.getParentFile(), corruptedFileName);
        if (corruptedFile.exists() && !corruptedFile.delete()) {
            LOGGER.error("Unable to delete pre-existing corrupted file [" + corruptedFileName + "].");
        }
        if (file.exists()) {
            if (file.renameTo(corruptedFile)) {
                LOGGER.error("Renamed corrupted file to [" + corruptedFileName + "].");
            } else {
                LOGGER.error("Failed to rename corrupted file to [" + corruptedFileName + "]. Attempting to delete file...");
                if (!file.delete()) {
                    LOGGER.error("Unable to delete corrupted file [" + corruptedFileName + "].");
                }
            }
        } else {
            LOGGER.error("Corrupted file [" + file + "] doesn't exist.");
        }
        return corruptedFile;
    }
}

