/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

public class ColorUtil {
    public static final int INVISIBLE = ColorUtil.rgbToInt(0, 0, 0, 0);
    public static final int BLACK = ColorUtil.rgbToInt(0, 0, 0);
    public static final int WHITE = ColorUtil.rgbToInt(255, 255, 255);
    public static final int RED = ColorUtil.rgbToInt(255, 0, 0);
    public static final int GREEN = ColorUtil.rgbToInt(0, 255, 0);
    public static final int BLUE = ColorUtil.rgbToInt(0, 0, 255);
    public static final int YELLOW = ColorUtil.rgbToInt(255, 255, 0);
    public static final int CYAN = ColorUtil.rgbToInt(0, 255, 255);
    public static final int MAGENTA = ColorUtil.rgbToInt(255, 0, 255);
    public static final int ORANGE = ColorUtil.rgbToInt(255, 128, 0);
    public static final int PINK = ColorUtil.rgbToInt(255, 128, 128);
    public static final int GRAY = ColorUtil.rgbToInt(128, 128, 128);
    public static final int LIGHT_GRAY = ColorUtil.rgbToInt(192, 192, 192);
    public static final int DARK_GRAY = ColorUtil.rgbToInt(64, 64, 64);
    public static final int BROWN = ColorUtil.rgbToInt(128, 64, 0);
    public static final int PURPLE = ColorUtil.rgbToInt(128, 0, 128);

    public static int rgbToInt(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int rgbToInt(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int rgbToInt(float alpha, float red, float green, float blue) {
        return ColorUtil.rgbToInt((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static int getAlpha(int color) {
        return color >>> 24 & 0xFF;
    }

    public static int setAlpha(int color, int newAlpha) {
        return newAlpha << 24 | ColorUtil.getRed(color) << 16 | ColorUtil.getGreen(color) << 8 | ColorUtil.getBlue(color);
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int setRed(int color, int newRed) {
        return ColorUtil.getAlpha(color) << 24 | newRed << 16 | ColorUtil.getGreen(color) << 8 | ColorUtil.getBlue(color);
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int setGreen(int color, int newGreen) {
        return ColorUtil.getAlpha(color) << 24 | ColorUtil.getRed(color) << 16 | newGreen << 8 | ColorUtil.getBlue(color);
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int setBlue(int color, int newBlue) {
        return ColorUtil.getAlpha(color) << 24 | ColorUtil.getRed(color) << 16 | ColorUtil.getGreen(color) << 8 | newBlue;
    }

    public static int applyShade(int color, int shade) {
        if (shade < 0) {
            return ColorUtil.getAlpha(color) << 24 | Math.max(ColorUtil.getRed(color) + shade, 0) << 16 | Math.max(ColorUtil.getGreen(color) + shade, 0) << 8 | Math.max(ColorUtil.getBlue(color) + shade, 0);
        }
        return ColorUtil.getAlpha(color) << 24 | Math.min(ColorUtil.getRed(color) + shade, 255) << 16 | Math.min(ColorUtil.getGreen(color) + shade, 255) << 8 | Math.min(ColorUtil.getBlue(color) + shade, 255);
    }

    public static int applyShade(int color, float shade) {
        if (shade < 1.0f) {
            return ColorUtil.getAlpha(color) << 24 | (int)Math.max((float)ColorUtil.getRed(color) * shade, 0.0f) << 16 | (int)Math.max((float)ColorUtil.getGreen(color) * shade, 0.0f) << 8 | (int)Math.max((float)ColorUtil.getBlue(color) * shade, 0.0f);
        }
        return ColorUtil.getAlpha(color) << 24 | (int)Math.min((float)ColorUtil.getRed(color) * shade, 255.0f) << 16 | (int)Math.min((float)ColorUtil.getGreen(color) * shade, 255.0f) << 8 | (int)Math.min((float)ColorUtil.getBlue(color) * shade, 255.0f);
    }

    public static int multiplyARGBwithRGB(int argb, int rgb) {
        return ColorUtil.getAlpha(argb) << 24 | ColorUtil.getRed(argb) * ColorUtil.getRed(rgb) / 255 << 16 | ColorUtil.getGreen(argb) * ColorUtil.getGreen(rgb) / 255 << 8 | ColorUtil.getBlue(argb) * ColorUtil.getBlue(rgb) / 255;
    }

    public static int multiplyARGBwithARGB(int color1, int color2) {
        return ColorUtil.getAlpha(color1) * ColorUtil.getAlpha(color2) / 255 << 24 | ColorUtil.getRed(color1) * ColorUtil.getRed(color2) / 255 << 16 | ColorUtil.getGreen(color1) * ColorUtil.getGreen(color2) / 255 << 8 | ColorUtil.getBlue(color1) * ColorUtil.getBlue(color2) / 255;
    }

    public static float[] argbToAhsv(int color) {
        float h;
        float max;
        float a = (float)ColorUtil.getAlpha(color) / 255.0f;
        float r = (float)ColorUtil.getRed(color) / 255.0f;
        float g = (float)ColorUtil.getGreen(color) / 255.0f;
        float b = (float)ColorUtil.getBlue(color) / 255.0f;
        float min = Math.min(Math.min(r, g), b);
        float v = max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            return new float[]{a, 0.0f, 0.0f, 0.0f};
        }
        float s = delta / max;
        if (delta == 0.0f) {
            h = 0.0f;
        } else {
            h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        }
        return new float[]{a, h, s, v};
    }

    public static int ahsvToArgb(float a, float h, float s, float v) {
        if (a > 1.0f) {
            a = 1.0f;
        }
        if (h > 360.0f) {
            h -= 350.0f;
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        if (v > 1.0f) {
            v = 1.0f;
        }
        if (s == 0.0f) {
            return ColorUtil.rgbToInt(a, v, v, v);
        }
        int i = (int)Math.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                return ColorUtil.rgbToInt(a, v, t, p);
            }
            case 1: {
                return ColorUtil.rgbToInt(a, q, v, p);
            }
            case 2: {
                return ColorUtil.rgbToInt(a, p, v, t);
            }
            case 3: {
                return ColorUtil.rgbToInt(a, p, q, v);
            }
            case 4: {
                return ColorUtil.rgbToInt(a, t, p, v);
            }
        }
        return ColorUtil.rgbToInt(a, v, p, q);
    }

    public static String toHexString(int color) {
        return "A:" + Integer.toHexString(ColorUtil.getAlpha(color)) + ",R:" + Integer.toHexString(ColorUtil.getRed(color)) + ",G:" + Integer.toHexString(ColorUtil.getGreen(color)) + ",B:" + Integer.toHexString(ColorUtil.getBlue(color));
    }

    public static String toString(int color) {
        return "A:" + ColorUtil.getAlpha(color) + ",R:" + ColorUtil.getRed(color) + ",G:" + ColorUtil.getGreen(color) + ",B:" + ColorUtil.getBlue(color);
    }
}

