/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import org.lwjgl.opengl.GL32;

public class SSAOApplyShader
extends AbstractShaderRenderer {
    public static SSAOApplyShader INSTANCE = new SSAOApplyShader();
    public int BufferTexture;
    public int gSSAOMapUniform;
    public int gDepthMapUniform;
    public int gViewSizeUniform;
    public int gBlurRadiusUniform;
    public int gNearUniform;
    public int gFarUniform;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/ssao/apply.frag", "fragColor", new String[]{"vPosition"});
        this.gSSAOMapUniform = this.shader.getUniformLocation("gSSAOMap");
        this.gDepthMapUniform = this.shader.getUniformLocation("gDepthMap");
        this.gViewSizeUniform = this.shader.tryGetUniformLocation("gViewSize");
        this.gBlurRadiusUniform = this.shader.tryGetUniformLocation("gBlurRadius");
        this.gNearUniform = this.shader.tryGetUniformLocation("gNear");
        this.gFarUniform = this.shader.tryGetUniformLocation("gFar");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)MC_RENDER.getDepthTextureId());
        GL32.glUniform1i((int)this.gDepthMapUniform, (int)0);
        GL32.glActiveTexture((int)33985);
        GL32.glBindTexture((int)3553, (int)this.BufferTexture);
        GL32.glUniform1i((int)this.gSSAOMapUniform, (int)1);
        GL32.glUniform1i((int)this.gBlurRadiusUniform, (int)Config.Client.Advanced.Graphics.Ssao.blurRadius.get());
        if (this.gViewSizeUniform >= 0) {
            GL32.glUniform2f((int)this.gViewSizeUniform, (float)MC_RENDER.getTargetFrameBufferViewportWidth(), (float)MC_RENDER.getTargetFrameBufferViewportHeight());
        }
        if (this.gNearUniform >= 0) {
            GL32.glUniform1f((int)this.gNearUniform, (float)RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks));
        }
        if (this.gFarUniform >= 0) {
            float far = (float)((double)(RenderUtil.getFarClipPlaneDistanceInBlocks() + 512) * Math.sqrt(2.0));
            GL32.glUniform1f((int)this.gFarUniform, (float)far);
        }
    }

    @Override
    protected void onRender() {
        GL32.glEnable((int)3042);
        GL32.glBlendEquation((int)32774);
        GL32.glBlendFuncSeparate((int)0, (int)770, (int)0, (int)1);
        ScreenQuad.INSTANCE.render();
    }
}

