/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.api.enums.config.ELoggerMode;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttribute;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL32;

public class TestRenderer {
    public static final ConfigBasedLogger logger = new ConfigBasedLogger(LogManager.getLogger(TestRenderer.class), () -> ELoggerMode.LOG_ALL_TO_CHAT);
    public static final ConfigBasedSpamLogger spamLogger = new ConfigBasedSpamLogger(LogManager.getLogger(TestRenderer.class), () -> ELoggerMode.LOG_ALL_TO_CHAT, 1);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    ShaderProgram basicShader;
    GLVertexBuffer sameContextBuffer;
    GLVertexBuffer sharedContextBuffer;
    VertexAttribute va;
    boolean init = false;
    private static final float[] vertices = new float[]{-0.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 0.4f, -0.4f, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.0f, 0.0f, -0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f};

    public void init() {
        if (this.init) {
            return;
        }
        logger.info("init", new Object[0]);
        this.init = true;
        this.va = VertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexAttribute.VertexPointer.addVec2Pointer(false));
        this.va.setVertexAttribute(0, 1, VertexAttribute.VertexPointer.addVec4Pointer(false));
        this.va.completeAndCheck(24);
        this.basicShader = new ShaderProgram("shaders/test/vert.vert", "shaders/test/frag.frag", "fragColor", new String[]{"vPosition", "color"});
        this.createBuffer();
    }

    private static GLVertexBuffer createTextingBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(vertices.length * 4);
        buffer = buffer.order(ByteOrder.nativeOrder());
        buffer.asFloatBuffer().put(vertices);
        buffer.rewind();
        GLVertexBuffer vbo = new GLVertexBuffer(false);
        vbo.bind();
        vbo.uploadBuffer(buffer, 4, EGpuUploadMethod.DATA, vertices.length * 4);
        return vbo;
    }

    private void createBuffer() {
        GLProxy.getInstance().recordOpenGlCall(() -> {
            this.sharedContextBuffer = TestRenderer.createTextingBuffer();
        });
        GLProxy.ensureAllGLJobCompleted();
        this.sameContextBuffer = TestRenderer.createTextingBuffer();
    }

    public void render() {
        spamLogger.debug("rendering", new Object[0]);
        GLState state = new GLState();
        this.init();
        GL32.glBindFramebuffer((int)36160, (int)MC_RENDER.getTargetFrameBuffer());
        GL32.glViewport((int)0, (int)0, (int)MC_RENDER.getTargetFrameBufferViewportWidth(), (int)MC_RENDER.getTargetFrameBufferViewportHeight());
        GL32.glPolygonMode((int)1032, (int)6914);
        GL32.glDisable((int)2884);
        GL32.glDisable((int)2929);
        GL32.glDisable((int)2960);
        GL32.glDisable((int)3042);
        this.basicShader.bind();
        this.va.bind();
        if (System.currentTimeMillis() % 2000L < 1000L) {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoint(this.sameContextBuffer.getId());
            spamLogger.debug("same context buffer", new Object[0]);
        } else {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoint(this.sharedContextBuffer.getId());
            spamLogger.debug("shared context buffer", new Object[0]);
        }
        GL32.glDrawArrays((int)6, (int)0, (int)4);
        GL32.glClear((int)256);
        state.restore();
        spamLogger.incLogTries();
    }
}

