/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttribute;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL32;

public class ScreenQuad {
    public static ScreenQuad INSTANCE = new ScreenQuad();
    private static final float[] box_vertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
    private GLVertexBuffer boxBuffer;
    private VertexAttribute va;
    private boolean init = false;

    private ScreenQuad() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.va = VertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexAttribute.VertexPointer.addVec2Pointer(false));
        this.va.completeAndCheck(8);
        this.createBuffer();
    }

    public void render() {
        this.init();
        this.va.bind();
        this.va.bindBufferToAllBindingPoint(this.boxBuffer.getId());
        GL32.glDrawArrays((int)4, (int)0, (int)6);
    }

    private void createBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(box_vertices.length * 4);
        buffer.order(ByteOrder.nativeOrder());
        buffer.asFloatBuffer().put(box_vertices);
        buffer.rewind();
        this.boxBuffer = new GLVertexBuffer(false);
        this.boxBuffer.bind();
        this.boxBuffer.uploadBuffer(buffer, box_vertices.length, EGpuUploadMethod.DATA, box_vertices.length * 4);
    }
}

