/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.fog.LodFogConfig;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePostGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePreGL43;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;

public class LodRenderProgram
extends ShaderProgram {
    public static final String VERTEX_SHADER_PATH = "shaders/standard.vert";
    public static final String VERTEX_CURVE_SHADER_PATH = "shaders/curve.vert";
    public static final String FRAGMENT_SHADER_PATH = "shaders/flat_shaded.frag";
    private static final IVersionConstants VERSION_CONSTANTS = SingletonInjector.INSTANCE.get(IVersionConstants.class);
    public final VertexAttribute vao;
    public final int combinedMatUniform;
    public final int modelOffsetUniform;
    public final int worldYOffsetUniform;
    public final int mircoOffsetUniform;
    public final int earthRadiusUniform;
    public final int lightMapUniform;
    public final int noiseEnabledUniform;
    public final int noiseStepsUniform;
    public final int noiseIntensityUniform;
    public final int noiseDropoffUniform;
    public final int whiteWorldUniform;
    private final LodFogConfig fogConfig;

    public LodRenderProgram(LodFogConfig fogConfig) {
        super(() -> Shader.loadFile(fogConfig.earthCurveRatio != 0 ? VERTEX_CURVE_SHADER_PATH : VERTEX_SHADER_PATH, false, new StringBuilder()).toString(), () -> Shader.loadFile(FRAGMENT_SHADER_PATH, false, new StringBuilder()).toString(), "fragColor", new String[]{"vPosition", "color"});
        this.fogConfig = fogConfig;
        this.combinedMatUniform = this.getUniformLocation("combinedMatrix");
        this.modelOffsetUniform = this.getUniformLocation("modelOffset");
        this.worldYOffsetUniform = this.tryGetUniformLocation("worldYOffset");
        this.mircoOffsetUniform = this.getUniformLocation("mircoOffset");
        this.earthRadiusUniform = this.tryGetUniformLocation("earthRadius");
        this.lightMapUniform = this.getUniformLocation("lightMap");
        this.noiseEnabledUniform = this.getUniformLocation("noiseEnabled");
        this.noiseStepsUniform = this.getUniformLocation("noiseSteps");
        this.noiseIntensityUniform = this.getUniformLocation("noiseIntensity");
        this.noiseDropoffUniform = this.getUniformLocation("noiseDropoff");
        this.whiteWorldUniform = this.getUniformLocation("whiteWorld");
        int vertexByteCount = LodUtil.LOD_VERTEX_FORMAT.getByteSize();
        this.vao = GLProxy.getInstance().VertexAttributeBufferBindingSupported ? new VertexAttributePostGL43() : new VertexAttributePreGL43();
        this.vao.bind();
        this.vao.setVertexAttribute(0, 0, VertexAttribute.VertexPointer.addUnsignedShortsPointer(4, false, true));
        this.vao.setVertexAttribute(0, 1, VertexAttribute.VertexPointer.addUnsignedBytesPointer(4, true, false));
        try {
            this.vao.completeAndCheck(vertexByteCount);
        }
        catch (RuntimeException e) {
            System.out.println(LodUtil.LOD_VERTEX_FORMAT);
            throw e;
        }
        if (this.earthRadiusUniform != -1) {
            this.setUniform(this.earthRadiusUniform, 6371000.0f / (float)fogConfig.earthCurveRatio);
        }
        this.setUniform(this.noiseEnabledUniform, fogConfig.noiseEnable);
        this.setUniform(this.noiseStepsUniform, fogConfig.noiseSteps);
        this.setUniform(this.noiseIntensityUniform, fogConfig.noiseIntensity);
        this.setUniform(this.noiseDropoffUniform, fogConfig.noiseDropoff);
    }

    public LodFogConfig isShaderUsable() {
        LodFogConfig newConfig = LodFogConfig.generateFogConfig();
        if (this.fogConfig.equals(newConfig)) {
            return null;
        }
        return newConfig;
    }

    @Override
    public void bind() {
        super.bind();
        this.vao.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        this.vao.unbind();
    }

    @Override
    public void free() {
        this.vao.free();
        super.free();
    }

    public void bindVertexBuffer(int vbo) {
        this.vao.bindBufferToAllBindingPoint(vbo);
    }

    public void unbindVertexBuffer() {
        this.vao.unbindBuffersFromAllBindingPoint();
    }

    public void fillUniformData(Mat4f combinedMatrix, int lightmapBindPoint, int worldYOffset, int vanillaDrawDistance) {
        super.bind();
        vanillaDrawDistance += 32;
        this.setUniform(this.combinedMatUniform, combinedMatrix);
        this.setUniform(this.mircoOffsetUniform, 0.01f);
        this.setUniform(this.lightMapUniform, lightmapBindPoint);
        if (this.worldYOffsetUniform != -1) {
            this.setUniform(this.worldYOffsetUniform, (float)worldYOffset);
        }
        this.setUniform(this.whiteWorldUniform, Config.Client.Advanced.Debugging.enableWhiteWorld.get());
    }

    public void setModelPos(Vec3f modelPos) {
        this.setUniform(this.modelOffsetUniform, modelPos);
    }
}

