/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.vertexAttribute;

import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttribute;
import org.lwjgl.opengl.GL43;

public final class VertexAttributePostGL43
extends VertexAttribute {
    int numberOfBindingPoints = 0;
    int strideSize = 0;

    @Override
    public void bindBufferToAllBindingPoint(int buffer) {
        for (int i = 0; i < this.numberOfBindingPoints; ++i) {
            GL43.glBindVertexBuffer((int)i, (int)buffer, (long)0L, (int)this.strideSize);
        }
    }

    @Override
    public void bindBufferToBindingPoint(int buffer, int bindingPoint) {
        GL43.glBindVertexBuffer((int)bindingPoint, (int)buffer, (long)0L, (int)this.strideSize);
    }

    @Override
    public void unbindBuffersFromAllBindingPoint() {
        for (int i = 0; i < this.numberOfBindingPoints; ++i) {
            GL43.glBindVertexBuffer((int)i, (int)0, (long)0L, (int)0);
        }
    }

    @Override
    public void unbindBuffersFromBindingPoint(int bindingPoint) {
        GL43.glBindVertexBuffer((int)bindingPoint, (int)0, (long)0L, (int)0);
    }

    @Override
    public void setVertexAttribute(int bindingPoint, int attributeIndex, VertexAttribute.VertexPointer attribute) {
        if (attribute.useInteger) {
            GL43.glVertexAttribIFormat((int)attributeIndex, (int)attribute.elementCount, (int)attribute.glType, (int)this.strideSize);
        } else {
            GL43.glVertexAttribFormat((int)attributeIndex, (int)attribute.elementCount, (int)attribute.glType, (boolean)attribute.normalized, (int)this.strideSize);
        }
        this.strideSize += attribute.byteSize;
        if (this.numberOfBindingPoints <= bindingPoint) {
            this.numberOfBindingPoints = bindingPoint + 1;
        }
        GL43.glVertexAttribBinding((int)attributeIndex, (int)bindingPoint);
        GL43.glEnableVertexAttribArray((int)attributeIndex);
    }

    @Override
    public void completeAndCheck(int expectedStrideSize) {
        if (this.strideSize != expectedStrideSize) {
            GLProxy.GL_LOGGER.error("Vertex Attribute calculated stride size " + this.strideSize + " does not match the provided expected stride size " + expectedStrideSize + "!", new Object[0]);
            throw new IllegalArgumentException("Vertex Attribute Incorrect Format");
        }
        GLProxy.GL_LOGGER.info("Vertex Attribute (GL43+) completed. It contains " + this.numberOfBindingPoints + " binding points and a stride size of " + this.strideSize, new Object[0]);
    }
}

