/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.vertexAttribute;

import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePostGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePreGL43;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import org.lwjgl.opengl.GL32;

public abstract class VertexAttribute {
    public final int id = GL32.glGenVertexArrays();

    protected VertexAttribute() {
        GL32.glBindVertexArray((int)this.id);
    }

    public static VertexAttribute create() {
        if (GLProxy.getInstance().VertexAttributeBufferBindingSupported) {
            return new VertexAttributePostGL43();
        }
        return new VertexAttributePreGL43();
    }

    public void bind() {
        GL32.glBindVertexArray((int)this.id);
    }

    public void unbind() {
        GL32.glBindVertexArray((int)0);
    }

    public void free() {
        GL32.glDeleteVertexArrays((int)this.id);
    }

    public abstract void bindBufferToAllBindingPoint(int var1);

    public abstract void bindBufferToBindingPoint(int var1, int var2);

    public abstract void unbindBuffersFromAllBindingPoint();

    public abstract void unbindBuffersFromBindingPoint(int var1);

    public abstract void setVertexAttribute(int var1, int var2, VertexPointer var3);

    public abstract void completeAndCheck(int var1);

    public static final class VertexPointer {
        public final int elementCount;
        public final int glType;
        public final boolean normalized;
        public final int byteSize;
        public final boolean useInteger;

        public VertexPointer(int elementCount, int glType, boolean normalized, int byteSize, boolean useInteger) {
            this.elementCount = elementCount;
            this.glType = glType;
            this.normalized = normalized;
            this.byteSize = byteSize;
            this.useInteger = useInteger;
        }

        public VertexPointer(int elementCount, int glType, boolean normalized, int byteSize) {
            this(elementCount, glType, normalized, byteSize, false);
        }

        private static int _align(int bytes) {
            return MathUtil.ceilDiv(bytes, 4) * 4;
        }

        public static VertexPointer addFloatPointer(boolean normalized) {
            return new VertexPointer(1, 5126, normalized, 4);
        }

        public static VertexPointer addVec2Pointer(boolean normalized) {
            return new VertexPointer(2, 5126, normalized, 8);
        }

        public static VertexPointer addVec3Pointer(boolean normalized) {
            return new VertexPointer(3, 5126, normalized, 12);
        }

        public static VertexPointer addVec4Pointer(boolean normalized) {
            return new VertexPointer(4, 5126, normalized, 16);
        }

        public static VertexPointer addUnsignedBytePointer(boolean normalized, boolean useInteger) {
            return new VertexPointer(1, 5121, normalized, 4, useInteger);
        }

        public static VertexPointer addUnsignedBytesPointer(int elementCount, boolean normalized, boolean useInteger) {
            return new VertexPointer(elementCount, 5121, normalized, VertexPointer._align(elementCount), useInteger);
        }

        public static VertexPointer addUnsignedShortsPointer(int elementCount, boolean normalized, boolean useInteger) {
            return new VertexPointer(elementCount, 5123, normalized, VertexPointer._align(elementCount * 2), useInteger);
        }

        public static VertexPointer addShortsPointer(int elementCount, boolean normalized, boolean useInteger) {
            return new VertexPointer(elementCount, 5122, normalized, VertexPointer._align(elementCount * 2), useInteger);
        }

        public static VertexPointer addIntPointer(boolean normalized, boolean useInteger) {
            return new VertexPointer(1, 5124, normalized, 4, useInteger);
        }

        public static VertexPointer addIvec2Pointer(boolean normalized, boolean useInteger) {
            return new VertexPointer(2, 5124, normalized, 8, useInteger);
        }

        public static VertexPointer addIvec3Pointer(boolean normalized, boolean useInteger) {
            return new VertexPointer(3, 5124, normalized, 12, useInteger);
        }

        public static VertexPointer addIvec4Pointer(boolean normalized, boolean useInteger) {
            return new VertexPointer(4, 5124, normalized, 16, useInteger);
        }
    }
}

