/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.buffer;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.enums.EGLProxyContext;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.math.UnitBytes;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL44;

public class GLBuffer
implements AutoCloseable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    public static final double BUFFER_EXPANSION_MULTIPLIER = 1.3;
    public static final double BUFFER_SHRINK_TRIGGER = 1.6900000000000002;
    public static AtomicInteger count = new AtomicInteger(0);
    protected int id;
    protected int size = 0;
    protected boolean bufferStorage;
    protected boolean isMapped = false;

    public final int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public final boolean isBufferStorage() {
        return this.bufferStorage;
    }

    public GLBuffer(boolean isBufferStorage) {
        this.create(isBufferStorage);
    }

    public int getBufferBindingTarget() {
        return 36662;
    }

    public void bind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
    }

    public void unbind() {
        GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)0);
    }

    protected void create(boolean asBufferStorage) {
        LodUtil.assertTrue(GLProxy.getInstance().getGlContext() != EGLProxyContext.NONE, "Thread [{}] tried to create a GLBuffer outside a OpenGL context.", Thread.currentThread());
        this.id = GL32.glGenBuffers();
        this.bufferStorage = asBufferStorage;
        count.getAndIncrement();
    }

    protected void destroy(boolean async) {
        LodUtil.assertTrue(this.id != 0, "Buffer double close!");
        if (async && GLProxy.getInstance().getGlContext() != EGLProxyContext.PROXY_WORKER) {
            GLProxy.getInstance().recordOpenGlCall(() -> this.destroy(false));
        } else {
            GL32.glDeleteBuffers((int)this.id);
            this.id = 0;
            this.size = 0;
            if (count.decrementAndGet() == 0) {
                LOGGER.info("All GLBuffer is freed.");
            }
        }
    }

    protected void uploadBufferStorage(ByteBuffer bb, int bufferStorageHint) {
        LodUtil.assertTrue(this.bufferStorage, "Buffer is not bufferStorage but its trying to use bufferStorage upload method!");
        int bbSize = bb.limit() - bb.position();
        this.destroy(false);
        this.create(true);
        this.bind();
        GL44.glBufferStorage((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)bufferStorageHint);
        this.size = bbSize;
    }

    protected void uploadBufferData(ByteBuffer bb, int bufferDataHint) {
        LodUtil.assertTrue(!this.bufferStorage, "Buffer is bufferStorage but its trying to use bufferData upload method!");
        int bbSize = bb.limit() - bb.position();
        GL32.glBufferData((int)this.getBufferBindingTarget(), (ByteBuffer)bb, (int)bufferDataHint);
        this.size = bbSize;
    }

    protected void uploadSubData(ByteBuffer bb, int maxExpansionSize, int bufferDataHint) {
        LodUtil.assertTrue(!this.bufferStorage, "Buffer is bufferStorage but its trying to use subData upload method!");
        int bbSize = bb.limit() - bb.position();
        if (this.size < bbSize || (double)this.size > (double)bbSize * 1.6900000000000002) {
            int newSize = (int)((double)bbSize * 1.3);
            if (newSize > maxExpansionSize) {
                newSize = maxExpansionSize;
            }
            GL32.glBufferData((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferDataHint);
            this.size = newSize;
        }
        GL32.glBufferSubData((int)this.getBufferBindingTarget(), (long)0L, (ByteBuffer)bb);
    }

    public void uploadBuffer(ByteBuffer bb, EGpuUploadMethod uploadMethod, int maxExpansionSize, int bufferHint) {
        LodUtil.assertTrue(!uploadMethod.useEarlyMapping, "UploadMethod signal that this should use Mapping instead of uploadBuffer!");
        int bbSize = bb.limit() - bb.position();
        LodUtil.assertTrue(bbSize <= maxExpansionSize, "maxExpansionSize is {} but buffer size is {}!", maxExpansionSize, bbSize);
        GLProxy.GL_LOGGER.debug("Uploading buffer with {}.", new UnitBytes(bbSize));
        if (bbSize == 0) {
            return;
        }
        boolean useBuffStorage = uploadMethod.useBufferStorage;
        if (useBuffStorage != this.bufferStorage) {
            this.destroy(false);
            this.create(useBuffStorage);
            this.bind();
        }
        switch (uploadMethod) {
            case AUTO: {
                LodUtil.assertNotReach("GpuUploadMethod AUTO must be resolved before call to uploadBuffer()!");
            }
            case BUFFER_STORAGE: {
                this.uploadBufferStorage(bb, bufferHint);
                break;
            }
            case DATA: {
                this.uploadBufferData(bb, bufferHint);
                break;
            }
            case SUB_DATA: {
                this.uploadSubData(bb, maxExpansionSize, bufferHint);
                break;
            }
            default: {
                LodUtil.assertNotReach("Unknown GpuUploadMethod!");
            }
        }
    }

    public ByteBuffer mapBuffer(int targetSize, EGpuUploadMethod uploadMethod, int maxExpensionSize, int bufferHint, int mapFlags) {
        LodUtil.assertTrue(targetSize != 0, "MapBuffer targetSize is 0");
        LodUtil.assertTrue(uploadMethod.useEarlyMapping, "Upload method must be one that use early mappings in order to call mapBuffer");
        LodUtil.assertTrue(!this.isMapped, "Buffer is already mapped");
        boolean useBuffStorage = uploadMethod.useBufferStorage;
        if (useBuffStorage != this.bufferStorage) {
            this.destroy(false);
            this.create(useBuffStorage);
        }
        this.bind();
        if (this.size < targetSize || (double)this.size > (double)targetSize * 1.6900000000000002) {
            int newSize = (int)((double)targetSize * 1.3);
            if (newSize > maxExpensionSize) {
                newSize = maxExpensionSize;
            }
            this.size = newSize;
            if (this.bufferStorage) {
                GL32.glDeleteBuffers((int)this.id);
                this.id = GL32.glGenBuffers();
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL32.glBindBuffer((int)this.getBufferBindingTarget(), (int)this.id);
                GL44.glBufferStorage((int)this.getBufferBindingTarget(), (long)newSize, (int)bufferHint);
            } else {
                GL32.glBufferData((int)34962, (long)newSize, (int)bufferHint);
            }
        }
        ByteBuffer vboBuffer = GL32.glMapBufferRange((int)34962, (long)0L, (long)targetSize, (int)mapFlags);
        this.isMapped = true;
        return vboBuffer;
    }

    public void unmapBuffer() {
        LodUtil.assertTrue(this.isMapped, "Buffer is not mapped");
        this.bind();
        GL32.glUnmapBuffer((int)this.getBufferBindingTarget());
        this.isMapped = false;
    }

    @Override
    public void close() {
        this.destroy(true);
    }

    public String toString() {
        return (this.bufferStorage ? "" : "Static-") + this.getClass().getSimpleName() + "[id:" + this.id + ",size:" + this.size + (this.isMapped ? ",MAPPED" : "") + "]";
    }
}

