/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject;

import com.seibel.distanthorizons.core.render.glObject.GLEnums;
import org.lwjgl.opengl.GL32;

public class GLState {
    private static final int FBO_MAX = 4;
    public int program;
    public int vao;
    public int vbo;
    public int ebo;
    public int[] fbo = new int[4];
    public int texture2D;
    public int activeTextureNumber;
    public int texture0;
    public int texture1;
    public boolean blend;
    public int blendEqRGB;
    public int blendEqAlpha;
    public int blendSrcColor;
    public int blendSrcAlpha;
    public int blendDstColor;
    public int blendDstAlpha;
    public boolean depth;
    public boolean writeToDepthBuffer;
    public int depthFunc;
    public boolean stencil;
    public int stencilFunc;
    public int stencilRef;
    public int stencilMask;
    public int[] view;
    public boolean cull;
    public int cullMode;
    public int polyMode;

    public GLState() {
        this.saveState();
    }

    public void saveState() {
        this.program = GL32.glGetInteger((int)35725);
        this.vao = GL32.glGetInteger((int)34229);
        this.vbo = GL32.glGetInteger((int)34964);
        this.ebo = GL32.glGetInteger((int)34965);
        GL32.glGetIntegerv((int)36006, (int[])this.fbo);
        this.texture2D = GL32.glGetInteger((int)32873);
        this.activeTextureNumber = GL32.glGetInteger((int)34016);
        GL32.glActiveTexture((int)33984);
        this.texture0 = GL32.glGetInteger((int)32873);
        GL32.glActiveTexture((int)33985);
        this.texture1 = GL32.glGetInteger((int)32873);
        GL32.glActiveTexture((int)this.activeTextureNumber);
        this.blend = GL32.glIsEnabled((int)3042);
        this.blendEqRGB = GL32.glGetInteger((int)32777);
        this.blendEqAlpha = GL32.glGetInteger((int)34877);
        this.blendSrcColor = GL32.glGetInteger((int)32969);
        this.blendSrcAlpha = GL32.glGetInteger((int)32971);
        this.blendDstColor = GL32.glGetInteger((int)32968);
        this.blendDstAlpha = GL32.glGetInteger((int)32970);
        this.depth = GL32.glIsEnabled((int)2929);
        this.writeToDepthBuffer = GL32.glGetInteger((int)2930) == 1;
        this.depthFunc = GL32.glGetInteger((int)2932);
        this.stencil = GL32.glIsEnabled((int)2960);
        this.stencilFunc = GL32.glGetInteger((int)2962);
        this.stencilRef = GL32.glGetInteger((int)2967);
        this.stencilMask = GL32.glGetInteger((int)2963);
        this.view = new int[4];
        GL32.glGetIntegerv((int)2978, (int[])this.view);
        this.cull = GL32.glIsEnabled((int)2884);
        this.cullMode = GL32.glGetInteger((int)2885);
        this.polyMode = GL32.glGetInteger((int)2880);
    }

    public String toString() {
        return "GLState{program=" + this.program + ", vao=" + this.vao + ", vbo=" + this.vbo + ", ebo=" + this.ebo + ", fbo=" + this.fbo[0] + ", text=" + GLEnums.getString(this.texture2D) + "@" + this.activeTextureNumber + ", text0=" + GLEnums.getString(this.texture0) + ", blend=" + this.blend + ", blendMode=" + GLEnums.getString(this.blendSrcColor) + "," + GLEnums.getString(this.blendDstColor) + ", depth=" + this.depth + ", depthFunc=" + GLEnums.getString(this.depthFunc) + ", stencil=" + this.stencil + ", stencilFunc=" + GLEnums.getString(this.stencilFunc) + ", stencilRef=" + this.stencilRef + ", stencilMask=" + this.stencilMask + ", view={x:" + this.view[0] + ", y:" + this.view[1] + ", w:" + this.view[2] + ", h:" + this.view[3] + "}, cull=" + this.cull + ", cullMode=" + GLEnums.getString(this.cullMode) + ", polyMode=" + GLEnums.getString(this.polyMode) + '}';
    }

    public void RestoreFrameBuffer() {
        GL32.glBindFramebuffer((int)36160, (int)0);
        for (int i = 0; i < 4; ++i) {
            int buffer = this.fbo[i];
            if (i > 0 && buffer == 0) break;
            GL32.glBindFramebuffer((int)36160, (int)(GL32.glIsFramebuffer((int)buffer) ? buffer : 0));
        }
    }

    public void restore() {
        this.RestoreFrameBuffer();
        if (this.blend) {
            GL32.glEnable((int)3042);
        } else {
            GL32.glDisable((int)3042);
        }
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)(GL32.glIsTexture((int)this.texture0) ? this.texture0 : 0));
        GL32.glActiveTexture((int)33985);
        GL32.glBindTexture((int)3553, (int)(GL32.glIsTexture((int)this.texture1) ? this.texture1 : 0));
        GL32.glActiveTexture((int)this.activeTextureNumber);
        GL32.glBindTexture((int)3553, (int)(GL32.glIsTexture((int)this.texture2D) ? this.texture2D : 0));
        GL32.glBindVertexArray((int)(GL32.glIsVertexArray((int)this.vao) ? this.vao : 0));
        GL32.glBindBuffer((int)34962, (int)(GL32.glIsBuffer((int)this.vbo) ? this.vbo : 0));
        GL32.glBindBuffer((int)34963, (int)(GL32.glIsBuffer((int)this.ebo) ? this.ebo : 0));
        GL32.glUseProgram((int)(GL32.glIsProgram((int)this.program) ? this.program : 0));
        GL32.glDepthMask((boolean)this.writeToDepthBuffer);
        GL32.glBlendEquationSeparate((int)this.blendEqRGB, (int)this.blendEqAlpha);
        GL32.glBlendFuncSeparate((int)this.blendSrcColor, (int)this.blendDstColor, (int)this.blendSrcAlpha, (int)this.blendDstAlpha);
        if (this.depth) {
            GL32.glEnable((int)2929);
        } else {
            GL32.glDisable((int)2929);
        }
        GL32.glDepthFunc((int)this.depthFunc);
        if (this.stencil) {
            GL32.glEnable((int)2960);
        } else {
            GL32.glDisable((int)2960);
        }
        GL32.glStencilFunc((int)this.stencilFunc, (int)this.stencilRef, (int)this.stencilMask);
        GL32.glViewport((int)this.view[0], (int)this.view[1], (int)this.view[2], (int)this.view[3]);
        if (this.cull) {
            GL32.glEnable((int)2884);
        } else {
            GL32.glDisable((int)2884);
        }
        GL32.glCullFace((int)this.cullMode);
        GL32.glPolygonMode((int)1032, (int)this.polyMode);
    }
}

