/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhLodUnit;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DhLodPos
implements Comparable<DhLodPos> {
    public final byte detailLevel;
    public final int x;
    public final int z;

    public DhLodPos(byte detailLevel, int x, int z) {
        this.detailLevel = detailLevel;
        this.x = x;
        this.z = z;
    }

    public DhLodPos(DhSectionPos sectionPos) {
        this(sectionPos.getDetailLevel(), sectionPos.getX(), sectionPos.getZ());
    }

    public DhLodUnit getX() {
        return new DhLodUnit(this.detailLevel, this.x);
    }

    public DhLodUnit getZ() {
        return new DhLodUnit(this.detailLevel, this.z);
    }

    public int getBlockWidth() {
        return this.getWidthAtDetail((byte)0);
    }

    public int getWidthAtDetail(byte targetLevel) {
        LodUtil.assertTrue(targetLevel <= this.detailLevel);
        return BitShiftUtil.powerOfTwo(this.detailLevel - targetLevel);
    }

    public DhBlockPos2D getCenterBlockPos() {
        return new DhBlockPos2D(this.getX().toBlockWidth() + BitShiftUtil.half(this.getBlockWidth()), this.getZ().toBlockWidth() + BitShiftUtil.half(this.getBlockWidth()));
    }

    public DhBlockPos2D getCornerBlockPos() {
        return new DhBlockPos2D(this.getX().toBlockWidth(), this.getZ().toBlockWidth());
    }

    public DhLodPos getCornerLodPos(byte newDetail) {
        LodUtil.assertTrue(newDetail <= this.detailLevel);
        return new DhLodPos(newDetail, this.x * BitShiftUtil.powerOfTwo(this.detailLevel - newDetail), this.z * BitShiftUtil.powerOfTwo(this.detailLevel - newDetail));
    }

    public DhLodPos getChildPosByIndex(int child0to3) throws IllegalArgumentException, IllegalStateException {
        if (child0to3 < 0 || child0to3 > 3) {
            throw new IllegalArgumentException("child0to3 must be between 0 and 3");
        }
        if (this.detailLevel <= 0) {
            throw new IllegalStateException("detailLevel must be greater than 0");
        }
        return new DhLodPos((byte)(this.detailLevel - 1), this.x * 2 + (child0to3 & 1), this.z * 2 + BitShiftUtil.half(child0to3 & 2));
    }

    public int getChildIndexOfParent() {
        return (this.x & 1) + BitShiftUtil.square(this.z & 1);
    }

    public DhLodPos getDhSectionRelativePositionForDetailLevel() throws IllegalArgumentException {
        return this.getDhSectionRelativePositionForDetailLevel(this.detailLevel);
    }

    public DhLodPos getDhSectionRelativePositionForDetailLevel(byte outputDetailLevel) throws IllegalArgumentException {
        int xInput = this.x;
        int zInput = this.z;
        byte detailLevelDifference = (byte)(outputDetailLevel - this.detailLevel);
        if (outputDetailLevel < this.detailLevel) {
            throw new IllegalArgumentException("The output Detail Level [" + outputDetailLevel + "] is less than this " + DhLodPos.class.getSimpleName() + "'s detail level [" + this.detailLevel + "].");
        }
        int blockOffset = BitShiftUtil.powerOfTwo(detailLevelDifference) - 1;
        int n = zInput < 0 ? -blockOffset : 0;
        int xRelativePos = (xInput += xInput < 0 ? -blockOffset : 0) / BitShiftUtil.powerOfTwo(detailLevelDifference);
        int zRelativePos = (zInput += n) / BitShiftUtil.powerOfTwo(detailLevelDifference);
        xRelativePos = xInput >= 0 ? xRelativePos % 64 : 63 + xRelativePos % 64;
        zRelativePos = zInput >= 0 ? zRelativePos % 64 : 63 + zRelativePos % 64;
        return new DhLodPos(outputDetailLevel, xRelativePos, zRelativePos);
    }

    public DhSectionPos getSectionPosWithSectionDetailLevel(byte sectionDetailLevel) throws IllegalArgumentException {
        if (sectionDetailLevel < this.detailLevel) {
            throw new IllegalArgumentException("The section Detail Level [" + sectionDetailLevel + "] is less than this " + DhLodPos.class.getSimpleName() + "'s detail level [" + this.detailLevel + "].");
        }
        DhLodPos lodPos = new DhLodPos(this.detailLevel, this.x, this.z);
        lodPos = lodPos.convertToDetailLevel(sectionDetailLevel);
        return new DhSectionPos(lodPos.detailLevel, lodPos.x, lodPos.z);
    }

    public DhLodPos convertToDetailLevel(byte newDetailLevel) {
        if (newDetailLevel >= this.detailLevel) {
            return new DhLodPos(newDetailLevel, Math.floorDiv(this.x, BitShiftUtil.powerOfTwo(newDetailLevel - this.detailLevel)), Math.floorDiv(this.z, BitShiftUtil.powerOfTwo(newDetailLevel - this.detailLevel)));
        }
        return new DhLodPos(newDetailLevel, this.x * BitShiftUtil.powerOfTwo(this.detailLevel - newDetailLevel), this.z * BitShiftUtil.powerOfTwo(this.detailLevel - newDetailLevel));
    }

    public boolean overlapsExactly(DhLodPos other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.detailLevel == other.detailLevel) {
            return false;
        }
        if (this.detailLevel > other.detailLevel) {
            return this.equals(other.convertToDetailLevel(this.detailLevel));
        }
        return other.equals(this.convertToDetailLevel(other.detailLevel));
    }

    public DhLodPos addLodUnit(DhLodUnit width) {
        if (width.detailLevel < this.detailLevel) {
            throw new IllegalArgumentException("add called with width.detailLevel < pos detail");
        }
        return new DhLodPos(this.detailLevel, this.x + width.createFromDetailLevel((byte)this.detailLevel).numberOfLodSectionsWide, this.z + width.createFromDetailLevel((byte)this.detailLevel).numberOfLodSectionsWide);
    }

    public DhLodPos addOffset(int xOffset, int zOffset) {
        return new DhLodPos(this.detailLevel, this.x + xOffset, this.z + zOffset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DhLodPos otherPos = (DhLodPos)obj;
        return this.detailLevel == otherPos.detailLevel && this.x == otherPos.x && this.z == otherPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.detailLevel, this.x, this.z);
    }

    @Override
    public int compareTo(@NotNull DhLodPos obj) {
        if (this.detailLevel != obj.detailLevel) {
            return Integer.compare(this.detailLevel, obj.detailLevel);
        }
        if (this.x != obj.x) {
            return Integer.compare(this.x, obj.x);
        }
        return Integer.compare(this.z, obj.z);
    }

    public String toString() {
        return "[" + this.detailLevel + "*" + this.x + "," + this.z + "]";
    }
}

