/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import java.util.Objects;
import javax.annotation.Nullable;

public class DhBlockPos {
    public static final boolean DO_CHECKS = false;
    public static final int PACKED_X_LENGTH = 26;
    public static final int PACKED_Z_LENGTH = 26;
    public static final int PACKED_Y_LENGTH = 12;
    public static final long PACKED_X_MASK = 0x3FFFFFFL;
    public static final long PACKED_Y_MASK = 4095L;
    public static final long PACKED_Z_MASK = 0x3FFFFFFL;
    public static final int PACKED_Y_OFFSET = 0;
    public static final int PACKED_Z_OFFSET = 12;
    public static final int PACKED_X_OFFSET = 38;
    public int x;
    public int y;
    public int z;

    public DhBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DhBlockPos() {
        this(0, 0, 0);
    }

    public DhBlockPos(DhBlockPos pos) {
        this(pos.x, pos.y, pos.z);
    }

    public DhBlockPos(DhBlockPos2D pos, int y) {
        this(pos.x, y, pos.z);
    }

    @Deprecated
    public int getX() {
        return this.x;
    }

    @Deprecated
    public int getY() {
        return this.y;
    }

    @Deprecated
    public int getZ() {
        return this.z;
    }

    public static long asLong(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 38 | ((long)y & 0xFFFL) << 0 | ((long)z & 0x3FFFFFFL) << 12;
    }

    public static int getX(long packed) {
        return (int)(packed << 0 >> 38);
    }

    public static int getY(long packed) {
        return (int)(packed << 52 >> 52);
    }

    public static int getZ(long packed) {
        return (int)(packed << 26 >> 38);
    }

    public DhBlockPos(long packed) {
        this(DhBlockPos.getX(packed), DhBlockPos.getY(packed), DhBlockPos.getZ(packed));
    }

    public long asLong() {
        return DhBlockPos.asLong(this.x, this.y, this.z);
    }

    public DhBlockPos offset(EDhDirection direction) {
        return this.mutateOffset(direction, null);
    }

    public DhBlockPos mutateOffset(EDhDirection direction, @Nullable DhBlockPos mutablePos) {
        return this.mutateOffset(direction.getNormal().x, direction.getNormal().y, direction.getNormal().z, mutablePos);
    }

    public DhBlockPos offset(int x, int y, int z) {
        return this.mutateOffset(x, y, z, null);
    }

    public DhBlockPos mutateOffset(int x, int y, int z, @Nullable DhBlockPos mutablePos) {
        int newX = this.x + x;
        int newY = this.y + y;
        int newZ = this.z + z;
        if (mutablePos != null) {
            mutablePos.x = newX;
            mutablePos.y = newY;
            mutablePos.z = newZ;
            return mutablePos;
        }
        return new DhBlockPos(newX, newY, newZ);
    }

    public DhBlockPos convertToChunkRelativePos() {
        return this.mutateToChunkRelativePos(null);
    }

    public DhBlockPos mutateToChunkRelativePos(@Nullable DhBlockPos mutableBlockPos) {
        int relX = this.x % 16;
        relX = relX < 0 ? relX + 16 : relX;
        int relZ = this.z % 16;
        int n = relZ = relZ < 0 ? relZ + 16 : relZ;
        if (mutableBlockPos != null) {
            mutableBlockPos.x = relX;
            mutableBlockPos.y = this.y;
            mutableBlockPos.z = relZ;
            return mutableBlockPos;
        }
        return new DhBlockPos(relX, this.y, relZ);
    }

    public int getManhattanDistance(DhBlockPos otherPos) {
        return Math.abs(this.getX() - otherPos.getX()) + Math.abs(this.getY() - otherPos.getY()) + Math.abs(this.getZ() - otherPos.getZ());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DhBlockPos that = (DhBlockPos)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "DHBlockPos[" + this.x + ", " + this.y + ", " + this.z + ']';
    }

    public static void _DebugCheckPacker(int x, int y, int z, long expected) {
        long packed = DhBlockPos.asLong(x, y, z);
        if (packed != expected) {
            throw new IllegalArgumentException("Packed values don't match: " + packed + " != " + expected);
        }
        DhBlockPos pos = new DhBlockPos(packed);
        if (pos.getX() != x || pos.getY() != y || pos.getZ() != z) {
            throw new IllegalArgumentException("Values after decode don't match: " + pos + " != " + x + ", " + y + ", " + z);
        }
    }
}

