/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.fullDatafile.RemoteFullDataFileHandler;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.DhLevel;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DhClientLevel
extends DhLevel
implements IDhClientLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final ClientLevelModule clientside;
    public final IClientLevelWrapper levelWrapper;
    public final AbstractSaveStructure saveStructure;
    public final RemoteFullDataFileHandler dataFileHandler;

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper) {
        this(saveStructure, clientLevelWrapper, null, true);
    }

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable File fullDataSaveDirOverride, boolean enableRendering) {
        this.levelWrapper = clientLevelWrapper;
        this.saveStructure = saveStructure;
        this.dataFileHandler = new RemoteFullDataFileHandler(this, saveStructure, fullDataSaveDirOverride);
        this.clientside = new ClientLevelModule(this);
        if (enableRendering) {
            this.clientside.startRenderer();
            LOGGER.info("Started DHLevel for " + this.levelWrapper + " with saves at " + this.saveStructure);
        }
    }

    @Override
    public void clientTick() {
        this.chunkToLodBuilder.tick();
        this.clientside.clientTick();
    }

    @Override
    public void render(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        this.clientside.render(mcModelViewMatrix, mcProjectionMatrix, partialTicks, profiler);
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        return this.levelWrapper.computeBaseColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public CompletableFuture<Void> saveAsync() {
        return CompletableFuture.allOf(this.clientside.saveAsync(), this.dataFileHandler.flushAndSave());
    }

    @Override
    public void saveWrites(ChunkSizedFullDataAccessor data) {
        this.clientside.writeChunkDataToFile(data);
    }

    @Override
    public int getMinY() {
        return this.levelWrapper.getMinHeight();
    }

    @Override
    public void close() {
        this.clientside.close();
        super.close();
        this.dataFileHandler.close();
        LOGGER.info("Closed " + DhClientLevel.class.getSimpleName() + " for " + this.levelWrapper);
    }

    @Override
    public IFullDataSourceProvider getFileHandler() {
        return this.dataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.saveStructure;
    }
}

