/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.enums.rendering.EDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.renderfile.RenderSourceFileHandler;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public class ClientLevelModule
implements Closeable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private final IDhClientLevel parentClientLevel;
    public final AtomicReference<ClientRenderState> ClientRenderStateRef = new AtomicReference();
    public final F3Screen.NestedMessage f3Message;
    private EDebugRendering lastDebugRendering = EDebugRendering.OFF;

    public ClientLevelModule(IDhClientLevel parentClientLevel) {
        this.parentClientLevel = parentClientLevel;
        this.f3Message = new F3Screen.NestedMessage(this::f3Log);
    }

    public void clientTick() {
        if (!MC_CLIENT.playerExists()) {
            return;
        }
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState == null) {
            return;
        }
        if (clientRenderState.quadtree.blockRenderDistanceRadius != Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistance.get() * 16) {
            if (!this.ClientRenderStateRef.compareAndSet(clientRenderState, null)) {
                return;
            }
            clientRenderState.close();
            clientRenderState = new ClientRenderState(this.parentClientLevel, this.parentClientLevel.getFileHandler(), this.parentClientLevel.getSaveStructure());
            if (!this.ClientRenderStateRef.compareAndSet(null, clientRenderState)) {
                LOGGER.warn("Failed to set render state due to concurrency after changing view distance");
                clientRenderState.close();
                return;
            }
        }
        clientRenderState.quadtree.tick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
        boolean isBuffersDirty = false;
        EDebugRendering newDebugRendering = Config.Client.Advanced.Debugging.debugRendering.get();
        if (newDebugRendering != this.lastDebugRendering) {
            this.lastDebugRendering = newDebugRendering;
            isBuffersDirty = true;
        }
        if (isBuffersDirty) {
            clientRenderState.renderer.bufferHandler.MarkAllBuffersDirty();
        }
    }

    public boolean startRenderer() {
        ClientRenderState ClientRenderState2 = new ClientRenderState(this.parentClientLevel, this.parentClientLevel.getFileHandler(), this.parentClientLevel.getSaveStructure());
        if (!this.ClientRenderStateRef.compareAndSet(null, ClientRenderState2)) {
            LOGGER.warn("Failed to start renderer due to concurrency");
            ClientRenderState2.close();
            return false;
        }
        return true;
    }

    public boolean isRendering() {
        return this.ClientRenderStateRef.get() != null;
    }

    public void render(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            return;
        }
        ClientRenderState2.renderer.drawLODs(mcModelViewMatrix, mcProjectionMatrix, partialTicks, profiler);
    }

    public void stopRenderer() {
        LOGGER.info("Stopping renderer for " + this);
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            LOGGER.warn("Tried to stop renderer for " + this + " when it was not started!");
            return;
        }
        while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null)) {
            ClientRenderState2 = this.ClientRenderStateRef.get();
            if (ClientRenderState2 != null) continue;
            return;
        }
        ClientRenderState2.close();
    }

    public void writeChunkDataToFile(ChunkSizedFullDataAccessor data) {
        DhSectionPos pos = data.getSectionPos().convertNewToDetailLevel((byte)6);
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            ClientRenderState2.renderSourceFileHandler.writeChunkDataToFile(pos, data);
        } else {
            this.parentClientLevel.getFileHandler().writeChunkDataToFile(pos, data);
        }
    }

    public CompletableFuture<Void> saveAsync() {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            return ClientRenderState2.renderSourceFileHandler.flushAndSaveAsync();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null) && (ClientRenderState2 = this.ClientRenderStateRef.get()) != null) {
            }
            if (ClientRenderState2 != null) {
                ClientRenderState2.close();
            }
        }
        this.f3Message.close();
    }

    public void dumpRamUsage() {
    }

    protected String[] f3Log() {
        String dimName = this.parentClientLevel.getClientLevelWrapper().getDimensionType().getDimensionName();
        ClientRenderState renderState = this.ClientRenderStateRef.get();
        if (renderState == null) {
            return new String[]{"level @ " + dimName + ": Inactive"};
        }
        return new String[]{"level @ " + dimName + ": Active"};
    }

    public void clearRenderCache() {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null && ClientRenderState2.quadtree != null) {
            ClientRenderState2.quadtree.clearRenderDataCache();
        }
    }

    public void reloadPos(DhSectionPos pos) {
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState != null && clientRenderState.quadtree != null) {
            clientRenderState.quadtree.reloadPos(pos);
        }
    }

    public static class ClientRenderState {
        private static final Logger LOGGER = DhLoggerBuilder.getLogger();
        private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
        public final ILevelWrapper levelWrapper;
        public final LodQuadTree quadtree;
        public final RenderSourceFileHandler renderSourceFileHandler;
        public final LodRenderer renderer;

        public ClientRenderState(IDhClientLevel dhClientLevel, IFullDataSourceProvider fullDataSourceProvider, AbstractSaveStructure saveStructure) {
            this.levelWrapper = dhClientLevel.getLevelWrapper();
            this.renderSourceFileHandler = new RenderSourceFileHandler(fullDataSourceProvider, dhClientLevel, saveStructure);
            this.quadtree = new LodQuadTree(dhClientLevel, Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistance.get() * 16, 0, 0, this.renderSourceFileHandler);
            RenderBufferHandler renderBufferHandler = new RenderBufferHandler(this.quadtree);
            this.renderer = new LodRenderer(renderBufferHandler);
        }

        public void close() {
            LOGGER.info("Shutting down " + ClientRenderState.class.getSimpleName());
            this.renderer.close();
            this.quadtree.close();
            this.renderSourceFileHandler.close();
        }
    }
}

