/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

public enum Platform {
    WINDOWS("Windows", false),
    LINUX("Linux", true),
    MACOS("macOS", true),
    BSD("BSD", true),
    UNIX("Unix", true);

    private static final Platform current;
    private final String name;
    private final boolean isUnix;

    private Platform(String name, boolean isUnix) {
        this.name = name;
        this.isUnix = isUnix;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnix() {
        return this.isUnix;
    }

    public static Platform get() {
        return current;
    }

    public static Architecture getArchitecture() {
        return Architecture.current;
    }

    public String toString() {
        return this.getName();
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            current = WINDOWS;
        } else if (osName.contains("linux")) {
            current = LINUX;
        } else if (osName.contains("mac") || osName.contains("darwin")) {
            current = MACOS;
        } else if (osName.startsWith("bsd")) {
            current = BSD;
        } else if (osName.startsWith("unix")) {
            current = UNIX;
        } else {
            throw new LinkageError("Unknown platform: " + osName);
        }
    }

    public static final class Architecture
    extends Enum<Architecture> {
        public static final /* enum */ Architecture X86;
        public static final /* enum */ Architecture X64;
        public static final /* enum */ Architecture ARM32;
        public static final /* enum */ Architecture ARM64;
        static final Architecture current;
        final boolean is64Bit;
        private static final /* synthetic */ Architecture[] $VALUES;

        public static Architecture[] values() {
            return (Architecture[])$VALUES.clone();
        }

        public static Architecture valueOf(String name) {
            return Enum.valueOf(Architecture.class, name);
        }

        private Architecture(boolean is64Bit) {
            this.is64Bit = is64Bit;
        }

        private static /* synthetic */ Architecture[] $values() {
            return new Architecture[]{X86, X64, ARM32, ARM64};
        }

        static {
            boolean is64Bit;
            X86 = new Architecture(false);
            X64 = new Architecture(true);
            ARM32 = new Architecture(false);
            ARM64 = new Architecture(true);
            $VALUES = Architecture.$values();
            String osArch = System.getProperty("os.arch");
            boolean bl = is64Bit = osArch.contains("64") || osArch.startsWith("armv8");
            current = osArch.startsWith("arm") || osArch.startsWith("aarch64") ? (is64Bit ? ARM64 : ARM32) : (is64Bit ? X64 : X86);
        }
    }
}

