/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar;

import com.seibel.distanthorizons.core.jar.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Pattern;

public class DarkModeDetector {
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    public static boolean isDarkMode() {
        switch (Platform.get()) {
            case WINDOWS: {
                return DarkModeDetector.isWindowsDarkMode();
            }
            case MACOS: {
                return DarkModeDetector.isMacOsDarkMode();
            }
            case LINUX: 
            case BSD: 
            case UNIX: {
                return DarkModeDetector.checkLinuxDark();
            }
        }
        return false;
    }

    public static boolean isMacOsDarkMode() {
        boolean isDarkMode = false;
        String line = DarkModeDetector.query("defaults read -g AppleInterfaceStyle");
        if (line.equals("Dark")) {
            isDarkMode = true;
        }
        return isDarkMode;
    }

    public static boolean isWindowsDarkMode() {
        try {
            String result = DarkModeDetector.query(DARK_THEME_CMD);
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return false;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkLinuxDark() {
        File de_location = new File("/usr/bin");
        for (String de : de_location.list()) {
            if (de.contains("gnome-session")) {
                return DarkModeDetector.GTKChecker();
            }
            if (!de.contains("plasma_session")) continue;
            return DarkModeDetector.QTChecker();
        }
        return DarkModeDetector.GTKChecker();
    }

    public static boolean GTKChecker() {
        Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
        return darkThemeNamePattern.matcher(DarkModeDetector.query("gsettings get org.gnome.desktop.interface color-scheme")).matches();
    }

    public static boolean QTChecker() {
        try {
            File themeFile = new File(System.getProperty("user.home") + "/.config/Trolltech.conf");
            BufferedReader reader = new BufferedReader(new FileReader(themeFile));
            String themeLine = reader.readLine();
            while (themeLine != null && !themeLine.contains("KWinPalette\\activeBackground")) {
                themeLine = reader.readLine();
            }
            reader.close();
            short index = (short)themeLine.indexOf("#");
            short r = (short)Integer.parseInt("" + themeLine.charAt(index + 1) + themeLine.charAt(index + 2), 16);
            short g = (short)Integer.parseInt("" + themeLine.charAt(index + 3) + themeLine.charAt(index + 4), 16);
            short b = (short)Integer.parseInt("" + themeLine.charAt(index + 5) + themeLine.charAt(index + 6), 16);
            return (r + g + b) / 2 < 128;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String query(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String actualReadLine;
                while ((actualReadLine = reader.readLine()) != null) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append(actualReadLine);
                }
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            System.out.println("Exception caught while querying the OS:");
            e.printStackTrace();
            return "";
        }
    }
}

