/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.IDhApiWorldGenerator;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataFileHandler;
import com.seibel.distanthorizons.core.generation.IWorldGenerationQueue;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.InProgressWorldGenTaskGroup;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTask;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenTaskGroup;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.DhThreadFactory;
import com.seibel.distanthorizons.core.util.objects.RateLimitedThreadPoolExecutor;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;

public class WorldGenerationQueue
implements IWorldGenerationQueue,
IDebugRenderable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final DhThreadFactory THREAD_FACTORY = new DhThreadFactory(ThreadUtil.THREAD_NAME_PREFIX + "World-Gen-Worker-Thread", 1);
    private final IDhApiWorldGenerator generator;
    private final ConcurrentHashMap<DhSectionPos, WorldGenTask> waitingTasks = new ConcurrentHashMap();
    private final ConcurrentHashMap<DhSectionPos, InProgressWorldGenTaskGroup> inProgressGenTasksByLodPos = new ConcurrentHashMap();
    public final byte maxGranularity;
    public final byte minGranularity;
    public final byte lowestDataDetail;
    public final byte highestDataDetail;
    private volatile CompletableFuture<Void> generatorClosingFuture = null;
    private final ExecutorService queueingThread = ThreadUtil.makeSingleThreadPool("World Gen Queue");
    private boolean generationQueueRunning = false;
    private DhBlockPos2D generationTargetPos = DhBlockPos2D.ZERO;
    private int numberOfTasksQueued = 0;
    private static final int MAX_ALREADY_GENERATED_COUNT = 100;
    private final HashMap<DhSectionPos, StackTraceElement[]> alreadyGeneratedPosHashSet = new HashMap(100);
    private final Queue<DhSectionPos> alreadyGeneratedPosQueue = new LinkedList<DhSectionPos>();
    private static RateLimitedThreadPoolExecutor worldGeneratorThreadPool;
    private static ConfigChangeListener<Integer> configListener;

    @Override
    public byte lowestDataDetail() {
        return this.lowestDataDetail;
    }

    @Override
    public byte highestDataDetail() {
        return this.highestDataDetail;
    }

    public WorldGenerationQueue(IDhApiWorldGenerator generator) {
        LOGGER.info("Creating world gen queue");
        this.generator = generator;
        this.maxGranularity = generator.getMaxGenerationGranularity();
        this.minGranularity = generator.getMinGenerationGranularity();
        this.lowestDataDetail = generator.getLargestDataDetailLevel();
        this.highestDataDetail = generator.getSmallestDataDetailLevel();
        if (this.minGranularity < 4) {
            throw new IllegalArgumentException(IDhApiWorldGenerator.class.getSimpleName() + ": min granularity must be at least 4 (Chunk sized)!");
        }
        if (this.maxGranularity < this.minGranularity) {
            throw new IllegalArgumentException(IDhApiWorldGenerator.class.getSimpleName() + ": max granularity smaller than min granularity!");
        }
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
        LOGGER.info("Created world gen queue");
    }

    @Override
    public CompletableFuture<WorldGenResult> submitGenTask(DhSectionPos pos, byte requiredDataDetail, IWorldGenTaskTracker tracker) {
        if (this.generatorClosingFuture != null) {
            return CompletableFuture.completedFuture(WorldGenResult.CreateFail());
        }
        if (requiredDataDetail < this.highestDataDetail) {
            throw new UnsupportedOperationException("Current generator does not meet requiredDataDetail level");
        }
        if (requiredDataDetail > this.lowestDataDetail) {
            requiredDataDetail = this.lowestDataDetail;
        }
        LodUtil.assertTrue(pos.getDetailLevel() > requiredDataDetail + 4);
        CompletableFuture<WorldGenResult> future = new CompletableFuture<WorldGenResult>();
        this.waitingTasks.put(pos, new WorldGenTask(pos, requiredDataDetail, tracker, future));
        return future;
    }

    @Override
    public void cancelGenTasks(Iterable<DhSectionPos> positions) {
    }

    @Override
    public void startGenerationQueueAndSetTargetPos(DhBlockPos2D targetPos) {
        this.generationTargetPos = targetPos;
        if (!this.generationQueueRunning) {
            this.startWorldGenQueuingThread();
        }
    }

    private void startWorldGenQueuingThread() {
        this.generationQueueRunning = true;
        this.queueingThread.execute(() -> {
            try {
                while (!Thread.interrupted()) {
                    this.generator.preGeneratorTaskStart();
                    boolean taskStarted = true;
                    while (!this.generator.isBusy() && taskStarted) {
                        taskStarted = this.startNextWorldGenTask(this.generationTargetPos);
                        if (taskStarted) continue;
                        boolean bl = false;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException taskStarted) {
            }
            catch (Exception e) {
                LOGGER.error("queueing exception: " + e.getMessage(), (Throwable)e);
                this.generationQueueRunning = false;
            }
        });
    }

    private boolean startNextWorldGenTask(DhBlockPos2D targetPos) {
        if (this.waitingTasks.size() == 0) {
            return false;
        }
        this.waitingTasks.forEach((pos, task) -> {
            if (!task.StillValid()) {
                this.waitingTasks.remove(pos);
                task.future.complete(WorldGenResult.CreateFail());
            }
        });
        Mapper closestTaskMap = this.waitingTasks.reduceEntries(1024L, entry -> new Mapper((WorldGenTask)entry.getValue(), ((WorldGenTask)entry.getValue()).pos.getSectionBBoxPos().getCenterBlockPos().toPos2D().chebyshevDist(targetPos.toPos2D())), (aMapper, bMapper) -> aMapper.dist < bMapper.dist ? aMapper : bMapper);
        WorldGenTask closestTask = closestTaskMap.task;
        this.waitingTasks.remove(closestTask.pos, closestTask);
        if (this.canGeneratePos((byte)0, closestTask.pos)) {
            WorldGenTaskGroup closestTaskGroup = new WorldGenTaskGroup(closestTask.pos, 0);
            closestTaskGroup.worldGenTasks.add(closestTask);
            InProgressWorldGenTaskGroup newInProgressTask = new InProgressWorldGenTaskGroup(closestTaskGroup);
            InProgressWorldGenTaskGroup previousInProgressTask = this.inProgressGenTasksByLodPos.putIfAbsent(closestTask.pos, newInProgressTask);
            if (previousInProgressTask == null) {
                this.startWorldGenTaskGroup(newInProgressTask);
            } else {
                LOGGER.trace("A task already exists for this position, todo: " + closestTask.pos);
            }
            return true;
        }
        LinkedList<CompletableFuture<WorldGenResult>> childFutures = new LinkedList<CompletableFuture<WorldGenResult>>();
        DhSectionPos sectionPos = new DhSectionPos(closestTask.pos.getDetailLevel(), closestTask.pos.getX(), closestTask.pos.getZ());
        WorldGenTask finalClosestTask = closestTask;
        sectionPos.forEachChild(childDhSectionPos -> {
            CompletableFuture<WorldGenResult> newFuture = new CompletableFuture<WorldGenResult>();
            childFutures.add(newFuture);
            WorldGenTask newGenTask = new WorldGenTask((DhSectionPos)childDhSectionPos, childDhSectionPos.getDetailLevel(), finalClosestTask.taskTracker, newFuture);
            this.waitingTasks.put(newGenTask.pos, newGenTask);
        });
        closestTask.future.complete(WorldGenResult.CreateSplit(childFutures));
        return true;
    }

    private void startWorldGenTaskGroup(InProgressWorldGenTaskGroup inProgressTaskGroup) {
        byte taskDetailLevel = inProgressTaskGroup.group.dataDetail;
        DhSectionPos taskPos = inProgressTaskGroup.group.pos;
        byte granularity = (byte)(taskPos.getDetailLevel() - taskDetailLevel);
        LodUtil.assertTrue(granularity >= this.minGranularity && granularity <= this.maxGranularity);
        LodUtil.assertTrue(taskDetailLevel >= this.highestDataDetail && taskDetailLevel <= this.lowestDataDetail);
        DhChunkPos chunkPosMin = new DhChunkPos(taskPos.getSectionBBoxPos().getCornerBlockPos());
        if (this.alreadyGeneratedPosHashSet.containsKey(inProgressTaskGroup.group.pos)) {
            LOGGER.trace("Duplicate generation section " + taskPos + " with granularity [" + granularity + "] at " + chunkPosMin + ". Skipping...");
            inProgressTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateSuccess(new DhSectionPos(granularity, taskPos.getX(), taskPos.getZ()))));
            return;
        }
        this.alreadyGeneratedPosHashSet.put(inProgressTaskGroup.group.pos, Thread.currentThread().getStackTrace());
        this.alreadyGeneratedPosQueue.add(inProgressTaskGroup.group.pos);
        while (this.alreadyGeneratedPosQueue.size() > 100) {
            DhSectionPos posToRemove = this.alreadyGeneratedPosQueue.poll();
            this.alreadyGeneratedPosHashSet.remove(posToRemove);
        }
        ++this.numberOfTasksQueued;
        inProgressTaskGroup.genFuture = this.startGenerationEvent(chunkPosMin, granularity, taskDetailLevel, inProgressTaskGroup.group::consumeChunkData);
        inProgressTaskGroup.genFuture.whenComplete((voidObj, exception) -> {
            --this.numberOfTasksQueued;
            if (exception != null) {
                if (!LodUtil.isInterruptOrReject(exception)) {
                    LOGGER.error("Error generating data for section " + taskPos, exception);
                }
                inProgressTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateFail()));
            } else {
                inProgressTaskGroup.group.worldGenTasks.forEach(worldGenTask -> worldGenTask.future.complete(WorldGenResult.CreateSuccess(new DhSectionPos(granularity, taskPos.getX(), taskPos.getZ()))));
            }
            boolean worked = this.inProgressGenTasksByLodPos.remove(taskPos, inProgressTaskGroup);
            LodUtil.assertTrue(worked);
        });
    }

    private CompletableFuture<Void> startGenerationEvent(DhChunkPos chunkPosMin, byte granularity, byte targetDataDetail, Consumer<ChunkSizedFullDataAccessor> chunkDataConsumer) {
        EDhApiDistantGeneratorMode generatorMode = Config.Client.Advanced.WorldGenerator.distantGeneratorMode.get();
        return this.generator.generateChunks(chunkPosMin.x, chunkPosMin.z, granularity, targetDataDetail, generatorMode, worldGeneratorThreadPool, generatedObjectArray -> {
            try {
                IChunkWrapper chunk = SingletonInjector.INSTANCE.get(IWrapperFactory.class).createChunkWrapper((Object[])generatedObjectArray);
                chunkDataConsumer.accept(LodDataBuilder.createChunkData(chunk));
            }
            catch (ClassCastException e) {
                DhLoggerBuilder.getLogger().error("World generator return type incorrect. Error: [" + e.getMessage() + "]. World generator disabled.", (Throwable)e);
                Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
            }
        });
    }

    public static void setupWorldGenThreadPool() {
        if (configListener == null) {
            configListener = new ConfigChangeListener<Integer>(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads, threadCount -> WorldGenerationQueue.setThreadPoolSize(threadCount));
        }
        if (worldGeneratorThreadPool == null || worldGeneratorThreadPool.isTerminated()) {
            LOGGER.info("Starting " + FullDataFileHandler.class.getSimpleName());
            WorldGenerationQueue.setThreadPoolSize(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads.get());
        }
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        if (worldGeneratorThreadPool != null) {
            worldGeneratorThreadPool.shutdown();
        }
        worldGeneratorThreadPool = ThreadUtil.makeRateLimitedThreadPool(threadPoolSize, THREAD_FACTORY, Config.Client.Advanced.MultiThreading.runTimeRatioForWorldGenerationThreads);
        worldGeneratorThreadPool.setOnTerminatedEventHandler(WorldGenerationQueue::onWorldGenThreadPoolTerminated);
    }

    public static void shutdownWorldGenThreadPool() {
        if (worldGeneratorThreadPool != null) {
            LOGGER.info("Stopping " + FullDataFileHandler.class.getSimpleName());
            worldGeneratorThreadPool.shutdownNow();
        }
    }

    private static void onWorldGenThreadPoolTerminated() {
        LOGGER.debug("World generator thread pool terminated. Suggesting the JVM runs a garbage collection to clean up any loose world generation objects...");
        System.gc();
    }

    @Override
    public int getWaitingTaskCount() {
        return this.waitingTasks.size();
    }

    @Override
    public int getInProgressTaskCount() {
        return this.inProgressGenTasksByLodPos.size();
    }

    @Override
    public CompletableFuture<Void> startClosing(boolean cancelCurrentGeneration, boolean alsoInterruptRunning) {
        LOGGER.info("Closing world gen queue");
        this.queueingThread.shutdownNow();
        ArrayList inProgressTasksCancelingFutures = new ArrayList(this.inProgressGenTasksByLodPos.size());
        this.inProgressGenTasksByLodPos.values().forEach(runningTaskGroup -> {
            CompletableFuture<Void> genFuture = runningTaskGroup.genFuture;
            if (genFuture == null) {
                return;
            }
            if (cancelCurrentGeneration) {
                genFuture.cancel(alsoInterruptRunning);
            }
            inProgressTasksCancelingFutures.add(genFuture.handle((voidObj, exception) -> {
                if (exception instanceof CompletionException) {
                    exception = exception.getCause();
                }
                if (!UncheckedInterruptedException.isInterrupt(exception) && !(exception instanceof CancellationException)) {
                    LOGGER.error("Error when terminating data generation for section " + runningTaskGroup.group.pos, exception);
                }
                return null;
            }));
        });
        this.generatorClosingFuture = CompletableFuture.allOf(inProgressTasksCancelingFutures.toArray(new CompletableFuture[0]));
        return this.generatorClosingFuture;
    }

    @Override
    public void close() {
        LOGGER.info("Closing " + WorldGenerationQueue.class.getSimpleName() + "...");
        if (this.generatorClosingFuture == null) {
            this.startClosing(true, true);
        }
        LodUtil.assertTrue(this.generatorClosingFuture != null);
        LOGGER.info("Awaiting world generator thread pool termination...");
        try {
            int waitTimeInSeconds = 3;
            if (!worldGeneratorThreadPool.awaitTermination(waitTimeInSeconds, TimeUnit.SECONDS)) {
                LOGGER.warn("World generator thread pool shutdown didn't complete after [" + waitTimeInSeconds + "] seconds. Some world generator requests may still be running.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("World generator thread pool shutdown interrupted! Ignoring child threads...", (Throwable)e);
        }
        this.generator.close();
        try {
            this.generatorClosingFuture.cancel(true);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to close generation queue: ", e);
        }
        LOGGER.info("Finished closing " + WorldGenerationQueue.class.getSimpleName());
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showWorldGenQueue);
    }

    private boolean canGeneratePos(byte worldGenTaskGroupDetailLevel, DhSectionPos taskPos) {
        byte granularity = (byte)(taskPos.getDetailLevel() - worldGenTaskGroupDetailLevel);
        return granularity >= this.minGranularity && granularity <= this.maxGranularity;
    }

    private static int gridSpiralIndexing(int X, int Y) {
        int index = 0;
        if (X * X >= Y * Y) {
            index = 4 * X * X - X - Y;
            if (X < Y) {
                index -= 2 * (X - Y);
            }
        } else {
            index = 4 * Y * Y - X - Y;
            if (X < Y) {
                index += 2 * (X - Y);
            }
        }
        return index;
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        ((ConcurrentHashMap.KeySetView)this.waitingTasks.keySet()).forEach(pos -> renderer.renderBox(new DebugRenderer.Box((DhSectionPos)pos, -32.0f, 64.0f, 0.05f, Color.blue)));
        this.inProgressGenTasksByLodPos.forEach((pos, t) -> renderer.renderBox(new DebugRenderer.Box((DhSectionPos)pos, -32.0f, 64.0f, 0.05f, Color.red)));
    }

    private static class Mapper {
        public final WorldGenTask task;
        public final int dist;

        public Mapper(WorldGenTask task, int dist) {
            this.task = task;
            this.dist = dist;
        }
    }
}

