/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.subDimMatching;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import distanthorizons.libraries.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import javax.annotation.Nullable;

public class SubDimensionPlayerData {
    public static final IWrapperFactory FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    public static final String PLAYER_DATA_FILE_NAME = "_playerData.toml";
    public static final String PLAYER_BLOCK_POS_X_PATH = "playerBlockPosX";
    public static final String PLAYER_BLOCK_POS_Y_PATH = "playerBlockPosY";
    public static final String PLAYER_BLOCK_POS_Z_PATH = "playerBlockPosZ";
    public DhBlockPos playerBlockPos;
    public static final String WORLD_SPAWN_POS_X_PATH = "worldSpawnBlockPosX";
    public static final String WORLD_SPAWN_POS_Y_PATH = "worldSpawnBlockPosY";
    public static final String WORLD_SPAWN_POS_Z_PATH = "worldSpawnBlockPosZ";
    public DhBlockPos worldSpawnPointBlockPos;

    @Nullable
    public static SubDimensionPlayerData tryGetPlayerData(IMinecraftClientWrapper mcClient) {
        if (!mcClient.playerExists()) {
            return null;
        }
        try {
            return new SubDimensionPlayerData(mcClient);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private SubDimensionPlayerData(IMinecraftClientWrapper mc) {
        this.updateData(mc);
    }

    public SubDimensionPlayerData(File dimensionFolder) {
        File file = SubDimensionPlayerData.getFileForDimensionFolder(dimensionFolder);
        try (CommentedFileConfig toml = (CommentedFileConfig)CommentedFileConfig.builder(file).build();){
            toml.load();
            if (toml.contains(PLAYER_BLOCK_POS_X_PATH) && toml.contains(PLAYER_BLOCK_POS_Y_PATH) && toml.contains(PLAYER_BLOCK_POS_Z_PATH)) {
                int x = toml.getIntOrElse(PLAYER_BLOCK_POS_X_PATH, 0);
                int y = toml.getIntOrElse(PLAYER_BLOCK_POS_Y_PATH, 0);
                int z = toml.getIntOrElse(PLAYER_BLOCK_POS_Z_PATH, 0);
                this.playerBlockPos = new DhBlockPos(x, y, z);
            } else {
                this.playerBlockPos = new DhBlockPos(0, 0, 0);
            }
        }
    }

    public static File getFileForDimensionFolder(File file) {
        return new File(file.getPath() + File.separatorChar + PLAYER_DATA_FILE_NAME);
    }

    public void updateData(IMinecraftClientWrapper mc) {
        this.playerBlockPos = mc.getPlayerBlockPos();
        if (this.playerBlockPos == null) {
            throw new RuntimeException("No player block pos!");
        }
    }

    public void toTomlFile(CommentedFileConfig toml) {
        toml.add(PLAYER_BLOCK_POS_X_PATH, (Object)this.playerBlockPos.getX());
        toml.add(PLAYER_BLOCK_POS_Y_PATH, (Object)this.playerBlockPos.getY());
        toml.add(PLAYER_BLOCK_POS_Z_PATH, (Object)this.playerBlockPos.getZ());
        toml.save();
    }

    public String toString() {
        return "PlayerBlockPos: [" + this.playerBlockPos.x + "," + this.playerBlockPos.y + "," + this.playerBlockPos.z + "]";
    }
}

