/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.subDimMatching;

import com.seibel.distanthorizons.core.config.Config;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class SubDimCompare
implements Comparable<SubDimCompare> {
    public static int MAX_SIMILAR_PLAYER_POS_DISTANCE_IN_BLOCKS = 3;
    public int equalDataPoints = 0;
    public int totalDataPoints = 0;
    public int playerPosDist = 0;
    public File folder = null;

    public SubDimCompare(int newEqualDataPoints, int newTotalDataPoints, int newPlayerPosDistance, File newSubDimFolder) {
        this.equalDataPoints = newEqualDataPoints;
        this.totalDataPoints = newTotalDataPoints;
        this.playerPosDist = newPlayerPosDistance;
        this.folder = newSubDimFolder;
    }

    public double getPercentEqual() {
        return (double)this.equalDataPoints / (double)this.totalDataPoints;
    }

    @Override
    public int compareTo(@NotNull SubDimCompare other) {
        if (this.equalDataPoints != other.equalDataPoints) {
            return Integer.compare(this.equalDataPoints, other.equalDataPoints);
        }
        return Integer.compare(this.playerPosDist, other.playerPosDist);
    }

    public boolean isValidSubDim() {
        double minimumSimilarityRequired = Config.Client.Advanced.Multiplayer.multiverseSimilarityRequiredPercent.get();
        return this.getPercentEqual() >= minimumSimilarityRequired || this.playerPosDist <= MAX_SIMILAR_PLAYER_POS_DISTANCE_IN_BLOCKS;
    }
}

