/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.renderfile;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.renderfile.ILodRenderSourceProvider;
import com.seibel.distanthorizons.core.file.renderfile.RenderDataMetaFile;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FileUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class RenderSourceFileHandler
implements ILodRenderSourceProvider {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final ThreadPoolExecutor fileHandlerThreadPool;
    private final F3Screen.NestedMessage threadPoolMsg;
    protected final ConcurrentHashMap<DhSectionPos, RenderDataMetaFile> loadedMetaFileBySectionPos = new ConcurrentHashMap();
    private final IDhClientLevel clientLevel;
    private final File saveDir;
    AtomicInteger topDetailLevelRef = new AtomicInteger(6);
    private final IFullDataSourceProvider fullDataSourceProvider;
    private final WeakHashMap<CompletableFuture<?>, ETaskType> taskTracker = new WeakHashMap();

    public RenderSourceFileHandler(IFullDataSourceProvider sourceProvider, IDhClientLevel clientLevel, AbstractSaveStructure saveStructure) {
        this.fullDataSourceProvider = sourceProvider;
        this.clientLevel = clientLevel;
        this.saveDir = saveStructure.getRenderCacheFolder(clientLevel.getLevelWrapper());
        if (!this.saveDir.exists() && !this.saveDir.mkdirs()) {
            LOGGER.warn("Unable to create render data folder, file saving may fail.");
        }
        this.fileHandlerThreadPool = ThreadUtil.makeSingleThreadPool("Render Source File Handler [" + this.clientLevel.getLevelWrapper().getDimensionType().getDimensionName() + "]");
        this.threadPoolMsg = new F3Screen.NestedMessage(this::f3Log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ColumnRenderSource> readAsync(DhSectionPos pos) {
        if (this.fileHandlerThreadPool.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        this.topDetailLevelRef.updateAndGet(oldDetailLevel -> Math.max(oldDetailLevel, pos.getDetailLevel()));
        RenderDataMetaFile metaFile = this.getLoadOrMakeFile(pos);
        if (metaFile == null) {
            return CompletableFuture.completedFuture(ColumnRenderSource.createEmptyRenderSource(pos));
        }
        CompletionStage getDataSourceFuture = metaFile.getOrLoadCachedDataSourceAsync(this.fileHandlerThreadPool).handle((renderSource, exception) -> {
            if (exception != null) {
                LOGGER.error("Uncaught error in readAsync for pos: " + pos + ". Error:", exception);
            }
            return renderSource != null ? renderSource : ColumnRenderSource.createEmptyRenderSource(pos);
        });
        WeakHashMap<CompletableFuture<?>, ETaskType> weakHashMap = this.taskTracker;
        synchronized (weakHashMap) {
            this.taskTracker.put((CompletableFuture<?>)getDataSourceFuture, ETaskType.READ);
        }
        return getDataSourceFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderDataMetaFile getLoadOrMakeFile(DhSectionPos pos) {
        RenderDataMetaFile metaFile = this.loadedMetaFileBySectionPos.get(pos);
        if (metaFile != null) {
            return metaFile;
        }
        File fileToLoad = this.computeRenderFilePath(pos);
        if (fileToLoad.exists()) {
            RenderSourceFileHandler renderSourceFileHandler = this;
            synchronized (renderSourceFileHandler) {
                metaFile = this.loadedMetaFileBySectionPos.get(pos);
                if (metaFile != null) {
                    return metaFile;
                }
                try {
                    metaFile = RenderDataMetaFile.createFromExistingFile(this.fullDataSourceProvider, this.clientLevel, fileToLoad);
                    this.topDetailLevelRef.updateAndGet(currentTopDetailLevel -> Math.max(currentTopDetailLevel, pos.getDetailLevel()));
                    this.loadedMetaFileBySectionPos.put(pos, metaFile);
                    return metaFile;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read meta data file at " + fileToLoad + ": ", (Throwable)e);
                    FileUtil.renameCorruptedFile(fileToLoad);
                }
            }
        }
        try {
            metaFile = RenderDataMetaFile.createNewFileForPos(this.fullDataSourceProvider, this.clientLevel, pos, fileToLoad);
        }
        catch (IOException e) {
            LOGGER.error("IOException on creating new render data file at " + pos, (Throwable)e);
            return null;
        }
        this.topDetailLevelRef.updateAndGet(oldDetailLevel -> Math.max(oldDetailLevel, pos.getDetailLevel()));
        RenderDataMetaFile metaFileCas = this.loadedMetaFileBySectionPos.putIfAbsent(pos, metaFile);
        return metaFileCas == null ? metaFile : metaFileCas;
    }

    @Override
    public void writeChunkDataToFile(DhSectionPos sectionPos, ChunkSizedFullDataAccessor chunkDataView) {
        this.writeChunkDataToFileRecursively(chunkDataView, (byte)6);
        this.fullDataSourceProvider.writeChunkDataToFile(sectionPos, chunkDataView);
    }

    private void writeChunkDataToFileRecursively(ChunkSizedFullDataAccessor chunk, byte sectionDetailLevel) {
        DhSectionPos boundingPos = chunk.getSectionPos();
        DhSectionPos minSectionPos = boundingPos.convertNewToDetailLevel(sectionDetailLevel);
        DhSectionPos.DhMutableSectionPos fileSectionPos = new DhSectionPos.DhMutableSectionPos(0, 0, 0);
        int width = sectionDetailLevel > boundingPos.getDetailLevel() ? 1 : boundingPos.getWidthCountForLowerDetailedSection(sectionDetailLevel);
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                fileSectionPos.mutate(sectionDetailLevel, minSectionPos.getX() + xOffset, minSectionPos.getZ() + zOffset);
                RenderDataMetaFile metaFile = this.loadedMetaFileBySectionPos.get(fileSectionPos);
                if (metaFile == null) continue;
                metaFile.updateChunkIfSourceExistsAsync(chunk);
            }
        }
        if (sectionDetailLevel < this.topDetailLevelRef.get()) {
            this.writeChunkDataToFileRecursively(chunk, (byte)(sectionDetailLevel + 1));
        }
    }

    @Override
    public CompletableFuture<Void> flushAndSaveAsync() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (RenderDataMetaFile metaFile : this.loadedMetaFileBySectionPos.values()) {
            futures.add(metaFile.flushAndSaveAsync());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] f3Log() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Render Source File Handler [" + this.clientLevel.getClientLevelWrapper().getDimensionType().getDimensionName() + "]");
        lines.add("  Loaded files: " + this.loadedMetaFileBySectionPos.size());
        lines.add("  Thread pool tasks: " + this.fileHandlerThreadPool.getQueue().size() + " (completed: " + this.fileHandlerThreadPool.getCompletedTaskCount() + ")");
        int totalFutures = this.taskTracker.size();
        EnumMap<ETaskType, Integer> tasksOutstanding = new EnumMap<ETaskType, Integer>(ETaskType.class);
        EnumMap<ETaskType, Integer> tasksCompleted = new EnumMap<ETaskType, Integer>(ETaskType.class);
        for (ETaskType type2 : ETaskType.values()) {
            tasksOutstanding.put(type2, 0);
            tasksCompleted.put(type2, 0);
        }
        WeakHashMap<CompletableFuture<?>, ETaskType> weakHashMap = this.taskTracker;
        synchronized (weakHashMap) {
            for (Map.Entry<CompletableFuture<?>, ETaskType> entry : this.taskTracker.entrySet()) {
                if (entry.getKey().isDone()) {
                    tasksCompleted.put(entry.getValue(), (Integer)tasksCompleted.get((Object)entry.getValue()) + 1);
                    continue;
                }
                tasksOutstanding.put(entry.getValue(), (Integer)tasksOutstanding.get((Object)entry.getValue()) + 1);
            }
        }
        int n = tasksOutstanding.values().stream().mapToInt(Integer::intValue).sum();
        lines.add("  Futures: " + totalFutures + " (outstanding: " + n + ")");
        for (ETaskType type3 : ETaskType.values()) {
            lines.add("    " + (Object)((Object)type3) + ": " + tasksOutstanding.get((Object)type3) + " / " + ((Integer)tasksOutstanding.get((Object)type3) + (Integer)tasksCompleted.get((Object)type3)));
        }
        return lines.toArray(new String[0]);
    }

    @Override
    public void close() {
        LOGGER.info("Closing " + this.getClass().getSimpleName() + " with [" + this.loadedMetaFileBySectionPos.size() + "] files...");
        this.fileHandlerThreadPool.shutdown();
        this.threadPoolMsg.close();
    }

    @Override
    public void deleteRenderCache() {
        File[] renderFiles = this.saveDir.listFiles();
        if (renderFiles != null) {
            for (File renderFile : renderFiles) {
                if (renderFile.delete()) continue;
                LOGGER.warn("Unable to delete render file: " + renderFile.getPath());
            }
        }
        this.loadedMetaFileBySectionPos.clear();
    }

    public File computeRenderFilePath(DhSectionPos pos) {
        return new File(this.saveDir, pos.serialize() + ".rlod");
    }

    private static enum ETaskType {
        READ,
        UPDATE_READ_DATA,
        UPDATE,
        ON_LOADED;

    }
}

