/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.metaData;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.file.metaData.BaseMetaData;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FileUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMetaDataContainerFile {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int METADATA_SIZE_IN_BYTES = 64;
    public static final int METADATA_RESERVED_SIZE = 24;
    public static final int METADATA_IDENTITY_BYTES = 1145599536;
    public static final boolean USE_ATOMIC_MOVE_REPLACE = true;
    public volatile BaseMetaData baseMetaData = null;
    public final DhSectionPos pos;
    public File file;
    private volatile boolean DebugThreadCheck = false;

    protected AbstractMetaDataContainerFile(File file, DhSectionPos pos) throws FileAlreadyExistsException {
        this.file = file;
        this.pos = pos;
        if (file.exists()) {
            throw new FileAlreadyExistsException(file.toString());
        }
    }

    protected AbstractMetaDataContainerFile(File file) throws IOException, FileNotFoundException {
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException("File not found at [" + file + "]");
        }
        AbstractMetaDataContainerFile.validateMetaDataFile(this.file);
        this.baseMetaData = AbstractMetaDataContainerFile.readMetaDataFromFile(file);
        this.pos = this.baseMetaData.pos;
    }

    private static BaseMetaData readMetaDataFromFile(File file) throws IOException {
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(64);
            channel.read(byteBuffer, 0L);
            channel.close();
            byteBuffer.flip();
            int idBytes = byteBuffer.getInt();
            if (idBytes != 1145599536) {
                if (file.exists()) {
                    FileUtil.renameCorruptedFile(file);
                    throw new IOException("Invalid file format: Metadata Identity byte check failed. Expected: [1145599536], Actual: [" + idBytes + "].");
                }
                throw new IOException("No file found for meta data. Expected file path: " + file.getPath());
            }
            int x = byteBuffer.getInt();
            int y = byteBuffer.getInt();
            int z = byteBuffer.getInt();
            int checksum = byteBuffer.getInt();
            byte detailLevel = byteBuffer.get();
            byte dataLevel = byteBuffer.get();
            byte loaderVersion = byteBuffer.get();
            EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.fromValue(byteBuffer.get());
            long dataTypeId = byteBuffer.getLong();
            long dataVersion = byteBuffer.getLong();
            LodUtil.assertTrue(byteBuffer.remaining() == 24);
            DhSectionPos dataPos = new DhSectionPos(detailLevel, x, z);
            BaseMetaData baseMetaData = new BaseMetaData(dataPos, checksum, dataLevel, worldGenStep, dataTypeId, loaderVersion, dataVersion);
            return baseMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeData(IMetaDataWriterFunc<DhDataOutputStream> dataWriterFunc) throws IOException {
        LodUtil.assertTrue(!this.DebugThreadCheck);
        this.DebugThreadCheck = true;
        LodUtil.assertTrue(this.baseMetaData != null);
        if (this.file.exists()) {
            AbstractMetaDataContainerFile.validateMetaDataFile(this.file);
        }
        File tempFile = new File(this.file.getPath() + ".tmp");
        try (FileChannel fileChannel = FileChannel.open(tempFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.position(64L);
            CheckedOutputStream checkedOut = new CheckedOutputStream(Channels.newOutputStream(fileChannel), new Adler32());
            DhDataOutputStream compressedOut = new DhDataOutputStream(checkedOut);
            dataWriterFunc.writeBufferToFile(compressedOut);
            compressedOut.flush();
            this.baseMetaData.checksum = (int)checkedOut.getChecksum().getValue();
            fileChannel.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate(64);
            buffer.putInt(1145599536);
            buffer.putInt(this.pos.getX());
            buffer.putInt(Integer.MIN_VALUE);
            buffer.putInt(this.pos.getZ());
            buffer.putInt(this.baseMetaData.checksum);
            buffer.put(this.pos.getDetailLevel());
            buffer.put(this.baseMetaData.dataLevel);
            buffer.put(this.baseMetaData.binaryDataFormatVersion);
            buffer.put(this.baseMetaData.worldGenStep != null ? this.baseMetaData.worldGenStep.value : EDhApiWorldGenerationStep.EMPTY.value);
            buffer.putLong(this.baseMetaData.dataTypeId);
            buffer.putLong(this.baseMetaData.dataVersion.get());
            LodUtil.assertTrue(buffer.remaining() == 24);
            buffer.flip();
            fileChannel.write(buffer);
            fileChannel.close();
            Files.move(tempFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (NoSuchFileException tempDeleteErrorMessage) {
        }
        catch (ClosedChannelException tempDeleteErrorMessage) {
        }
        finally {
            String tempDeleteErrorMessage = null;
            try {
                boolean fileRemoved;
                if (tempFile.exists() && !(fileRemoved = tempFile.delete())) {
                    tempDeleteErrorMessage = "Unable to remove Temporary file at: " + tempFile.getPath();
                }
            }
            catch (SecurityException exception) {
                tempDeleteErrorMessage = "Security error: [" + exception.getMessage() + "] when attempting to remove Temporary file at: " + tempFile.getPath();
            }
            if (tempDeleteErrorMessage != null) {
                LOGGER.error(tempDeleteErrorMessage);
            }
            this.DebugThreadCheck = false;
        }
    }

    private static void validateMetaDataFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File missing");
        }
        if (!file.isFile()) {
            throw new IOException("Not a file");
        }
        if (!file.canRead()) {
            throw new IOException("File not readable");
        }
        if (!file.canWrite()) {
            throw new IOException("File not writable");
        }
    }

    protected void loadMetaData() throws IOException {
        AbstractMetaDataContainerFile.validateMetaDataFile(this.file);
        this.baseMetaData = AbstractMetaDataContainerFile.readMetaDataFromFile(this.file);
        if (!this.baseMetaData.pos.equals(this.pos)) {
            LOGGER.warn("The file is from a different location than expected! Expected: [" + this.pos + "] but got [" + this.baseMetaData.pos + "]. Ignoring file tag.");
            this.baseMetaData.pos = this.pos;
        }
    }

    @FunctionalInterface
    public static interface IMetaDataWriterFunc<T> {
        public void writeBufferToFile(T var1) throws IOException;
    }
}

