/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Nullable;

public interface IFullDataSourceProvider
extends AutoCloseable {
    public CompletableFuture<IFullDataSource> readAsync(DhSectionPos var1);

    public void writeChunkDataToFile(DhSectionPos var1, ChunkSizedFullDataAccessor var2);

    public CompletableFuture<Void> flushAndSave();

    public CompletableFuture<Void> flushAndSave(DhSectionPos var1);

    public CompletableFuture<IFullDataSource> onDataFileCreatedAsync(FullDataMetaFile var1);

    default public CompletableFuture<DataFileUpdateResult> onDataFileUpdateAsync(IFullDataSource fullDataSource, FullDataMetaFile file, boolean dataChanged) {
        return CompletableFuture.completedFuture(new DataFileUpdateResult(fullDataSource, dataChanged));
    }

    default public void onRenderDataFileLoaded(DhSectionPos pos) {
    }

    public File computeDataFilePath(DhSectionPos var1);

    public ExecutorService getIOExecutor();

    @Nullable
    public FullDataMetaFile getFileIfExist(DhSectionPos var1);

    public static class DataFileUpdateResult {
        IFullDataSource fullDataSource;
        boolean dataSourceChanged;

        public DataFileUpdateResult(IFullDataSource fullDataSource, boolean dataSourceChanged) {
            this.fullDataSource = fullDataSource;
            this.dataSourceChanged = dataSourceChanged;
        }
    }
}

