/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EBlocksToAvoid;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.Logger;

public class FullDataToRenderDataTransformer {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static ExecutorService transformerThreadPool = null;
    private static ConfigChangeListener<Integer> configListener;

    public static CompletableFuture<ColumnRenderSource> transformFullDataToRenderSourceUsingExecutorAsync(IFullDataSource fullDataSource, IDhClientLevel level) {
        return CompletableFuture.supplyAsync(() -> FullDataToRenderDataTransformer.transformFullDataToRenderSource(fullDataSource, level), transformerThreadPool);
    }

    private static ColumnRenderSource transformFullDataToRenderSource(IFullDataSource fullDataSource, IDhClientLevel level) {
        if (fullDataSource == null) {
            return null;
        }
        if (MC.getWrappedClientWorld() == null) {
            return null;
        }
        try {
            if (fullDataSource instanceof CompleteFullDataSource) {
                return FullDataToRenderDataTransformer.transformCompleteFullDataToColumnData(level, (CompleteFullDataSource)fullDataSource);
            }
            if (fullDataSource instanceof IIncompleteFullDataSource) {
                return FullDataToRenderDataTransformer.transformIncompleteFullDataToColumnData(level, (IIncompleteFullDataSource)fullDataSource);
            }
            LodUtil.assertNotReach("Unimplemented Full Data transformer for " + IFullDataSource.class.getSimpleName() + " of type [" + fullDataSource.getClass().getSimpleName() + "].");
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static ColumnRenderSource transformCompleteFullDataToColumnData(IDhClientLevel level, CompleteFullDataSource fullDataSource) throws InterruptedException {
        DhSectionPos pos = fullDataSource.getSectionPos();
        byte dataDetail = fullDataSource.getDataDetailLevel();
        int vertSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(fullDataSource.getDataDetailLevel());
        ColumnRenderSource columnSource = new ColumnRenderSource(pos, vertSize, level.getMinY());
        if (fullDataSource.isEmpty()) {
            return columnSource;
        }
        columnSource.markNotEmpty();
        if (dataDetail == columnSource.getDataDetail()) {
            int baseX = pos.getMinCornerLodPos().getCornerBlockPos().x;
            int baseZ = pos.getMinCornerLodPos().getCornerBlockPos().z;
            for (int x = 0; x < pos.getWidthCountForLowerDetailedSection(dataDetail); ++x) {
                for (int z = 0; z < pos.getWidthCountForLowerDetailedSection(dataDetail); ++z) {
                    FullDataToRenderDataTransformer.throwIfThreadInterrupted();
                    ColumnArrayView columnArrayView = columnSource.getVerticalDataPointView(x, z);
                    SingleColumnFullDataAccessor fullArrayView = fullDataSource.get(x, z);
                    FullDataToRenderDataTransformer.convertColumnData(level, baseX + x, baseZ + z, columnArrayView, fullArrayView, 1);
                    if (!fullArrayView.doesColumnExist()) continue;
                    LodUtil.assertTrue(columnSource.doesDataPointExist(x, z));
                }
            }
        } else {
            throw new UnsupportedOperationException("To be implemented");
        }
        columnSource.fillDebugFlag(0, 0, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.SECTION_SIZE, ColumnRenderSource.DebugSourceFlag.FULL);
        return columnSource;
    }

    private static ColumnRenderSource transformIncompleteFullDataToColumnData(IDhClientLevel level, IIncompleteFullDataSource data) throws InterruptedException {
        DhSectionPos pos = data.getSectionPos();
        byte dataDetail = data.getDataDetailLevel();
        int vertSize = Config.Client.Advanced.Graphics.Quality.verticalQuality.get().calculateMaxVerticalData(data.getDataDetailLevel());
        ColumnRenderSource columnSource = new ColumnRenderSource(pos, vertSize, level.getMinY());
        if (data.isEmpty()) {
            return columnSource;
        }
        columnSource.markNotEmpty();
        if (dataDetail == columnSource.getDataDetail()) {
            int baseX = pos.getMinCornerLodPos().getCornerBlockPos().x;
            int baseZ = pos.getMinCornerLodPos().getCornerBlockPos().z;
            int width = pos.getWidthCountForLowerDetailedSection(dataDetail);
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    FullDataToRenderDataTransformer.throwIfThreadInterrupted();
                    SingleColumnFullDataAccessor fullArrayView = data.tryGet(x, z);
                    if (fullArrayView == null) continue;
                    ColumnArrayView columnArrayView = columnSource.getVerticalDataPointView(x, z);
                    FullDataToRenderDataTransformer.convertColumnData(level, baseX + x, baseZ + z, columnArrayView, fullArrayView, 1);
                    columnSource.fillDebugFlag(x, z, 1, 1, ColumnRenderSource.DebugSourceFlag.SPARSE);
                    if (!fullArrayView.doesColumnExist()) continue;
                    LodUtil.assertTrue(columnSource.doesDataPointExist(x, z));
                }
            }
        } else {
            throw new UnsupportedOperationException("To be implemented");
        }
        return columnSource;
    }

    private static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(FullDataToRenderDataTransformer.class.getSimpleName() + " task interrupted.");
        }
    }

    private static void iterateAndConvert(IDhClientLevel level, int blockX, int blockZ, int genMode, ColumnArrayView column, SingleColumnFullDataAccessor data) {
        boolean avoidSolidBlocks = Config.Client.Advanced.Graphics.Quality.blocksToIgnore.get() == EBlocksToAvoid.NON_COLLIDING;
        boolean colorBelowWithAvoidedBlocks = Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks.get();
        FullDataPointIdMap fullDataMapping = data.getMapping();
        HashSet<IBlockStateWrapper> blockStatesToIgnore = WRAPPER_FACTORY.getRendererIgnoredBlocks(level.getLevelWrapper());
        boolean isVoid = true;
        int colorToApplyToNextBlock = -1;
        int columnOffset = 0;
        for (int i = 0; i < data.getSingleLength(); ++i) {
            int color;
            long fullData = data.getSingle(i);
            int bottomY = FullDataPointUtil.getBottomY(fullData);
            int blockHeight = FullDataPointUtil.getHeight(fullData);
            int id = FullDataPointUtil.getId(fullData);
            int light = FullDataPointUtil.getLight(fullData);
            IBiomeWrapper biome = fullDataMapping.getBiomeWrapper(id);
            IBlockStateWrapper block = fullDataMapping.getBlockStateWrapper(id);
            if (blockStatesToIgnore.contains(block)) continue;
            if (avoidSolidBlocks && !block.isSolid() && !block.isLiquid()) {
                if (!colorBelowWithAvoidedBlocks) continue;
                colorToApplyToNextBlock = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block);
                continue;
            }
            if (colorToApplyToNextBlock == -1) {
                color = level.computeBaseColor(new DhBlockPos(blockX, bottomY + level.getMinY(), blockZ), biome, block);
            } else {
                color = colorToApplyToNextBlock;
                colorToApplyToNextBlock = -1;
            }
            isVoid = false;
            long columnData = RenderDataPointUtil.createDataPoint(bottomY + blockHeight, bottomY, color, light, genMode);
            column.set(columnOffset, columnData);
            ++columnOffset;
        }
        if (isVoid) {
            column.set(0, RenderDataPointUtil.createVoidDataPoint((byte)genMode));
        }
    }

    public static void convertColumnData(IDhClientLevel level, int blockX, int blockZ, ColumnArrayView columnArrayView, SingleColumnFullDataAccessor fullArrayView, int genMode) {
        if (!fullArrayView.doesColumnExist()) {
            return;
        }
        int dataTotalLength = fullArrayView.getSingleLength();
        if (dataTotalLength == 0) {
            return;
        }
        if (dataTotalLength > columnArrayView.verticalSize()) {
            ColumnArrayView totalColumnData = new ColumnArrayView(new long[dataTotalLength], dataTotalLength, 0, dataTotalLength);
            FullDataToRenderDataTransformer.iterateAndConvert(level, blockX, blockZ, genMode, totalColumnData, fullArrayView);
            columnArrayView.changeVerticalSizeFrom(totalColumnData);
        } else {
            FullDataToRenderDataTransformer.iterateAndConvert(level, blockX, blockZ, genMode, columnArrayView, fullArrayView);
        }
    }

    public static void setupExecutorService() {
        if (configListener == null) {
            configListener = new ConfigChangeListener<Integer>(Config.Client.Advanced.MultiThreading.numberOfDataTransformerThreads, threadCount -> FullDataToRenderDataTransformer.setThreadPoolSize(threadCount));
        }
        if (transformerThreadPool == null || transformerThreadPool.isTerminated()) {
            LOGGER.info("Starting " + FullDataToRenderDataTransformer.class.getSimpleName());
            FullDataToRenderDataTransformer.setThreadPoolSize(Config.Client.Advanced.MultiThreading.numberOfDataTransformerThreads.get());
        }
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        if (transformerThreadPool != null) {
            transformerThreadPool.shutdown();
        }
        transformerThreadPool = ThreadUtil.makeRateLimitedThreadPool(threadPoolSize, "Full/Render Data Transformer", Config.Client.Advanced.MultiThreading.runTimeRatioForDataTransformerThreads);
    }

    public static void shutdownExecutorService() {
        if (transformerThreadPool != null) {
            LOGGER.info("Stopping " + FullDataToRenderDataTransformer.class.getSimpleName());
            transformerThreadPool.shutdownNow();
        }
    }
}

