/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.transformers.LodDataBuilder;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;

public class ChunkToLodBuilder
implements AutoCloseable {
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logLodBuilderEvent.get());
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static int threadCount = -1;
    private static ExecutorService executorThreadPool = null;
    private static ConfigChangeListener<Integer> threadConfigListener;
    public static final long MAX_TICK_TIME_NS = 50000000L;
    private final ConcurrentHashMap<DhChunkPos, IChunkWrapper> concurrentChunkToBuildByChunkPos = new ConcurrentHashMap();
    private final ConcurrentLinkedDeque<Task> concurrentTaskToBuildList = new ConcurrentLinkedDeque();
    private final AtomicInteger runningCount = new AtomicInteger(0);

    public CompletableFuture<ChunkSizedFullDataAccessor> tryGenerateData(IChunkWrapper chunkWrapper) {
        if (chunkWrapper == null) {
            throw new NullPointerException("ChunkWrapper cannot be null!");
        }
        IChunkWrapper oldChunk = this.concurrentChunkToBuildByChunkPos.put(chunkWrapper.getChunkPos(), chunkWrapper);
        if (oldChunk != null) {
            return null;
        }
        CompletableFuture<ChunkSizedFullDataAccessor> future = new CompletableFuture<ChunkSizedFullDataAccessor>();
        this.concurrentTaskToBuildList.addLast(new Task(chunkWrapper.getChunkPos(), future));
        return future;
    }

    public void tick() {
        if (this.runningCount.get() >= threadCount) {
            return;
        }
        if (this.concurrentTaskToBuildList.isEmpty()) {
            return;
        }
        if (MC == null || !MC.playerExists()) {
            return;
        }
        for (int i = 0; i < threadCount; ++i) {
            this.runningCount.incrementAndGet();
            CompletableFuture.runAsync(() -> {
                try {
                    this.tickThreadTask();
                }
                finally {
                    this.runningCount.decrementAndGet();
                }
            }, executorThreadPool);
        }
    }

    private void tickThreadTask() {
        long time = System.nanoTime();
        int count = 0;
        boolean allDone = false;
        while (System.nanoTime() - time <= 50000000L || this.concurrentTaskToBuildList.isEmpty()) {
            Task task = this.concurrentTaskToBuildList.pollFirst();
            if (task == null) {
                allDone = true;
                break;
            }
            ++count;
            IChunkWrapper latestChunk = this.concurrentChunkToBuildByChunkPos.remove(task.chunkPos);
            if (latestChunk == null) {
                LOGGER.error("Somehow Task at " + task.chunkPos + " has latestChunk as null. Skipping task.", new Object[0]);
                task.future.complete(null);
                continue;
            }
            try {
                if (LodDataBuilder.canGenerateLodFromChunk(latestChunk)) {
                    ChunkSizedFullDataAccessor data = LodDataBuilder.createChunkData(latestChunk);
                    if (data != null) {
                        task.future.complete(data);
                        continue;
                    }
                } else if (task.generationAttemptExpirationTimeMs < System.currentTimeMillis()) {
                    continue;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while processing Task at " + task.chunkPos, ex);
            }
            IChunkWrapper casChunk = this.concurrentChunkToBuildByChunkPos.putIfAbsent(task.chunkPos, latestChunk);
            if (casChunk == null || latestChunk.isStillValid()) {
                this.concurrentTaskToBuildList.addLast(task);
            } else {
                task.future.complete(null);
            }
            --count;
        }
        long time2 = System.nanoTime();
        if (!allDone || count > 0) {
            // empty if block
        }
    }

    public void clearCurrentTasks() {
        this.concurrentTaskToBuildList.clear();
        this.concurrentChunkToBuildByChunkPos.clear();
    }

    public static void setupExecutorService() {
        if (threadConfigListener == null) {
            threadConfigListener = new ConfigChangeListener<Integer>(Config.Client.Advanced.MultiThreading.numberOfChunkLodConverterThreads, threadCount -> ChunkToLodBuilder.setThreadPoolSize(threadCount));
        }
        if (executorThreadPool == null || executorThreadPool.isTerminated()) {
            LOGGER.info("Starting " + ChunkToLodBuilder.class.getSimpleName(), new Object[0]);
            ChunkToLodBuilder.setThreadPoolSize(Config.Client.Advanced.MultiThreading.numberOfChunkLodConverterThreads.get());
        }
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        if (executorThreadPool != null && !executorThreadPool.isTerminated()) {
            executorThreadPool.shutdownNow();
        }
        threadCount = threadPoolSize;
        executorThreadPool = ThreadUtil.makeRateLimitedThreadPool(threadPoolSize, ChunkToLodBuilder.class.getSimpleName(), Config.Client.Advanced.MultiThreading.runTimeRatioForChunkLodConverterThreads);
    }

    public static void shutdownExecutorService() {
        if (executorThreadPool != null) {
            LOGGER.info("Stopping " + ChunkToLodBuilder.class.getSimpleName(), new Object[0]);
            executorThreadPool.shutdownNow();
        }
    }

    @Override
    public void close() {
        this.clearCurrentTasks();
    }

    private static class Task {
        public final DhChunkPos chunkPos;
        public final CompletableFuture<ChunkSizedFullDataAccessor> future;
        public long generationAttemptExpirationTimeMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);

        Task(DhChunkPos chunkPos, CompletableFuture<ChunkSizedFullDataAccessor> future) {
            this.chunkPos = chunkPos;
            this.future = future;
        }
    }
}

