/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.rendering.EDebugRendering;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.dataObjects.render.ColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.CubicLodTemplate;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.Reference;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColumnRenderBufferBuilder {
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(), () -> Config.Client.Advanced.Logging.logRendererBufferEvent.get());
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static ExecutorService bufferUploaderThreadPool = ThreadUtil.makeSingleThreadPool("Column Buffer Uploader");
    public static ExecutorService bufferBuilderThreadPool;
    private static ConfigChangeListener<Integer> configListener;
    public static final int MAX_NUMBER_OF_CONCURRENT_CALLS_PER_THREAD = 3;
    public static int maxNumberOfConcurrentCalls;

    public static CompletableFuture<ColumnRenderBuffer> buildBuffersAsync(IDhClientLevel clientLevel, Reference<ColumnRenderBuffer> renderBufferRef, ColumnRenderSource renderSource, ColumnRenderSource[] adjData) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                boolean enableTransparency = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
                EVENT_LOGGER.trace("RenderRegion start QuadBuild @ " + renderSource.sectionPos, new Object[0]);
                boolean enableSkyLightCulling = !clientLevel.getLevelWrapper().hasCeiling() && Config.Client.Advanced.Graphics.AdvancedGraphics.enableCaveCulling.get() != false;
                int skyLightCullingBelow = Config.Client.Advanced.Graphics.AdvancedGraphics.caveCullingHeight.get();
                skyLightCullingBelow = Math.max(skyLightCullingBelow, clientLevel.getMinY());
                long builderStartTime = System.currentTimeMillis();
                LodQuadBuilder builder = new LodQuadBuilder(enableSkyLightCulling, (short)(skyLightCullingBelow - clientLevel.getMinY()), enableTransparency);
                ColumnRenderBufferBuilder.makeLodRenderData(builder, renderSource, adjData);
                long builderEndTime = System.currentTimeMillis();
                long buildMs = builderEndTime - builderStartTime;
                LOGGER.debug("RenderRegion end QuadBuild @ " + renderSource.sectionPos + " took: " + buildMs);
                return builder;
            }
            catch (UncheckedInterruptedException e) {
                throw e;
            }
            catch (Throwable e3) {
                LOGGER.error("\"LodNodeBufferBuilder\" was unable to build quads: ", e3);
                throw e3;
            }
        }, bufferBuilderThreadPool).thenApplyAsync(quadBuilder -> {
            try {
                EVENT_LOGGER.trace("RenderRegion start Upload @ " + renderSource.sectionPos, new Object[0]);
                ColumnRenderBuffer buffer = renderBufferRef.swap(null);
                if (buffer == null) {
                    buffer = new ColumnRenderBuffer(new DhBlockPos(renderSource.sectionPos.getMinCornerLodPos().getCornerBlockPos(), clientLevel.getMinY()), renderSource.sectionPos);
                }
                try {
                    buffer.uploadBuffer((LodQuadBuilder)quadBuilder, GLProxy.getInstance().getGpuUploadMethod());
                    LodUtil.assertTrue(buffer.buffersUploaded);
                    EVENT_LOGGER.trace("RenderRegion end Upload @ " + renderSource.sectionPos, new Object[0]);
                    return buffer;
                }
                catch (Exception e) {
                    buffer.close();
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw UncheckedInterruptedException.convert(e);
            }
            catch (Throwable e3) {
                LOGGER.error("\"LodNodeBufferBuilder\" was unable to upload buffer: ", e3);
                throw e3;
            }
        }, (Executor)bufferUploaderThreadPool)).handle((columnRenderBuffer, ex) -> {
            if (ex != null) {
                LOGGER.warn("Buffer building failed: " + ex.getMessage(), ex);
                if (!renderBufferRef.isEmpty()) {
                    ColumnRenderBuffer buffer = renderBufferRef.swap(null);
                    buffer.close();
                }
                return null;
            }
            LodUtil.assertTrue(columnRenderBuffer.buffersUploaded);
            return columnRenderBuffer;
        });
    }

    private static void makeLodRenderData(LodQuadBuilder quadBuilder, ColumnRenderSource renderSource, ColumnRenderSource[] adjRegions) {
        EDebugRendering debugMode = Config.Client.Advanced.Debugging.debugRendering.get();
        byte detailLevel = renderSource.getDataDetail();
        for (int x = 0; x < ColumnRenderSource.SECTION_SIZE; ++x) {
            for (int z = 0; z < ColumnRenderSource.SECTION_SIZE; ++z) {
                long data;
                UncheckedInterruptedException.throwIfInterrupted();
                ColumnArrayView columnRenderData = renderSource.getVerticalDataPointView(x, z);
                if (columnRenderData.size() == 0 || !RenderDataPointUtil.doesDataPointExist(columnRenderData.get(0)) || RenderDataPointUtil.isVoid(columnRenderData.get(0))) continue;
                ColumnRenderSource.DebugSourceFlag debugSourceFlag = renderSource.debugGetFlag(x, z);
                ColumnArrayView[][] adjColumnViews = new ColumnArrayView[4][];
                for (EDhDirection lodDirection : EDhDirection.ADJ_DIRECTIONS) {
                    try {
                        byte adjDetailLevel;
                        ColumnRenderSource adjRenderSource;
                        boolean isCrossRegionBoundary;
                        int xAdj = x + lodDirection.getNormal().x;
                        int zAdj = z + lodDirection.getNormal().z;
                        boolean bl = isCrossRegionBoundary = xAdj < 0 || xAdj >= ColumnRenderSource.SECTION_SIZE || zAdj < 0 || zAdj >= ColumnRenderSource.SECTION_SIZE;
                        if (isCrossRegionBoundary) {
                            adjRenderSource = adjRegions[lodDirection.ordinal() - 2];
                            if (adjRenderSource == null) continue;
                            adjDetailLevel = adjRenderSource.getDataDetail();
                            if (adjDetailLevel == detailLevel) {
                                if (xAdj < 0) {
                                    xAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj < 0) {
                                    zAdj += ColumnRenderSource.SECTION_SIZE;
                                }
                                if (xAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    xAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                                if (zAdj >= ColumnRenderSource.SECTION_SIZE) {
                                    zAdj -= ColumnRenderSource.SECTION_SIZE;
                                }
                            }
                        } else {
                            adjRenderSource = renderSource;
                            adjDetailLevel = detailLevel;
                        }
                        if (adjDetailLevel < detailLevel - 1 || adjDetailLevel > detailLevel + 1) continue;
                        if (adjDetailLevel == detailLevel || adjDetailLevel > detailLevel) {
                            adjColumnViews[lodDirection.ordinal() - 2] = new ColumnArrayView[1];
                            adjColumnViews[lodDirection.ordinal() - 2][0] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                            continue;
                        }
                        adjColumnViews[lodDirection.ordinal() - 2] = new ColumnArrayView[2];
                        adjColumnViews[lodDirection.ordinal() - 2][0] = adjRenderSource.getVerticalDataPointView(xAdj, zAdj);
                        adjColumnViews[lodDirection.ordinal() - 2][1] = adjRenderSource.getVerticalDataPointView(xAdj + (lodDirection.getAxis() == EDhDirection.Axis.X ? 0 : 1), zAdj + (lodDirection.getAxis() == EDhDirection.Axis.Z ? 0 : 1));
                    }
                    catch (RuntimeException e) {
                        EVENT_LOGGER.warn("Failed to get adj data for [" + detailLevel + ":" + x + "," + z + "] at [" + (Object)((Object)lodDirection) + "]", new Object[0]);
                        EVENT_LOGGER.warn("Detail exception: ", e);
                    }
                }
                for (int i = 0; i < columnRenderData.size() && !RenderDataPointUtil.isVoid(data = columnRenderData.get(i)) && RenderDataPointUtil.doesDataPointExist(data); ++i) {
                    long topDataPoint = i - 1 >= 0 ? columnRenderData.get(i - 1) : 0L;
                    long bottomDataPoint = i + 1 < columnRenderData.size() ? columnRenderData.get(i + 1) : 0L;
                    CubicLodTemplate.addLodToBuffer(data, topDataPoint, bottomDataPoint, adjColumnViews, detailLevel, x, z, quadBuilder, debugMode, debugSourceFlag);
                }
            }
        }
        quadBuilder.finalizeData();
    }

    public static GLVertexBuffer[] resizeBuffer(GLVertexBuffer[] vbos, int newSize) {
        if (vbos.length == newSize) {
            return vbos;
        }
        GLVertexBuffer[] newVbos = new GLVertexBuffer[newSize];
        System.arraycopy(vbos, 0, newVbos, 0, Math.min(vbos.length, newSize));
        if (newSize < vbos.length) {
            for (int i = newSize; i < vbos.length; ++i) {
                if (vbos[i] == null) continue;
                vbos[i].close();
            }
        }
        return newVbos;
    }

    public static GLVertexBuffer getOrMakeBuffer(GLVertexBuffer[] vbos, int iIndex, boolean useBuffStorage) {
        if (vbos[iIndex] == null) {
            vbos[iIndex] = new GLVertexBuffer(useBuffStorage);
        }
        return vbos[iIndex];
    }

    public static void setupExecutorService() {
        if (configListener == null) {
            configListener = new ConfigChangeListener<Integer>(Config.Client.Advanced.MultiThreading.numberOfBufferBuilderThreads, threadCount -> ColumnRenderBufferBuilder.setThreadPoolSize(threadCount));
        }
        if (bufferBuilderThreadPool == null || bufferBuilderThreadPool.isTerminated()) {
            LOGGER.info("Starting " + ColumnRenderBufferBuilder.class.getSimpleName());
            ColumnRenderBufferBuilder.setThreadPoolSize(Config.Client.Advanced.MultiThreading.numberOfBufferBuilderThreads.get());
        }
    }

    public static void setThreadPoolSize(int threadPoolSize) {
        if (bufferBuilderThreadPool != null) {
            bufferBuilderThreadPool.shutdown();
        }
        bufferBuilderThreadPool = ThreadUtil.makeRateLimitedThreadPool(threadPoolSize, "Buffer Builder", Config.Client.Advanced.MultiThreading.runTimeRatioForBufferBuilderThreads);
        maxNumberOfConcurrentCalls = threadPoolSize * 3;
    }

    public static void shutdownExecutorService() {
        if (bufferBuilderThreadPool != null) {
            LOGGER.info("Stopping " + ColumnRenderBufferBuilder.class.getSimpleName());
            bufferBuilderThreadPool.shutdownNow();
        }
    }

    private static long getCurrentJobsCount() {
        long jobs = ((ThreadPoolExecutor)bufferBuilderThreadPool).getQueue().stream().filter(runnable -> !((Future)((Object)runnable)).isDone()).count();
        return jobs += ((ThreadPoolExecutor)bufferUploaderThreadPool).getQueue().stream().filter(runnable -> !((Future)((Object)runnable)).isDone()).count();
    }

    public static boolean isBusy() {
        return ColumnRenderBufferBuilder.getCurrentJobsCount() > (long)maxNumberOfConcurrentCalls;
    }

    static {
        maxNumberOfConcurrentCalls = 3;
    }
}

