/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodQuadBuilder;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.coreapi.util.MathUtil;

public class ColumnBox {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);

    public static void addBoxQuadsToBuilder(LodQuadBuilder builder, short xSize, short ySize, short zSize, short x, short minY, short z, int color, byte skyLight, byte blockLight, long topData, long bottomData, ColumnArrayView[][] adjData) {
        boolean skipBottom;
        boolean skipTop;
        boolean isBottomTransparent;
        short maxX = (short)(x + xSize);
        short maxY = (short)(minY + ySize);
        short maxZ = (short)(z + zSize);
        byte skyLightTop = skyLight;
        byte skyLightBot = RenderDataPointUtil.doesDataPointExist(bottomData) ? RenderDataPointUtil.getLightSky(bottomData) : (byte)0;
        boolean isTransparent = ColorUtil.getAlpha(color) < 255 && LodRenderer.transparencyEnabled;
        boolean overVoid = !RenderDataPointUtil.doesDataPointExist(bottomData);
        boolean isTopTransparent = RenderDataPointUtil.getAlpha(topData) < 255 && LodRenderer.transparencyEnabled;
        boolean bl = isBottomTransparent = RenderDataPointUtil.getAlpha(bottomData) < 255 && LodRenderer.transparencyEnabled;
        if (!RenderDataPointUtil.doesDataPointExist(bottomData)) {
            color = ColorUtil.setAlpha(color, 255);
        }
        if (builder.skipQuadsWithZeroSkylight && 0 == skyLight && builder.skyLightCullingBelow > maxY && (RenderDataPointUtil.getAlpha(topData) < 255 && RenderDataPointUtil.getYMax(topData) >= builder.skyLightCullingBelow || RenderDataPointUtil.getYMin(topData) >= builder.skyLightCullingBelow || !RenderDataPointUtil.doesDataPointExist(topData))) {
            maxY = builder.skyLightCullingBelow;
        }
        if (LodRenderer.transparencyEnabled && LodRenderer.fakeOceanFloor) {
            if (!isTransparent && isTopTransparent && RenderDataPointUtil.doesDataPointExist(topData)) {
                skyLightTop = (byte)MathUtil.clamp(0, 15 - (RenderDataPointUtil.getYMax(topData) - minY), 15);
                ySize = (short)(RenderDataPointUtil.getYMax(topData) - minY - 1);
            } else if (isTransparent && !isBottomTransparent && RenderDataPointUtil.doesDataPointExist(bottomData)) {
                minY = (short)(minY + ySize - 1);
                ySize = 1;
            }
            maxY = (short)(minY + ySize);
        }
        boolean bl2 = skipTop = RenderDataPointUtil.doesDataPointExist(topData) && RenderDataPointUtil.getYMin(topData) == maxY && !isTopTransparent;
        if (!skipTop) {
            builder.addQuadUp(x, maxY, z, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(EDhDirection.UP)), skyLightTop, blockLight);
        }
        boolean bl3 = skipBottom = RenderDataPointUtil.doesDataPointExist(bottomData) && RenderDataPointUtil.getYMax(bottomData) == minY && !isBottomTransparent;
        if (!skipBottom) {
            builder.addQuadDown(x, minY, z, xSize, zSize, ColorUtil.applyShade(color, MC.getShade(EDhDirection.DOWN)), skyLightBot, blockLight);
        }
        ColumnArrayView[] adjDataNorth = adjData[EDhDirection.NORTH.ordinal() - 2];
        int adjOverlapNorth = ColorUtil.INVISIBLE;
        if (adjDataNorth == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.NORTH, x, minY, z, xSize, ySize, color, (byte)15, blockLight);
            }
        } else if (adjDataNorth.length == 1) {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataNorth[0], EDhDirection.NORTH, x, minY, z, xSize, ySize, color, adjOverlapNorth, skyLightTop, blockLight, topData, bottomData);
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataNorth[0], EDhDirection.NORTH, x, minY, z, (short)(xSize / 2), ySize, color, adjOverlapNorth, skyLightTop, blockLight, topData, bottomData);
            ColumnBox.makeAdjVerticalQuad(builder, adjDataNorth[1], EDhDirection.NORTH, (short)(x + xSize / 2), minY, z, (short)(xSize / 2), ySize, color, adjOverlapNorth, skyLightTop, blockLight, topData, bottomData);
        }
        ColumnArrayView[] adjDataSouth = adjData[EDhDirection.SOUTH.ordinal() - 2];
        int adjOverlapSouth = ColorUtil.INVISIBLE;
        if (adjDataSouth == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.SOUTH, x, minY, maxZ, xSize, ySize, color, (byte)15, blockLight);
            }
        } else if (adjDataSouth.length == 1) {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataSouth[0], EDhDirection.SOUTH, x, minY, maxZ, xSize, ySize, color, adjOverlapSouth, skyLightTop, blockLight, topData, bottomData);
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataSouth[0], EDhDirection.SOUTH, x, minY, maxZ, (short)(xSize / 2), ySize, color, adjOverlapSouth, skyLightTop, blockLight, topData, bottomData);
            ColumnBox.makeAdjVerticalQuad(builder, adjDataSouth[1], EDhDirection.SOUTH, (short)(x + xSize / 2), minY, maxZ, (short)(xSize / 2), ySize, color, adjOverlapSouth, skyLightTop, blockLight, topData, bottomData);
        }
        ColumnArrayView[] adjDataWest = adjData[EDhDirection.WEST.ordinal() - 2];
        int adjOverlapWest = ColorUtil.INVISIBLE;
        if (adjDataWest == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.WEST, x, minY, z, zSize, ySize, color, (byte)15, blockLight);
            }
        } else if (adjDataWest.length == 1) {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataWest[0], EDhDirection.WEST, x, minY, z, zSize, ySize, color, adjOverlapWest, skyLightTop, blockLight, topData, bottomData);
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataWest[0], EDhDirection.WEST, x, minY, z, (short)(zSize / 2), ySize, color, adjOverlapWest, skyLightTop, blockLight, topData, bottomData);
            ColumnBox.makeAdjVerticalQuad(builder, adjDataWest[1], EDhDirection.WEST, x, minY, (short)(z + zSize / 2), (short)(zSize / 2), ySize, color, adjOverlapWest, skyLightTop, blockLight, topData, bottomData);
        }
        ColumnArrayView[] adjDataEast = adjData[EDhDirection.EAST.ordinal() - 2];
        int adjOverlapEast = ColorUtil.INVISIBLE;
        if (adjData[EDhDirection.EAST.ordinal() - 2] == null) {
            if (!isTransparent || overVoid) {
                builder.addQuadAdj(EDhDirection.EAST, maxX, minY, z, zSize, ySize, color, (byte)15, blockLight);
            }
        } else if (adjDataEast.length == 1) {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataEast[0], EDhDirection.EAST, maxX, minY, z, zSize, ySize, color, adjOverlapEast, skyLightTop, blockLight, topData, bottomData);
        } else {
            ColumnBox.makeAdjVerticalQuad(builder, adjDataEast[0], EDhDirection.EAST, maxX, minY, z, (short)(zSize / 2), ySize, color, adjOverlapEast, skyLightTop, blockLight, topData, bottomData);
            ColumnBox.makeAdjVerticalQuad(builder, adjDataEast[1], EDhDirection.EAST, maxX, minY, (short)(z + zSize / 2), (short)(zSize / 2), ySize, color, adjOverlapEast, skyLightTop, blockLight, topData, bottomData);
        }
    }

    private static void makeAdjVerticalQuad(LodQuadBuilder builder, ColumnArrayView adjColumnView, EDhDirection direction, short x, short yMin, short z, short horizontalWidth, short ySize, int color, int debugOverlapColor, byte skyLightTop, byte blockLight, long topData, long bottomData) {
        color = ColorUtil.applyShade(color, MC.getShade(direction));
        if (adjColumnView == null || adjColumnView.size == 0 || RenderDataPointUtil.isVoid(adjColumnView.get(0))) {
            builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, ySize, color, (byte)15, blockLight);
            return;
        }
        int yMax = yMin + ySize;
        boolean firstFace = true;
        boolean inputAboveAdjLods = true;
        short previousAdjDepth = -1;
        byte nextTopSkyLight = skyLightTop;
        boolean inputTransparent = ColorUtil.getAlpha(color) < 255 && LodRenderer.transparencyEnabled;
        boolean lastAdjWasTransparent = false;
        if (!RenderDataPointUtil.doesDataPointExist(bottomData)) {
            color = ColorUtil.setAlpha(color, 255);
        }
        int adjCount = adjColumnView.size();
        for (int adjIndex = 0; adjIndex < adjCount && RenderDataPointUtil.doesDataPointExist(adjColumnView.get(adjIndex)) && !RenderDataPointUtil.isVoid(adjColumnView.get(adjIndex)); ++adjIndex) {
            boolean adjTransparent;
            long adjPoint = adjColumnView.get(adjIndex);
            boolean bl = adjTransparent = RenderDataPointUtil.getAlpha(adjPoint) < 255 && LodRenderer.transparencyEnabled;
            if (!inputTransparent && adjTransparent) continue;
            short adjYMin = RenderDataPointUtil.getYMin(adjPoint);
            short adjYMax = RenderDataPointUtil.getYMax(adjPoint);
            if (LodRenderer.transparencyEnabled && LodRenderer.fakeOceanFloor) {
                if (lastAdjWasTransparent && !adjTransparent) {
                    adjYMax = (short)(RenderDataPointUtil.getYMax(adjColumnView.get(adjIndex - 1)) - 1);
                } else if (adjTransparent && adjIndex + 1 < adjCount && RenderDataPointUtil.getAlpha(adjColumnView.get(adjIndex + 1)) == 255) {
                    adjYMin = (short)(adjYMax - 1);
                }
            }
            if (yMax <= adjYMin) continue;
            inputAboveAdjLods = false;
            if (adjYMax < yMin) {
                byte skyLight;
                if (adjIndex == 0) {
                    skyLight = RenderDataPointUtil.getLightSky(adjPoint);
                } else {
                    long aboveAdjPoint = adjColumnView.get(adjIndex - 1);
                    if (RenderDataPointUtil.getAlpha(aboveAdjPoint) != 255) {
                        boolean inputMaxHigherThanAboveAdj;
                        boolean bl2 = inputMaxHigherThanAboveAdj = yMax > RenderDataPointUtil.getYMax(aboveAdjPoint);
                        skyLight = inputMaxHigherThanAboveAdj ? RenderDataPointUtil.getLightSky(aboveAdjPoint) : RenderDataPointUtil.getLightSky(adjPoint);
                    } else {
                        skyLight = RenderDataPointUtil.getLightSky(adjPoint);
                    }
                }
                if (firstFace) {
                    builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, ySize, color, skyLight, blockLight);
                    break;
                }
                if (previousAdjDepth == -1) {
                    throw new RuntimeException("Loop error");
                }
                builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, (short)(previousAdjDepth - yMin), color, skyLight, blockLight);
                previousAdjDepth = -1;
                break;
            }
            if (adjYMin <= yMin) {
                if (yMax <= adjYMax) {
                    if (debugOverlapColor == 0) break;
                    builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, ySize, debugOverlapColor, (byte)15, (byte)15);
                    break;
                }
                if (adjYMax > yMin && debugOverlapColor != 0) {
                    builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, (short)(adjYMax - yMin), debugOverlapColor, (byte)15, (byte)15);
                }
                if (firstFace) {
                    builder.addQuadAdj(direction, x, adjYMax, z, horizontalWidth, (short)(yMax - adjYMax), color, RenderDataPointUtil.getLightSky(adjPoint), blockLight);
                    break;
                }
                if (previousAdjDepth == -1) {
                    throw new RuntimeException("Loop error");
                }
                if (previousAdjDepth > adjYMax) {
                    builder.addQuadAdj(direction, x, adjYMax, z, horizontalWidth, (short)(previousAdjDepth - adjYMax), color, RenderDataPointUtil.getLightSky(adjPoint), blockLight);
                }
                previousAdjDepth = -1;
                break;
            }
            if (adjYMax >= yMax) {
                if (debugOverlapColor != 0) {
                    builder.addQuadAdj(direction, x, adjYMin, z, horizontalWidth, (short)(yMax - adjYMin), debugOverlapColor, (byte)15, (byte)15);
                }
            } else {
                if (debugOverlapColor != 0) {
                    builder.addQuadAdj(direction, x, adjYMin, z, horizontalWidth, (short)(adjYMax - adjYMin), debugOverlapColor, (byte)15, (byte)15);
                }
                if (firstFace) {
                    builder.addQuadAdj(direction, x, adjYMax, z, horizontalWidth, (short)(yMax - adjYMax), color, RenderDataPointUtil.getLightSky(adjPoint), blockLight);
                } else {
                    if (previousAdjDepth == -1) {
                        throw new RuntimeException("Loop error");
                    }
                    if (previousAdjDepth > adjYMax) {
                        builder.addQuadAdj(direction, x, adjYMax, z, horizontalWidth, (short)(previousAdjDepth - adjYMax), color, RenderDataPointUtil.getLightSky(adjPoint), blockLight);
                    }
                    previousAdjDepth = -1;
                }
            }
            previousAdjDepth = adjYMin;
            firstFace = false;
            nextTopSkyLight = skyLightTop;
            if (adjIndex + 1 < adjColumnView.size() && RenderDataPointUtil.doesDataPointExist(adjColumnView.get(adjIndex + 1))) {
                nextTopSkyLight = RenderDataPointUtil.getLightSky(adjColumnView.get(adjIndex + 1));
            }
            lastAdjWasTransparent = adjTransparent;
        }
        if (inputAboveAdjLods) {
            builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, ySize, color, skyLightTop, blockLight);
        } else if (previousAdjDepth != -1) {
            builder.addQuadAdj(direction, x, yMin, z, horizontalWidth, (short)(previousAdjDepth - yMin), color, nextTopSkyLight, blockLight);
        }
    }
}

