/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;

public interface IIncompleteFullDataSource
extends IFullDataSource {
    default public void sampleFrom(IFullDataSource inputSource) {
        DhSectionPos inputPos = inputSource.getSectionPos();
        DhSectionPos thisPos = this.getSectionPos();
        LodUtil.assertTrue(inputPos.getDetailLevel() < thisPos.getDetailLevel());
        LodUtil.assertTrue(inputPos.overlapsExactly(this.getSectionPos()));
        if (inputSource.isEmpty()) {
            return;
        }
        this.markNotEmpty();
        DhLodPos baseOffset = thisPos.getMinCornerLodPos(this.getDataDetailLevel());
        DhSectionPos inputOffset = inputPos.convertNewToDetailLevel(this.getDataDetailLevel());
        int offsetX = inputOffset.getX() - baseOffset.x;
        int offsetZ = inputOffset.getZ() - baseOffset.z;
        int numberOfDataPointsToUpdate = this.getWidthInDataPoints() / thisPos.getWidthCountForLowerDetailedSection(inputSource.getSectionPos().getDetailLevel());
        numberOfDataPointsToUpdate = Math.max(1, numberOfDataPointsToUpdate);
        int inputFractionWidth = inputSource.getWidthInDataPoints() / numberOfDataPointsToUpdate;
        for (int x = 0; x < numberOfDataPointsToUpdate; ++x) {
            for (int z = 0; z < numberOfDataPointsToUpdate; ++z) {
                SingleColumnFullDataAccessor thisDataColumn = this.getOrCreate(offsetX + x, offsetZ + z);
                SingleColumnFullDataAccessor inputDataColumn = inputSource.tryGet(inputFractionWidth * x, inputFractionWidth * z);
                if (inputDataColumn == null) continue;
                inputDataColumn.deepCopyTo(thisDataColumn);
            }
        }
    }

    public IFullDataSource tryPromotingToCompleteDataSource();

    public boolean hasBeenPromoted();
}

