/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.FullDataArrayAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IStreamableFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.io.IOException;
import java.util.BitSet;
import org.apache.logging.log4j.Logger;

public class LowDetailIncompleteFullDataSource
extends FullDataArrayAccessor
implements IIncompleteFullDataSource,
IStreamableFullDataSource<IStreamableFullDataSource.FullDataSourceSummaryData, StreamDataPointContainer> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int WIDTH = BitShiftUtil.powerOfTwo(6);
    public static final byte DATA_FORMAT_VERSION = 3;
    public static final long TYPE_ID = "LowDetailIncompleteFullDataSource".hashCode();
    private DhSectionPos sectionPos;
    private final BitSet isColumnNotEmpty;
    private boolean isEmpty = true;
    public EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.EMPTY;
    private boolean isPromoted = false;

    public static LowDetailIncompleteFullDataSource createEmpty(DhSectionPos pos) {
        return new LowDetailIncompleteFullDataSource(pos);
    }

    private LowDetailIncompleteFullDataSource(DhSectionPos sectionPos) {
        super(new FullDataPointIdMap(sectionPos), new long[WIDTH * WIDTH][0], WIDTH);
        LodUtil.assertTrue(sectionPos.getDetailLevel() > 10);
        this.sectionPos = sectionPos;
        this.isColumnNotEmpty = new BitSet(WIDTH * WIDTH);
        this.worldGenStep = EDhApiWorldGenerationStep.EMPTY;
    }

    private LowDetailIncompleteFullDataSource(DhSectionPos pos, FullDataPointIdMap mapping, EDhApiWorldGenerationStep worldGenStep, BitSet isColumnNotEmpty, long[][] data) {
        super(mapping, data, WIDTH);
        LodUtil.assertTrue(data.length == WIDTH * WIDTH);
        this.sectionPos = pos;
        this.isColumnNotEmpty = isColumnNotEmpty;
        this.worldGenStep = worldGenStep;
        this.isEmpty = false;
    }

    @Override
    public void writeSourceSummaryInfo(IDhLevel level, DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getDataDetailLevel());
        outputStream.writeInt(this.width);
        outputStream.writeInt(level.getMinY());
        outputStream.writeByte(this.worldGenStep.value);
    }

    @Override
    public IStreamableFullDataSource.FullDataSourceSummaryData readSourceSummaryInfo(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException {
        EDhApiWorldGenerationStep worldGenStep;
        int dataDetail = inputStream.readInt();
        if (dataDetail != dataFile.baseMetaData.dataLevel) {
            throw new IOException(LodUtil.formatLog("Data level mismatch: " + dataDetail + " != " + dataFile.baseMetaData.dataLevel, new Object[0]));
        }
        int width = inputStream.readInt();
        if (width != WIDTH) {
            throw new IOException(LodUtil.formatLog("Section size mismatch: " + width + " != " + WIDTH + " (Currently only 1 section size is supported)", new Object[0]));
        }
        int minY = inputStream.readInt();
        if (minY != level.getMinY()) {
            LOGGER.warn("Data minY mismatch: " + minY + " != " + level.getMinY() + ". Will ignore data's y level");
        }
        if ((worldGenStep = EDhApiWorldGenerationStep.fromValue(inputStream.readByte())) == null) {
            worldGenStep = EDhApiWorldGenerationStep.SURFACE;
            LOGGER.warn("Missing WorldGenStep, defaulting to: " + worldGenStep.name());
        }
        return new IStreamableFullDataSource.FullDataSourceSummaryData(this.width, worldGenStep);
    }

    @Override
    public void setSourceSummaryData(IStreamableFullDataSource.FullDataSourceSummaryData summaryData) {
        this.worldGenStep = summaryData.worldGenStep;
    }

    @Override
    public boolean writeDataPoints(DhDataOutputStream dataOutputStream) throws IOException {
        if (this.isEmpty) {
            dataOutputStream.writeInt(1);
            return false;
        }
        dataOutputStream.writeInt(-1);
        byte[] bytes = this.isColumnNotEmpty.toByteArray();
        dataOutputStream.writeInt(bytes.length);
        dataOutputStream.write(bytes);
        dataOutputStream.writeInt(-1);
        int i = this.isColumnNotEmpty.nextSetBit(0);
        while (i >= 0) {
            dataOutputStream.writeByte(this.dataArrays[i].length);
            for (long dataPoint : this.dataArrays[i]) {
                dataOutputStream.writeLong(dataPoint);
            }
            i = this.isColumnNotEmpty.nextSetBit(i + 1);
        }
        return true;
    }

    @Override
    public StreamDataPointContainer readDataPoints(FullDataMetaFile dataFile, int width, DhDataInputStream inputStream) throws IOException {
        int dataPresentFlag = inputStream.readInt();
        if (dataPresentFlag == 1) {
            return null;
        }
        if (dataPresentFlag != -1) {
            throw new IOException("Invalid file format. Data Points guard byte expected: (no data) [1] or (data present) [-1], but found [" + dataPresentFlag + "].");
        }
        int length = inputStream.readInt();
        if (length < 0 || length > (WIDTH * WIDTH / 8 + 64) * 2) {
            throw new IOException(LodUtil.formatLog("Spotty Flag BitSet size outside reasonable range: {} (expects {} to {})", length, 1, WIDTH * WIDTH / 8 + 63));
        }
        byte[] bytes = new byte[length];
        inputStream.readFully(bytes, 0, length);
        BitSet isColumnNotEmpty = BitSet.valueOf(bytes);
        long[][] dataPointArray = new long[WIDTH * WIDTH][];
        dataPresentFlag = inputStream.readInt();
        if (dataPresentFlag != -1) {
            throw new IOException("invalid spotty flag end guard");
        }
        int xz = isColumnNotEmpty.nextSetBit(0);
        while (xz >= 0) {
            long[] array = new long[inputStream.readByte()];
            for (int y = 0; y < array.length; ++y) {
                array[y] = inputStream.readLong();
            }
            dataPointArray[xz] = array;
            xz = isColumnNotEmpty.nextSetBit(xz + 1);
        }
        return new StreamDataPointContainer(dataPointArray, isColumnNotEmpty);
    }

    @Override
    public void setDataPoints(StreamDataPointContainer streamDataPointContainer) {
        long[][] dataPoints = streamDataPointContainer.dataPoints;
        LodUtil.assertTrue(this.dataArrays.length == dataPoints.length, "Data point array length mismatch.");
        System.arraycopy(dataPoints, 0, this.dataArrays, 0, dataPoints.length);
        for (int i = 0; i < streamDataPointContainer.isColumnNotEmpty.length(); ++i) {
            this.isColumnNotEmpty.set(i, streamDataPointContainer.isColumnNotEmpty.get(i));
        }
        this.isEmpty = false;
    }

    @Override
    public void writeIdMappings(DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(-1);
        this.mapping.serialize(outputStream);
    }

    @Override
    public FullDataPointIdMap readIdMappings(StreamDataPointContainer streamDataPointContainer, DhDataInputStream inputStream, ILevelWrapper levelWrapper) throws IOException, InterruptedException {
        int dataPresentFlag = inputStream.readInt();
        if (dataPresentFlag != -1) {
            throw new IOException("invalid ID mapping end guard");
        }
        return FullDataPointIdMap.deserialize(inputStream, this.sectionPos, levelWrapper);
    }

    @Override
    public void setIdMapping(FullDataPointIdMap mappings) {
        this.mapping.mergeAndReturnRemappedEntityIds(mappings);
    }

    @Override
    public SingleColumnFullDataAccessor tryGet(int relativeX, int relativeZ) {
        return this.tryGetOrCreate(relativeX, relativeZ, false);
    }

    @Override
    public SingleColumnFullDataAccessor getOrCreate(int relativeX, int relativeZ) {
        return this.tryGetOrCreate(relativeX, relativeZ, true);
    }

    private SingleColumnFullDataAccessor tryGetOrCreate(int relativeX, int relativeZ, boolean createIfMissing) {
        int notEmptyIndex = relativeX * WIDTH + relativeZ;
        boolean columnEmpty = this.isColumnNotEmpty.get(notEmptyIndex);
        if (columnEmpty && createIfMissing) {
            this.isColumnNotEmpty.set(notEmptyIndex, true);
            columnEmpty = false;
        }
        return !columnEmpty ? this.get(relativeX, relativeZ) : null;
    }

    @Override
    public DhSectionPos getSectionPos() {
        return this.sectionPos;
    }

    @Override
    public void resizeDataStructuresForRepopulation(DhSectionPos pos) {
        this.sectionPos = pos;
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(this.sectionPos.getDetailLevel() - 6);
    }

    @Override
    public byte getBinaryDataFormatVersion() {
        return 3;
    }

    @Override
    public EDhApiWorldGenerationStep getWorldGenStep() {
        return this.worldGenStep;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void markNotEmpty() {
        this.isEmpty = false;
    }

    @Override
    public int getWidthInDataPoints() {
        return WIDTH;
    }

    @Override
    public void update(ChunkSizedFullDataAccessor data) {
        LodUtil.assertTrue(this.sectionPos.overlapsExactly(data.getSectionPos()));
        if (this.getDataDetailLevel() >= 4) {
            int chunkPerFull = 1 << this.getDataDetailLevel() - 4;
            if (data.chunkPos.x % chunkPerFull != 0 || data.chunkPos.z % chunkPerFull != 0) {
                return;
            }
            DhLodPos baseOffset = this.sectionPos.getMinCornerLodPos(this.getDataDetailLevel());
            DhSectionPos dataOffset = data.getSectionPos().convertNewToDetailLevel(this.getDataDetailLevel());
            int offsetX = dataOffset.getX() - baseOffset.x;
            int offsetZ = dataOffset.getZ() - baseOffset.z;
            LodUtil.assertTrue(offsetX >= 0 && offsetX < WIDTH && offsetZ >= 0 && offsetZ < WIDTH);
            this.isEmpty = false;
            SingleColumnFullDataAccessor columnFullDataAccessor = this.get(offsetX, offsetZ);
            data.get(0, 0).deepCopyTo(columnFullDataAccessor);
            this.isColumnNotEmpty.set(offsetX * WIDTH + offsetZ, columnFullDataAccessor.doesColumnExist());
        } else {
            LodUtil.assertNotReach();
        }
    }

    @Override
    public IFullDataSource tryPromotingToCompleteDataSource() {
        if (this.isEmpty) {
            return this;
        }
        if (this.isColumnNotEmpty.cardinality() != WIDTH * WIDTH) {
            return this;
        }
        this.isPromoted = true;
        return new CompleteFullDataSource(this.sectionPos, this.mapping, this.dataArrays);
    }

    @Override
    public boolean hasBeenPromoted() {
        return this.isPromoted;
    }

    public static boolean neededForPosition(DhSectionPos posToWrite, DhSectionPos posToTest) {
        if (!posToWrite.overlapsExactly(posToTest)) {
            return false;
        }
        if (posToTest.getDetailLevel() > posToWrite.getDetailLevel()) {
            return false;
        }
        if (posToWrite.getDetailLevel() - posToTest.getDetailLevel() <= 6) {
            return true;
        }
        byte sectPerData = (byte)(1 << posToWrite.getDetailLevel() - posToTest.getDetailLevel() - 6);
        return posToTest.getX() % sectPerData == 0 && posToTest.getZ() % sectPerData == 0;
    }

    public static class StreamDataPointContainer {
        public long[][] dataPoints;
        public BitSet isColumnNotEmpty;

        public StreamDataPointContainer(long[][] dataPoints, BitSet isColumnNotEmpty) {
            this.dataPoints = dataPoints;
            this.isColumnNotEmpty = isColumnNotEmpty;
        }
    }
}

