/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.FullDataArrayAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IStreamableFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.io.IOException;
import java.util.BitSet;
import org.apache.logging.log4j.Logger;

public class HighDetailIncompleteFullDataSource
implements IIncompleteFullDataSource,
IStreamableFullDataSource<IStreamableFullDataSource.FullDataSourceSummaryData, long[][][]> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final byte SPARSE_UNIT_DETAIL = 4;
    public static final byte SPARSE_UNIT_SIZE = (byte)BitShiftUtil.powerOfTwo(4);
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int SECTION_SIZE = (byte)BitShiftUtil.powerOfTwo(6);
    public static final byte MAX_SECTION_DETAIL = 10;
    public static final byte DATA_FORMAT_VERSION = 3;
    public static final long TYPE_ID = "HighDetailIncompleteFullDataSource".hashCode();
    protected final FullDataPointIdMap mapping;
    private DhSectionPos sectionPos;
    private FullDataArrayAccessor[] sparseData;
    private DhLodPos chunkPos;
    public int sectionCount;
    public int dataPointsPerSection;
    public boolean isEmpty = true;
    public EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.EMPTY;
    private boolean isPromoted = false;

    public static HighDetailIncompleteFullDataSource createEmpty(DhSectionPos pos) {
        return new HighDetailIncompleteFullDataSource(pos);
    }

    private HighDetailIncompleteFullDataSource(DhSectionPos sectionPos) {
        LodUtil.assertTrue(sectionPos.getDetailLevel() > 4);
        LodUtil.assertTrue(sectionPos.getDetailLevel() <= 10);
        this.sectionPos = sectionPos;
        this.sectionCount = BitShiftUtil.powerOfTwo(sectionPos.getDetailLevel() - 4);
        this.dataPointsPerSection = SECTION_SIZE / this.sectionCount;
        this.sparseData = new FullDataArrayAccessor[this.sectionCount * this.sectionCount];
        this.chunkPos = sectionPos.getMinCornerLodPos((byte)4);
        this.mapping = new FullDataPointIdMap(sectionPos);
    }

    protected HighDetailIncompleteFullDataSource(DhSectionPos sectionPos, FullDataPointIdMap mapping, FullDataArrayAccessor[] data) {
        LodUtil.assertTrue(sectionPos.getDetailLevel() > 4);
        LodUtil.assertTrue(sectionPos.getDetailLevel() <= 10);
        this.sectionPos = sectionPos;
        this.sectionCount = 1 << (byte)(sectionPos.getDetailLevel() - 4);
        this.dataPointsPerSection = SECTION_SIZE / this.sectionCount;
        LodUtil.assertTrue(this.sectionCount * this.sectionCount == data.length);
        this.sparseData = data;
        this.chunkPos = sectionPos.getMinCornerLodPos((byte)4);
        this.isEmpty = false;
        this.mapping = mapping;
    }

    @Override
    public void writeSourceSummaryInfo(IDhLevel level, DhDataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getDataDetailLevel());
        dataOutputStream.writeShort(4);
        dataOutputStream.writeInt(SECTION_SIZE);
        dataOutputStream.writeInt(level.getMinY());
        dataOutputStream.writeByte(this.worldGenStep.value);
    }

    @Override
    public IStreamableFullDataSource.FullDataSourceSummaryData readSourceSummaryInfo(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException {
        EDhApiWorldGenerationStep worldGenStep;
        LodUtil.assertTrue(dataFile.pos.getDetailLevel() > 4);
        LodUtil.assertTrue(dataFile.pos.getDetailLevel() <= 10);
        short dataDetail = inputStream.readShort();
        if (dataDetail != dataFile.baseMetaData.dataLevel) {
            throw new IOException(LodUtil.formatLog("Data level mismatch: {} != {}", dataDetail, dataFile.baseMetaData.dataLevel));
        }
        short sparseDetail = inputStream.readShort();
        if (sparseDetail != 4) {
            throw new IOException(LodUtil.formatLog("Unexpected sparse detail level: {} != {}", sparseDetail, (byte)4));
        }
        int sectionSize = inputStream.readInt();
        if (sectionSize != SECTION_SIZE) {
            throw new IOException(LodUtil.formatLog("Section size mismatch: {} != {} (Currently only 1 section size is supported)", sectionSize, SECTION_SIZE));
        }
        int minY = inputStream.readInt();
        if (minY != level.getMinY()) {
            LOGGER.warn("Data minY mismatch: " + minY + " != " + level.getMinY() + ". Will ignore data's y level");
        }
        if ((worldGenStep = EDhApiWorldGenerationStep.fromValue(inputStream.readByte())) == null) {
            worldGenStep = EDhApiWorldGenerationStep.SURFACE;
            LOGGER.warn("Missing WorldGenStep, defaulting to: " + worldGenStep.name());
        }
        return new IStreamableFullDataSource.FullDataSourceSummaryData(-1, worldGenStep);
    }

    @Override
    public void setSourceSummaryData(IStreamableFullDataSource.FullDataSourceSummaryData summaryData) {
        this.worldGenStep = summaryData.worldGenStep;
    }

    @Override
    public boolean writeDataPoints(DhDataOutputStream dataOutputStream) throws IOException {
        if (this.isEmpty) {
            dataOutputStream.writeInt(1);
            return false;
        }
        dataOutputStream.writeInt(-1);
        BitSet dataArrayIndexHasData = new BitSet(this.sparseData.length);
        for (int i = 0; i < this.sparseData.length; ++i) {
            dataArrayIndexHasData.set(i, this.sparseData[i] != null);
        }
        byte[] bytes = dataArrayIndexHasData.toByteArray();
        dataOutputStream.writeInt(bytes.length);
        dataOutputStream.write(bytes);
        dataOutputStream.writeInt(-1);
        int dataArrayIndex = dataArrayIndexHasData.nextSetBit(0);
        while (dataArrayIndex >= 0) {
            int z;
            int x;
            FullDataArrayAccessor array = this.sparseData[dataArrayIndex];
            LodUtil.assertTrue(array != null);
            for (x = 0; x < array.width(); ++x) {
                for (z = 0; z < array.width(); ++z) {
                    dataOutputStream.writeInt(array.get(x, z).getSingleLength());
                }
            }
            for (x = 0; x < array.width(); ++x) {
                for (z = 0; z < array.width(); ++z) {
                    long[] rawDataPoints;
                    SingleColumnFullDataAccessor column = array.get(x, z);
                    LodUtil.assertTrue(column.getMapping() == this.mapping);
                    if (!column.doesColumnExist()) continue;
                    for (long dataPoint : rawDataPoints = column.getRaw()) {
                        dataOutputStream.writeLong(dataPoint);
                    }
                }
            }
            dataArrayIndex = dataArrayIndexHasData.nextSetBit(dataArrayIndex + 1);
        }
        return true;
    }

    @Override
    public long[][][] readDataPoints(FullDataMetaFile dataFile, int width, DhDataInputStream inputStream) throws IOException {
        int chunks = BitShiftUtil.powerOfTwo(dataFile.pos.getDetailLevel() - 4);
        int dataPointsPerChunk = SECTION_SIZE / chunks;
        int dataPresentFlag = inputStream.readInt();
        if (dataPresentFlag == 1) {
            return null;
        }
        if (dataPresentFlag != -1) {
            throw new IOException("Invalid file format. Data Points guard byte expected: (no data) [1] or (data present) [-1], but found [" + dataPresentFlag + "].");
        }
        int numberOfDataColumns = inputStream.readInt();
        int maxNumberOfDataColumns = (chunks * chunks / 8 + 64) * 2;
        if (numberOfDataColumns < 0 || numberOfDataColumns > maxNumberOfDataColumns) {
            throw new IOException(LodUtil.formatLog("Sparse Flag BitSet size outside reasonable range: {} (expects {} to {})", numberOfDataColumns, 1, maxNumberOfDataColumns));
        }
        byte[] bytes = new byte[numberOfDataColumns];
        inputStream.readFully(bytes, 0, numberOfDataColumns);
        BitSet dataArrayIndexHasData = BitSet.valueOf(bytes);
        int dataArrayStartByte = inputStream.readInt();
        if (dataArrayStartByte != -1) {
            throw new IOException("invalid data length end guard");
        }
        long[][][] rawFullDataArrays = new long[chunks * chunks][][];
        int fullDataIndex = dataArrayIndexHasData.nextSetBit(0);
        while (fullDataIndex >= 0 && fullDataIndex < rawFullDataArrays.length) {
            int x;
            long[][] dataColumn = new long[dataPointsPerChunk * dataPointsPerChunk][];
            rawFullDataArrays[fullDataIndex] = dataColumn;
            for (x = 0; x < dataColumn.length; ++x) {
                int dataColumnLength = inputStream.readInt();
                dataColumn[x] = new long[dataColumnLength];
            }
            for (x = 0; x < dataColumn.length; ++x) {
                if (dataColumn[x].length == 0) continue;
                for (int z = 0; z < dataColumn[x].length; ++z) {
                    dataColumn[x][z] = inputStream.readLong();
                }
            }
            fullDataIndex = dataArrayIndexHasData.nextSetBit(fullDataIndex + 1);
        }
        return rawFullDataArrays;
    }

    @Override
    public void setDataPoints(long[][][] dataPoints) {
        LodUtil.assertTrue(this.sparseData.length == dataPoints.length, "Data point array length mismatch.");
        this.isEmpty = false;
        for (int arrayAccessorIndex = 0; arrayAccessorIndex < dataPoints.length; ++arrayAccessorIndex) {
            if (dataPoints[arrayAccessorIndex] == null) {
                this.sparseData[arrayAccessorIndex] = null;
                continue;
            }
            if (this.sparseData[arrayAccessorIndex] == null) {
                int width = (int)Math.sqrt(dataPoints[arrayAccessorIndex].length);
                this.sparseData[arrayAccessorIndex] = new FullDataArrayAccessor(this.mapping, dataPoints[arrayAccessorIndex], width);
                continue;
            }
            for (int dataPointColIndex = 0; dataPointColIndex < dataPoints[arrayAccessorIndex].length; ++dataPointColIndex) {
                long[] incomingColumn = dataPoints[arrayAccessorIndex][dataPointColIndex];
                long[] destinationColumn = this.sparseData[arrayAccessorIndex].get(dataPointColIndex).getRaw();
                if (incomingColumn.length == destinationColumn.length) {
                    System.arraycopy(incomingColumn, 0, destinationColumn, 0, incomingColumn.length);
                    continue;
                }
                this.sparseData[arrayAccessorIndex].get(dataPointColIndex).setNew(incomingColumn);
            }
        }
    }

    @Override
    public FullDataPointIdMap readIdMappings(long[][][] dataPoints, DhDataInputStream inputStream, ILevelWrapper levelWrapper) throws IOException, InterruptedException {
        int idMappingStartByte = inputStream.readInt();
        if (idMappingStartByte != -1) {
            throw new IOException("invalid data content end guard");
        }
        return FullDataPointIdMap.deserialize(inputStream, this.sectionPos, levelWrapper);
    }

    @Override
    public void writeIdMappings(DhDataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(-1);
        this.mapping.serialize(dataOutputStream);
    }

    @Override
    public void setIdMapping(FullDataPointIdMap mappings) {
        this.mapping.mergeAndReturnRemappedEntityIds(mappings);
    }

    @Override
    public SingleColumnFullDataAccessor tryGet(int relativeX, int relativeZ) {
        return this.tryGetOrCreate(relativeX, relativeZ, false);
    }

    @Override
    public SingleColumnFullDataAccessor getOrCreate(int relativeX, int relativeZ) {
        return this.tryGetOrCreate(relativeX, relativeZ, true);
    }

    private SingleColumnFullDataAccessor tryGetOrCreate(int relativeX, int relativeZ, boolean createIfMissing) {
        LodUtil.assertTrue(relativeX >= 0 && relativeX < SECTION_SIZE && relativeZ >= 0 && relativeZ < SECTION_SIZE);
        int chunkX = relativeX / this.dataPointsPerSection;
        int chunkZ = relativeZ / this.dataPointsPerSection;
        FullDataArrayAccessor accessor = this.sparseData[chunkX * this.sectionCount + chunkZ];
        if (accessor == null) {
            if (createIfMissing) {
                this.sparseData[chunkX * this.sectionCount + chunkZ] = accessor = new FullDataArrayAccessor(this.mapping, new long[this.dataPointsPerSection * this.dataPointsPerSection][], this.dataPointsPerSection);
            } else {
                return null;
            }
        }
        return accessor.get(relativeX % this.dataPointsPerSection, relativeZ % this.dataPointsPerSection);
    }

    @Override
    public DhSectionPos getSectionPos() {
        return this.sectionPos;
    }

    @Override
    public void resizeDataStructuresForRepopulation(DhSectionPos pos) {
        this.sectionPos = pos;
        this.sectionCount = BitShiftUtil.powerOfTwo(this.sectionPos.getDetailLevel() - 4);
        this.dataPointsPerSection = SECTION_SIZE / this.sectionCount;
        this.chunkPos = this.sectionPos.getMinCornerLodPos((byte)4);
        int dataPointCount = this.sectionCount * this.sectionCount;
        if (this.sparseData.length != dataPointCount) {
            this.sparseData = new FullDataArrayAccessor[this.sectionCount * this.sectionCount];
        }
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(this.sectionPos.getDetailLevel() - 6);
    }

    @Override
    public byte getBinaryDataFormatVersion() {
        return 3;
    }

    @Override
    public EDhApiWorldGenerationStep getWorldGenStep() {
        return this.worldGenStep;
    }

    @Override
    public FullDataPointIdMap getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void markNotEmpty() {
        this.isEmpty = false;
    }

    @Override
    public int getWidthInDataPoints() {
        return SECTION_SIZE;
    }

    private int calculateOffset(int chunkX, int chunkZ) {
        int offsetX = chunkX - this.chunkPos.x;
        int offsetZ = chunkZ - this.chunkPos.z;
        LodUtil.assertTrue(offsetX >= 0 && offsetZ >= 0 && offsetX < this.sectionCount && offsetZ < this.sectionCount);
        return offsetX * this.sectionCount + offsetZ;
    }

    @Override
    public void update(ChunkSizedFullDataAccessor chunkDataView) {
        int arrayOffset = this.calculateOffset(chunkDataView.chunkPos.x, chunkDataView.chunkPos.z);
        FullDataArrayAccessor newArray = new FullDataArrayAccessor(this.mapping, new long[this.dataPointsPerSection * this.dataPointsPerSection][], this.dataPointsPerSection);
        if (this.getDataDetailLevel() == chunkDataView.detailLevel) {
            chunkDataView.shadowCopyTo(newArray);
        } else {
            int count = this.dataPointsPerSection;
            int dataPerCount = SPARSE_UNIT_SIZE / this.dataPointsPerSection;
            for (int xOffset = 0; xOffset < count; ++xOffset) {
                for (int zOffset = 0; zOffset < count; ++zOffset) {
                    SingleColumnFullDataAccessor column = newArray.get(xOffset, zOffset);
                    column.downsampleFrom(chunkDataView.subView(dataPerCount, xOffset * dataPerCount, zOffset * dataPerCount));
                }
            }
        }
        this.isEmpty = false;
        this.sparseData[arrayOffset] = newArray;
    }

    private void applyToFullDataSource(CompleteFullDataSource dataSource) {
        LodUtil.assertTrue(dataSource.getSectionPos().equals(this.sectionPos));
        LodUtil.assertTrue(dataSource.getDataDetailLevel() == this.getDataDetailLevel());
        for (int x = 0; x < this.sectionCount; ++x) {
            for (int z = 0; z < this.sectionCount; ++z) {
                FullDataArrayAccessor array = this.sparseData[x * this.sectionCount + z];
                if (array == null) continue;
                dataSource.markNotEmpty();
                FullDataArrayAccessor view = dataSource.subView(this.dataPointsPerSection, x * this.dataPointsPerSection, z * this.dataPointsPerSection);
                array.shadowCopyTo(view);
            }
        }
    }

    @Override
    public IFullDataSource tryPromotingToCompleteDataSource() {
        if (this.isEmpty) {
            return this;
        }
        for (FullDataArrayAccessor array : this.sparseData) {
            if (array != null) continue;
            return this;
        }
        this.isPromoted = true;
        CompleteFullDataSource fullDataSource = CompleteFullDataSource.createEmpty(this.sectionPos);
        this.applyToFullDataSource(fullDataSource);
        return fullDataSource;
    }

    @Override
    public boolean hasBeenPromoted() {
        return this.isPromoted;
    }
}

