/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.sources;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.FullDataArrayAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.SingleColumnFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IStreamableFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;

public class CompleteFullDataSource
extends FullDataArrayAccessor
implements IFullDataSource,
IStreamableFullDataSource<IStreamableFullDataSource.FullDataSourceSummaryData, long[][]> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int WIDTH = BitShiftUtil.powerOfTwo(6);
    public static final byte DATA_FORMAT_VERSION = 3;
    public static final long TYPE_ID = "CompleteFullDataSource".hashCode();
    private DhSectionPos sectionPos;
    private boolean isEmpty = true;
    public EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.EMPTY;

    public static CompleteFullDataSource createEmpty(DhSectionPos pos) {
        return new CompleteFullDataSource(pos);
    }

    private CompleteFullDataSource(DhSectionPos sectionPos) {
        super(new FullDataPointIdMap(sectionPos), new long[WIDTH * WIDTH][0], WIDTH);
        this.sectionPos = sectionPos;
    }

    public CompleteFullDataSource(DhSectionPos pos, FullDataPointIdMap mapping, long[][] data) {
        super(mapping, data, WIDTH);
        LodUtil.assertTrue(data.length == WIDTH * WIDTH);
        this.sectionPos = pos;
        this.isEmpty = false;
    }

    @Override
    public void writeSourceSummaryInfo(IDhLevel level, DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getDataDetailLevel());
        outputStream.writeInt(this.width);
        outputStream.writeInt(level.getMinY());
        outputStream.writeByte(this.worldGenStep.value);
    }

    @Override
    public IStreamableFullDataSource.FullDataSourceSummaryData readSourceSummaryInfo(FullDataMetaFile dataFile, DhDataInputStream inputStream, IDhLevel level) throws IOException {
        byte worldGenByte;
        EDhApiWorldGenerationStep worldGenStep;
        int dataDetail = inputStream.readInt();
        if (dataDetail != dataFile.baseMetaData.dataLevel) {
            throw new IOException(LodUtil.formatLog("Data level mismatch: " + dataDetail + " != " + dataFile.baseMetaData.dataLevel, new Object[0]));
        }
        int width = inputStream.readInt();
        if (width != WIDTH) {
            throw new IOException(LodUtil.formatLog("Section width mismatch: " + width + " != " + WIDTH + " (Currently only 1 section width is supported)", new Object[0]));
        }
        int minY = inputStream.readInt();
        if (minY != level.getMinY()) {
            LOGGER.warn("Data minY mismatch: " + minY + " != " + level.getMinY() + ". Will ignore data's y level");
        }
        if ((worldGenStep = EDhApiWorldGenerationStep.fromValue(worldGenByte = inputStream.readByte())) == null) {
            worldGenStep = EDhApiWorldGenerationStep.SURFACE;
            LOGGER.warn("Missing WorldGenStep, defaulting to: " + worldGenStep.name());
        }
        return new IStreamableFullDataSource.FullDataSourceSummaryData(width, worldGenStep);
    }

    @Override
    public void setSourceSummaryData(IStreamableFullDataSource.FullDataSourceSummaryData summaryData) {
        this.worldGenStep = summaryData.worldGenStep;
    }

    @Override
    public boolean writeDataPoints(DhDataOutputStream outputStream) throws IOException {
        int z;
        int x;
        if (this.isEmpty()) {
            outputStream.writeInt(1);
            return false;
        }
        outputStream.writeInt(-1);
        for (x = 0; x < this.width; ++x) {
            for (z = 0; z < this.width; ++z) {
                outputStream.writeInt(this.get(x, z).getSingleLength());
            }
        }
        outputStream.writeInt(-1);
        for (x = 0; x < this.width; ++x) {
            for (z = 0; z < this.width; ++z) {
                long[] dataPointArray;
                SingleColumnFullDataAccessor columnAccessor = this.get(x, z);
                if (!columnAccessor.doesColumnExist()) continue;
                for (long dataPoint : dataPointArray = columnAccessor.getRaw()) {
                    outputStream.writeLong(dataPoint);
                }
            }
        }
        return true;
    }

    @Override
    public long[][] readDataPoints(FullDataMetaFile dataFile, int width, DhDataInputStream dataInputStream) throws IOException {
        int dataPresentFlag = dataInputStream.readInt();
        if (dataPresentFlag == 1) {
            return null;
        }
        if (dataPresentFlag != -1) {
            throw new IOException("Invalid file format. Data Points guard byte expected: (no data) [1] or (data present) [-1], but found [" + dataPresentFlag + "].");
        }
        Object dataPointArrays = this.width == width ? this.dataArrays : (Object)new long[width * width][];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < width; ++z) {
                int requestedArrayLength = dataInputStream.readInt();
                int arrayIndex = x * width + z;
                if (dataPointArrays[arrayIndex] == null || dataPointArrays[arrayIndex].length != requestedArrayLength) {
                    dataPointArrays[arrayIndex] = new long[requestedArrayLength];
                    continue;
                }
                Arrays.fill(dataPointArrays[arrayIndex], 0L);
            }
        }
        int arrayStartFlag = dataInputStream.readInt();
        if (arrayStartFlag != -1) {
            throw new IOException("invalid data length end guard");
        }
        for (int xz = 0; xz < ((long[][])dataPointArrays).length; ++xz) {
            if (dataPointArrays[xz].length == 0) continue;
            for (int y = 0; y < dataPointArrays[xz].length; ++y) {
                dataPointArrays[xz][y] = dataInputStream.readLong();
            }
        }
        return dataPointArrays;
    }

    @Override
    public void setDataPoints(long[][] dataPoints) {
        LodUtil.assertTrue(this.dataArrays.length == dataPoints.length, "Data point array length mismatch.");
        this.isEmpty = false;
        System.arraycopy(dataPoints, 0, this.dataArrays, 0, dataPoints.length);
    }

    @Override
    public void writeIdMappings(DhDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(-1);
        this.mapping.serialize(outputStream);
    }

    @Override
    public FullDataPointIdMap readIdMappings(long[][] dataPoints, DhDataInputStream inputStream, ILevelWrapper levelWrapper) throws IOException, InterruptedException {
        int guardByte = inputStream.readInt();
        if (guardByte != -1) {
            throw new IOException("Invalid data content end guard for ID mapping");
        }
        return FullDataPointIdMap.deserialize(inputStream, this.sectionPos, levelWrapper);
    }

    @Override
    public void setIdMapping(FullDataPointIdMap mappings) {
        this.mapping.mergeAndReturnRemappedEntityIds(mappings);
    }

    @Override
    public SingleColumnFullDataAccessor tryGet(int relativeX, int relativeZ) {
        return this.get(relativeX, relativeZ);
    }

    @Override
    public SingleColumnFullDataAccessor getOrCreate(int relativeX, int relativeZ) {
        return this.get(relativeX, relativeZ);
    }

    @Override
    public void update(ChunkSizedFullDataAccessor chunkDataView) {
        LodUtil.assertTrue(this.sectionPos.overlapsExactly(chunkDataView.getSectionPos()));
        if (this.getDataDetailLevel() == 0) {
            DhBlockPos2D chunkBlockPos = new DhBlockPos2D(chunkDataView.chunkPos.x * 16, chunkDataView.chunkPos.z * 16);
            DhBlockPos2D blockOffset = chunkBlockPos.subtract(this.sectionPos.getMinCornerLodPos().getCornerBlockPos());
            LodUtil.assertTrue(blockOffset.x >= 0 && blockOffset.x < WIDTH && blockOffset.z >= 0 && blockOffset.z < WIDTH);
            this.isEmpty = false;
            chunkDataView.shadowCopyTo(this.subView(16, blockOffset.x, blockOffset.z));
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    SingleColumnFullDataAccessor column = this.get(x + blockOffset.x, z + blockOffset.z);
                    LodUtil.assertTrue(column.doesColumnExist());
                }
            }
        } else if (this.getDataDetailLevel() < 4) {
            int dataPerFull = 1 << this.getDataDetailLevel();
            int fullSize = 16 / dataPerFull;
            DhLodPos dataOffset = chunkDataView.getSectionPos().getMinCornerLodPos(this.getDataDetailLevel());
            DhLodPos baseOffset = this.sectionPos.getMinCornerLodPos(this.getDataDetailLevel());
            int offsetX = dataOffset.x - baseOffset.x;
            int offsetZ = dataOffset.z - baseOffset.z;
            LodUtil.assertTrue(offsetX >= 0 && offsetX < WIDTH && offsetZ >= 0 && offsetZ < WIDTH);
            this.isEmpty = false;
            for (int xOffset = 0; xOffset < fullSize; ++xOffset) {
                for (int zOffset = 0; zOffset < fullSize; ++zOffset) {
                    SingleColumnFullDataAccessor column = this.get(xOffset + offsetX, zOffset + offsetZ);
                    column.downsampleFrom(chunkDataView.subView(dataPerFull, xOffset * dataPerFull, zOffset * dataPerFull));
                }
            }
        } else if (this.getDataDetailLevel() >= 4) {
            int chunkPerFull = 1 << this.getDataDetailLevel() - 4;
            if (chunkDataView.chunkPos.x % chunkPerFull != 0 || chunkDataView.chunkPos.z % chunkPerFull != 0) {
                return;
            }
            DhLodPos baseOffset = this.sectionPos.getMinCornerLodPos(this.getDataDetailLevel());
            DhSectionPos dataOffset = chunkDataView.getSectionPos().convertNewToDetailLevel(this.getDataDetailLevel());
            int offsetX = dataOffset.getX() - baseOffset.x;
            int offsetZ = dataOffset.getZ() - baseOffset.z;
            LodUtil.assertTrue(offsetX >= 0 && offsetX < WIDTH && offsetZ >= 0 && offsetZ < WIDTH);
            this.isEmpty = false;
            chunkDataView.get(0, 0).deepCopyTo(this.get(offsetX, offsetZ));
        } else {
            LodUtil.assertNotReach();
        }
    }

    public static boolean firstDataPosCanAffectSecond(DhSectionPos posToWrite, DhSectionPos posToTest) {
        if (!posToWrite.overlapsExactly(posToTest)) {
            return false;
        }
        if (posToTest.getDetailLevel() > posToWrite.getDetailLevel()) {
            return false;
        }
        if (posToWrite.getDetailLevel() - posToTest.getDetailLevel() <= 6) {
            return true;
        }
        byte sectPerData = (byte)BitShiftUtil.powerOfTwo(posToWrite.getDetailLevel() - posToTest.getDetailLevel() - 6);
        LodUtil.assertTrue(sectPerData != 0);
        return posToTest.getX() % sectPerData == 0 && posToTest.getZ() % sectPerData == 0;
    }

    @Override
    public DhSectionPos getSectionPos() {
        return this.sectionPos;
    }

    @Override
    public void resizeDataStructuresForRepopulation(DhSectionPos pos) {
        this.sectionPos = pos;
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(this.sectionPos.getDetailLevel() - 6);
    }

    @Override
    public byte getBinaryDataFormatVersion() {
        return 3;
    }

    @Override
    public EDhApiWorldGenerationStep getWorldGenStep() {
        return this.worldGenStep;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void markNotEmpty() {
        this.isEmpty = false;
    }

    @Override
    public int getWidthInDataPoints() {
        return this.width;
    }

    public void updateFromLowerCompleteSource(CompleteFullDataSource subData) {
        LodUtil.assertTrue(this.sectionPos.overlapsExactly(subData.sectionPos));
        LodUtil.assertTrue(subData.sectionPos.getDetailLevel() < this.sectionPos.getDetailLevel());
        if (!CompleteFullDataSource.firstDataPosCanAffectSecond(this.sectionPos, subData.sectionPos)) {
            return;
        }
        DhSectionPos lowerSectPos = subData.sectionPos;
        byte detailDiff = (byte)(this.sectionPos.getDetailLevel() - subData.sectionPos.getDetailLevel());
        byte targetDataDetail = this.getDataDetailLevel();
        DhLodPos minDataPos = this.sectionPos.getMinCornerLodPos(targetDataDetail);
        if (detailDiff <= 6) {
            int count = 1 << detailDiff;
            int dataPerCount = WIDTH / count;
            DhLodPos subDataPos = lowerSectPos.getSectionBBoxPos().getCornerLodPos(targetDataDetail);
            int dataOffsetX = subDataPos.x - minDataPos.x;
            int dataOffsetZ = subDataPos.z - minDataPos.z;
            LodUtil.assertTrue(dataOffsetX >= 0 && dataOffsetX < WIDTH && dataOffsetZ >= 0 && dataOffsetZ < WIDTH);
            for (int xOffset = 0; xOffset < count; ++xOffset) {
                for (int zOffset = 0; zOffset < count; ++zOffset) {
                    SingleColumnFullDataAccessor column = this.get(xOffset + dataOffsetX, zOffset + dataOffsetZ);
                    column.downsampleFrom(subData.subView(dataPerCount, xOffset * dataPerCount, zOffset * dataPerCount));
                }
            }
        } else {
            DhLodPos subDataPos = lowerSectPos.getSectionBBoxPos().convertToDetailLevel(targetDataDetail);
            int dataOffsetX = subDataPos.x - minDataPos.x;
            int dataOffsetZ = subDataPos.z - minDataPos.z;
            LodUtil.assertTrue(dataOffsetX >= 0 && dataOffsetX < WIDTH && dataOffsetZ >= 0 && dataOffsetZ < WIDTH);
            subData.get(0, 0).deepCopyTo(this.get(dataOffsetX, dataOffsetZ));
        }
    }
}

