/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.accessor;

import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.IFullDataAccessor;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;

public class SingleColumnFullDataAccessor
implements IFullDataAccessor {
    private final long[][] dataArrays;
    private final int dataArrayIndex;
    private final FullDataPointIdMap mapping;

    public SingleColumnFullDataAccessor(FullDataPointIdMap mapping, long[][] dataArrays, int dataArrayIndex) {
        this.dataArrays = dataArrays;
        this.dataArrayIndex = dataArrayIndex;
        this.mapping = mapping;
        LodUtil.assertTrue(this.dataArrayIndex < this.dataArrays.length, "dataArrays.length [" + this.dataArrays.length + "] is less than the dataArrayIndex [" + this.dataArrayIndex + "].");
    }

    public boolean doesColumnExist() {
        long[] dataColumn = this.dataArrays[this.dataArrayIndex];
        return dataColumn != null && dataColumn.length != 0;
    }

    @Override
    public FullDataPointIdMap getMapping() {
        return this.mapping;
    }

    @Override
    public SingleColumnFullDataAccessor get(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("Only contains 1 column of full data!");
        }
        return this;
    }

    @Override
    public SingleColumnFullDataAccessor get(int relativeX, int relativeZ) {
        if (relativeX != 0 || relativeZ != 0) {
            throw new IllegalArgumentException("Only contains 1 column of full data!");
        }
        return this;
    }

    public long[] getRaw() {
        return this.dataArrays[this.dataArrayIndex];
    }

    public long getSingle(int yIndex) {
        return this.dataArrays[this.dataArrayIndex][yIndex];
    }

    public void setSingle(int yIndex, long fullDataPoint) {
        this.dataArrays[this.dataArrayIndex][yIndex] = fullDataPoint;
    }

    public void setNew(long[] newArray) {
        this.dataArrays[this.dataArrayIndex] = newArray;
    }

    public int getSingleLength() {
        return this.dataArrays[this.dataArrayIndex].length;
    }

    @Override
    public int width() {
        return 1;
    }

    @Override
    public IFullDataAccessor subView(int width, int xOffset, int zOffset) {
        if (width != 1 || xOffset != 1 || zOffset != 1) {
            throw new IllegalArgumentException("Getting invalid range of subView from SingleColumnFullDataAccessor!");
        }
        return this;
    }

    public void shadowCopyTo(SingleColumnFullDataAccessor target) {
        if (target.mapping.equals(this.mapping)) {
            target.dataArrays[target.dataArrayIndex] = this.dataArrays[this.dataArrayIndex];
        } else {
            int[] remappedEntryIds = target.mapping.mergeAndReturnRemappedEntityIds(this.mapping);
            long[] sourceData = this.dataArrays[this.dataArrayIndex];
            long[] newData = new long[sourceData.length];
            for (int i = 0; i < newData.length; ++i) {
                newData[i] = FullDataPointUtil.remap(remappedEntryIds, sourceData[i]);
            }
            target.dataArrays[target.dataArrayIndex] = newData;
        }
    }

    public void deepCopyTo(SingleColumnFullDataAccessor target) {
        if (target.mapping.equals(this.mapping)) {
            System.arraycopy(this.dataArrays[this.dataArrayIndex], 0, target.dataArrays[target.dataArrayIndex], 0, this.dataArrays[this.dataArrayIndex].length);
        } else {
            int[] remappedEntryIds = target.mapping.mergeAndReturnRemappedEntityIds(this.mapping);
            long[] sourceData = this.dataArrays[this.dataArrayIndex];
            if (sourceData != null) {
                long[] newData = new long[sourceData.length];
                for (int i = 0; i < newData.length; ++i) {
                    newData[i] = FullDataPointUtil.remap(remappedEntryIds, sourceData[i]);
                }
                target.dataArrays[target.dataArrayIndex] = newData;
            }
        }
    }

    public void downsampleFrom(IFullDataAccessor source) {
        SingleColumnFullDataAccessor firstColumn = source.get(0);
        firstColumn.deepCopyTo(this);
    }
}

