/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.gui;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.config.gui.AbstractScreen;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttribute;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL32;

public class OpenGLConfigScreen
extends AbstractScreen {
    ShaderProgram basicShader;
    GLVertexBuffer sameContextBuffer;
    GLVertexBuffer sharedContextBuffer;
    VertexAttribute va;
    private static final float[] vertices = new float[]{-0.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 0.4f, -0.4f, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.0f, 0.0f, -0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void init() {
        System.out.println("init");
        this.va = VertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexAttribute.VertexPointer.addVec2Pointer(false));
        this.va.setVertexAttribute(0, 1, VertexAttribute.VertexPointer.addVec4Pointer(false));
        this.va.completeAndCheck(24);
        this.basicShader = new ShaderProgram("shaders/test/vert.vert", "shaders/test/frag.frag", "fragColor", new String[]{"vPosition", "color"});
        this.createBuffer();
    }

    private static GLVertexBuffer createTextingBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(vertices.length * 4);
        buffer = buffer.order(ByteOrder.nativeOrder());
        buffer.asFloatBuffer().put(vertices);
        buffer.rewind();
        GLVertexBuffer vbo = new GLVertexBuffer(false);
        vbo.bind();
        vbo.uploadBuffer(buffer, 4, EGpuUploadMethod.DATA, vertices.length * 4);
        return vbo;
    }

    private void createBuffer() {
        GLProxy.getInstance().recordOpenGlCall(() -> {
            this.sharedContextBuffer = OpenGLConfigScreen.createTextingBuffer();
        });
        GLProxy.ensureAllGLJobCompleted();
        this.sameContextBuffer = OpenGLConfigScreen.createTextingBuffer();
    }

    @Override
    public void render(float delta) {
        System.out.println("Updated config screen with the delta of " + delta);
        GLState state = new GLState();
        GL32.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL32.glPolygonMode((int)1032, (int)6914);
        GL32.glDisable((int)2884);
        GL32.glDisable((int)2929);
        GL32.glDisable((int)2960);
        GL32.glDisable((int)3042);
        this.basicShader.bind();
        this.va.bind();
        if (System.currentTimeMillis() % 2000L < 1000L) {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoint(this.sameContextBuffer.getId());
        } else {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoint(this.sharedContextBuffer.getId());
        }
        GL32.glDrawArrays((int)6, (int)0, (int)4);
        GL32.glClear((int)256);
        state.restore();
    }

    @Override
    public void tick() {
        System.out.println("Ticked");
    }
}

