/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.gui;

import com.seibel.distanthorizons.core.jar.Platform;
import distanthorizons.libraries.lwjgl.system.jawt.JAWT;
import distanthorizons.libraries.lwjgl.system.jawt.JAWTFunctions;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFWNativeCocoa;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWNativeX11;
import org.lwjgl.system.JNI;
import org.lwjgl.system.macosx.ObjCRuntime;

public final class EmbeddedFrameUtil {
    private static final int JAVA_VERSION;
    private static final JAWT awt;

    private static String getEmbeddedFrameImpl() {
        switch (Platform.get()) {
            case LINUX: {
                return "sun.awt.X11.XEmbeddedFrame";
            }
            case WINDOWS: {
                return "sun.awt.windows.WEmbeddedFrame";
            }
            case MACOS: {
                return "sun.lwawt.macosx.CViewEmbeddedFrame";
            }
        }
        throw new IllegalStateException();
    }

    private static long getEmbeddedFrameHandle(long window) {
        switch (Platform.get()) {
            case LINUX: {
                return GLFWNativeX11.glfwGetX11Window((long)window);
            }
            case WINDOWS: {
                return GLFWNativeWin32.glfwGetWin32Window((long)window);
            }
            case MACOS: {
                long objc_msgSend = ObjCRuntime.getLibrary().getFunctionAddress((CharSequence)"objc_msgSend");
                return JNI.invokePPP((long)GLFWNativeCocoa.glfwGetCocoaWindow((long)window), (long)ObjCRuntime.sel_getUid((CharSequence)"contentView"), (long)objc_msgSend);
            }
        }
        throw new IllegalStateException();
    }

    public static Frame embeddedFrameCreate(long window) {
        if (JAVA_VERSION < 9) {
            try {
                Class<?> EmdeddedFrame = Class.forName(EmbeddedFrameUtil.getEmbeddedFrameImpl());
                Constructor<?> c = EmdeddedFrame.getConstructor(Long.TYPE);
                return (Frame)c.newInstance(EmbeddedFrameUtil.getEmbeddedFrameHandle(window));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return JAWTFunctions.nJAWT_CreateEmbeddedFrame(EmbeddedFrameUtil.getEmbeddedFrameHandle(window), awt.CreateEmbeddedFrame());
    }

    static void embeddedFrameSynthesizeWindowActivation(Frame embeddedFrame, boolean doActivate) {
        if (JAVA_VERSION < 9) {
            try {
                embeddedFrame.getClass().getMethod("synthesizeWindowActivation", Boolean.TYPE).invoke((Object)embeddedFrame, doActivate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JAWTFunctions.JAWT_SynthesizeWindowActivation(embeddedFrame, doActivate, awt.SynthesizeWindowActivation());
        }
    }

    public static void embeddedFrameSetBounds(Frame embeddedFrame, int x, int y, int width, int height) {
        if (JAVA_VERSION < 9) {
            try {
                Method setLocationPrivate = embeddedFrame.getClass().getSuperclass().getDeclaredMethod("setBoundsPrivate", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setLocationPrivate.setAccessible(true);
                setLocationPrivate.invoke((Object)embeddedFrame, x, y, width, height);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            JAWTFunctions.JAWT_SetBounds(embeddedFrame, x, y, width, height, awt.SetBounds());
        }
    }

    public static void hideFrame(@NotNull Frame embeddedFrame) {
        embeddedFrame.setVisible(false);
        EmbeddedFrameUtil.embeddedFrameSynthesizeWindowActivation(embeddedFrame, false);
    }

    public static void showFrame(@NotNull Frame embeddedFrame) {
        EmbeddedFrameUtil.embeddedFrameSynthesizeWindowActivation(embeddedFrame, true);
        embeddedFrame.setVisible(true);
    }

    public static void placeAtCenter(Frame embeddedFrame, int windowWidth, int windowHeight, int frameWidth, int frameHeight, float scale) {
        float scaleFactor = (100.0f - scale) / 100.0f;
        float newWidth = (float)frameWidth * scaleFactor;
        float newHeight = (float)frameHeight * scaleFactor;
        float newX = ((float)windowWidth - newWidth) / 2.0f;
        float newY = ((float)windowHeight - newHeight) / 2.0f;
        EmbeddedFrameUtil.embeddedFrameSetBounds(embeddedFrame, Math.round(newX), Math.round(newY), Math.round(newWidth), Math.round(newHeight));
    }

    static {
        Pattern p = Pattern.compile("^(?:1[.])?([1-9][0-9]*)[.-]");
        Matcher m = p.matcher(System.getProperty("java.version"));
        if (!m.find()) {
            throw new IllegalStateException("Failed to parse java.version");
        }
        JAVA_VERSION = Integer.parseInt(m.group(1));
        awt = JAWT.calloc();
        awt.version(JAVA_VERSION < 9 ? 65540 : 589824);
        if (!JAWTFunctions.JAWT_GetAWT(awt)) {
            throw new RuntimeException("GetAWT failed");
        }
    }
}

