/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.file;

import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.file.ConfigTypeConverters;
import com.seibel.distanthorizons.core.config.types.AbstractConfigType;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import distanthorizons.libraries.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFileHandling {
    public final ConfigBase configBase;
    public final Path configPath;
    private final Logger LOGGER;
    private final CommentedFileConfig nightConfig;

    public ConfigFileHandling(ConfigBase configBase) {
        this.LOGGER = LogManager.getLogger((String)(this.getClass().getSimpleName() + ", " + configBase.modID));
        this.configBase = configBase;
        this.configPath = SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).getInstallationDirectory().toPath().resolve("config").resolve(this.configBase.modName + ".toml");
        this.nightConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath.toFile()).build();
    }

    public void saveToFile() {
        this.saveToFile(this.nightConfig);
    }

    public void saveToFile(CommentedFileConfig nightConfig) {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            ConfigFileHandling.reCreateFile(this.configPath);
        }
        this.loadNightConfig(nightConfig);
        for (AbstractConfigType<?, ?> entry : this.configBase.entries) {
            if (!ConfigEntry.class.isAssignableFrom(entry.getClass())) continue;
            this.createComment((ConfigEntry)entry, nightConfig);
            this.saveEntry((ConfigEntry)entry, nightConfig);
        }
        try {
            nightConfig.save();
        }
        catch (Exception e) {
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath.toString() + "]", e);
        }
    }

    public void loadFromFile() {
        this.loadFromFile(this.nightConfig);
    }

    public void loadFromFile(CommentedFileConfig nightConfig) {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            ConfigFileHandling.reCreateFile(this.configPath);
            return;
        }
        this.loadNightConfig(nightConfig);
        for (AbstractConfigType<?, ?> entry : this.configBase.entries) {
            if (!ConfigEntry.class.isAssignableFrom(entry.getClass()) || !entry.getAppearance().showInFile) continue;
            this.createComment((ConfigEntry)entry, nightConfig);
            this.loadEntry((ConfigEntry)entry, nightConfig);
        }
        try {
            nightConfig.save();
        }
        catch (Exception e) {
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Failed to save config at [" + this.configPath.toString() + "]", e);
        }
    }

    public void saveEntry(ConfigEntry<?> entry) {
        this.saveEntry(entry, this.nightConfig);
        this.nightConfig.save();
    }

    public void saveEntry(ConfigEntry<?> entry, CommentedFileConfig workConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (entry.getTrueValue() == null) {
            throw new IllegalArgumentException("Entry [" + entry.getNameWCategory() + "] is null, this may be a problem with [" + this.configBase.modName + "]. Please contact the authors");
        }
        workConfig.set(entry.getNameWCategory(), ConfigTypeConverters.attemptToConvertToString(entry.getType(), entry.getTrueValue()));
    }

    public void loadEntry(ConfigEntry<?> entry) {
        this.loadEntry(entry, this.nightConfig);
    }

    public <T> void loadEntry(ConfigEntry<T> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile) {
            return;
        }
        if (!nightConfig.contains(entry.getNameWCategory())) {
            this.saveEntry(entry, nightConfig);
            return;
        }
        try {
            if (entry.getType().isEnum()) {
                entry.pureSet(nightConfig.getEnum(entry.getNameWCategory(), entry.getType()));
                return;
            }
            entry.pureSet(ConfigTypeConverters.attemptToConvertFromString(entry.getType(), nightConfig.get(entry.getNameWCategory())));
            if (entry.getTrueValue() == null) {
                this.LOGGER.warn("Entry [" + entry.getNameWCategory() + "] returned as null from the config. Using default value.");
                entry.pureSet(entry.getDefaultValue());
            }
        }
        catch (Exception e) {
            this.LOGGER.warn("Entry [" + entry.getNameWCategory() + "] had an invalid value when loading the config. Using default value.");
            entry.pureSet(entry.getDefaultValue());
        }
    }

    public void createComment(ConfigEntry<?> entry) {
        this.createComment(entry, this.nightConfig);
    }

    public void createComment(ConfigEntry<?> entry, CommentedFileConfig nightConfig) {
        if (!entry.getAppearance().showInFile || entry.getComment() == null) {
            return;
        }
        nightConfig.setComment(entry.getNameWCategory(), " " + entry.getComment().replaceAll("\n", "\n ") + "\n ");
    }

    public void loadNightConfig() {
        this.loadNightConfig(this.nightConfig);
    }

    public void loadNightConfig(CommentedFileConfig nightConfig) {
        try {
            try {
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    Files.createFile(this.configPath, new FileAttribute[0]);
                }
                nightConfig.load();
            }
            catch (Exception e) {
                this.LOGGER.warn("Loading file failed because of this expectation:\n" + e);
                ConfigFileHandling.reCreateFile(this.configPath);
                nightConfig.load();
            }
        }
        catch (Exception ex) {
            System.out.println("Creating file failed");
            this.LOGGER.error((Object)ex);
            SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class).crashMinecraft("Loading file and resetting config file failed at path [" + this.configPath + "]. Please check the file is ok and you have the permissions", ex);
        }
    }

    public static void reCreateFile(Path path) {
        try {
            Files.deleteIfExists(path);
            if (!path.getParent().toFile().exists()) {
                Files.createDirectory(path.getParent(), new FileAttribute[0]);
            }
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

