/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers.presets;

import com.seibel.distanthorizons.api.enums.config.quickOptions.EThreadPreset;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigEntryWithPresetOptions;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.AbstractPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.coreapi.interfaces.config.IConfigEntry;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadPresetConfigEventHandler
extends AbstractPresetConfigEventHandler<EThreadPreset> {
    public static final ThreadPresetConfigEventHandler INSTANCE = new ThreadPresetConfigEventHandler();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean LOW_THREAD_COUNT_CPU = Runtime.getRuntime().availableProcessors() <= 4;
    private final ConfigEntryWithPresetOptions<EThreadPreset, Integer> worldGenThreadCount = new ConfigEntryWithPresetOptions<EThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads, new HashMap<EThreadPreset, Integer>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getWorldGenDefaultThreadCount());
            this.put(EThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.25));
            this.put(EThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.5));
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Double> worldGenRunTime = new ConfigEntryWithPresetOptions<EThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForWorldGenerationThreads, new HashMap<EThreadPreset, Double>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, LOW_THREAD_COUNT_CPU ? 0.1 : 0.25);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getWorldGenDefaultRunTimeRatio());
            this.put(EThreadPreset.BALANCED, LOW_THREAD_COUNT_CPU ? 0.5 : 0.75);
            this.put(EThreadPreset.AGGRESSIVE, LOW_THREAD_COUNT_CPU ? 0.75 : 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Integer> bufferBuilderThreadCount = new ConfigEntryWithPresetOptions<EThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfBufferBuilderThreads, new HashMap<EThreadPreset, Integer>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getBufferBuilderDefaultThreadCount());
            this.put(EThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.4));
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Double> bufferBuilderRunTime = new ConfigEntryWithPresetOptions<EThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForBufferBuilderThreads, new HashMap<EThreadPreset, Double>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 0.25);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getBufferBuilderDefaultRunTimeRatio());
            this.put(EThreadPreset.BALANCED, LOW_THREAD_COUNT_CPU ? 0.75 : 1.0);
            this.put(EThreadPreset.AGGRESSIVE, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Integer> fileHandlerThreadCount = new ConfigEntryWithPresetOptions<EThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfFileHandlerThreads, new HashMap<EThreadPreset, Integer>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getFileHandlerDefaultThreadCount());
            this.put(EThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Double> fileHandlerRunTime = new ConfigEntryWithPresetOptions<EThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForFileHandlerThreads, new HashMap<EThreadPreset, Double>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 0.25);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getFileHandlerDefaultRunTimeRatio());
            this.put(EThreadPreset.BALANCED, 0.75);
            this.put(EThreadPreset.AGGRESSIVE, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Integer> dataTransformerThreadCount = new ConfigEntryWithPresetOptions<EThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfDataTransformerThreads, new HashMap<EThreadPreset, Integer>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getDataTransformerDefaultThreadCount());
            this.put(EThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Double> dataTransformerRunTime = new ConfigEntryWithPresetOptions<EThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForDataTransformerThreads, new HashMap<EThreadPreset, Double>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 0.25);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getDataTransformerDefaultRunTimeRatio());
            this.put(EThreadPreset.BALANCED, LOW_THREAD_COUNT_CPU ? 0.75 : 1.0);
            this.put(EThreadPreset.AGGRESSIVE, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Integer> chunkLodConverterThreadCount = new ConfigEntryWithPresetOptions<EThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfChunkLodConverterThreads, new HashMap<EThreadPreset, Integer>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getChunkLodConverterDefaultThreadCount());
            this.put(EThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.4));
        }
    });
    private final ConfigEntryWithPresetOptions<EThreadPreset, Double> chunkLodConverterRunTime = new ConfigEntryWithPresetOptions<EThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForChunkLodConverterThreads, new HashMap<EThreadPreset, Double>(){
        {
            this.put(EThreadPreset.MINIMAL_IMPACT, LOW_THREAD_COUNT_CPU ? 0.1 : 0.25);
            this.put(EThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getChunkLodConverterDefaultRunTimeRatio());
            this.put(EThreadPreset.BALANCED, LOW_THREAD_COUNT_CPU ? 0.75 : 1.0);
            this.put(EThreadPreset.AGGRESSIVE, 1.0);
        }
    });

    public static int getWorldGenDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.15);
    }

    public static double getWorldGenDefaultRunTimeRatio() {
        return LOW_THREAD_COUNT_CPU ? 0.5 : 0.75;
    }

    public static int getBufferBuilderDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getBufferBuilderDefaultRunTimeRatio() {
        return LOW_THREAD_COUNT_CPU ? 0.5 : 0.75;
    }

    public static int getFileHandlerDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getFileHandlerDefaultRunTimeRatio() {
        return 0.5;
    }

    public static int getDataTransformerDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getDataTransformerDefaultRunTimeRatio() {
        return LOW_THREAD_COUNT_CPU ? 0.5 : 1.0;
    }

    public static int getChunkLodConverterDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getChunkLodConverterDefaultRunTimeRatio() {
        return LOW_THREAD_COUNT_CPU ? 0.5 : 0.75;
    }

    private ThreadPresetConfigEventHandler() {
        this.configList.add(this.worldGenThreadCount);
        this.configList.add(this.worldGenRunTime);
        this.configList.add(this.bufferBuilderThreadCount);
        this.configList.add(this.bufferBuilderRunTime);
        this.configList.add(this.fileHandlerThreadCount);
        this.configList.add(this.fileHandlerRunTime);
        this.configList.add(this.dataTransformerThreadCount);
        this.configList.add(this.dataTransformerRunTime);
        this.configList.add(this.chunkLodConverterThreadCount);
        this.configList.add(this.chunkLodConverterRunTime);
        for (ConfigEntryWithPresetOptions config : this.configList) {
            new ConfigChangeListener<Object>(config.configEntry, val -> this.onConfigValueChanged());
        }
    }

    private static int getThreadCountByPercent(double percent) throws IllegalArgumentException {
        if (percent <= 0.0 || percent > 1.0) {
            throw new IllegalArgumentException("percent must be greater than 0 and less than or equal to 1.");
        }
        int totalProcessorCount = Runtime.getRuntime().availableProcessors();
        int coreCount = (int)Math.ceil((double)totalProcessorCount * percent);
        return MathUtil.clamp(1, coreCount, totalProcessorCount);
    }

    @Override
    protected IConfigEntry<EThreadPreset> getPresetConfigEntry() {
        return Config.Client.threadPresetSetting;
    }

    @Override
    protected List<EThreadPreset> getPresetEnumList() {
        return Arrays.asList(EThreadPreset.values());
    }

    @Override
    protected EThreadPreset getCustomPresetEnum() {
        return EThreadPreset.CUSTOM;
    }
}

