/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config;

import com.seibel.distanthorizons.api.enums.config.EBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.EBufferRebuildTimes;
import com.seibel.distanthorizons.api.enums.config.EGLErrorHandlingMode;
import com.seibel.distanthorizons.api.enums.config.EGenerationPriority;
import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.api.enums.config.EHorizontalQuality;
import com.seibel.distanthorizons.api.enums.config.ELodShading;
import com.seibel.distanthorizons.api.enums.config.ELoggerMode;
import com.seibel.distanthorizons.api.enums.config.EMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EOverdrawPrevention;
import com.seibel.distanthorizons.api.enums.config.EServerFolderNameMode;
import com.seibel.distanthorizons.api.enums.config.EUpdateBranch;
import com.seibel.distanthorizons.api.enums.config.EVerticalQuality;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EQualityPreset;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EThreadPreset;
import com.seibel.distanthorizons.api.enums.rendering.EDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EFogColorMode;
import com.seibel.distanthorizons.api.enums.rendering.EFogDistance;
import com.seibel.distanthorizons.api.enums.rendering.EFogDrawMode;
import com.seibel.distanthorizons.api.enums.rendering.EFogFalloff;
import com.seibel.distanthorizons.api.enums.rendering.EHeightFogMixMode;
import com.seibel.distanthorizons.api.enums.rendering.EHeightFogMode;
import com.seibel.distanthorizons.api.enums.rendering.ERendererMode;
import com.seibel.distanthorizons.api.enums.rendering.ETransparency;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.core.config.eventHandlers.QuickRenderToggleConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.RenderCacheConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.UnsafeValuesConfigListener;
import com.seibel.distanthorizons.core.config.eventHandlers.WorldCurvatureConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.RenderQualityPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.types.ConfigCategory;
import com.seibel.distanthorizons.core.config.types.ConfigEntry;
import com.seibel.distanthorizons.core.config.types.ConfigLinkedEntry;
import com.seibel.distanthorizons.core.config.types.ConfigUIButton;
import com.seibel.distanthorizons.core.config.types.ConfigUIComment;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryAppearance;
import com.seibel.distanthorizons.core.config.types.enums.EConfigEntryPerformance;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static ConfigCategory client = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Client.class)).build();
    private static boolean complicatedListenerSetupComplete = false;

    public static void completeDelayedSetup() {
        if (!complicatedListenerSetupComplete) {
            complicatedListenerSetupComplete = true;
            try {
                ThreadPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderQualityPresetConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                QuickRenderToggleConfigEventHandler.INSTANCE.setUiOnlyConfigValues();
                RenderCacheConfigEventHandler.getInstance();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception when setting up complicated config listeners. Error: [" + e.getMessage() + "].", (Throwable)e);
            }
        }
    }

    public static class Client {
        public static ConfigEntry<Boolean> quickEnableRendering = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true, Distant Horizons will render LODs beyond the vanilla render distance.").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        public static ConfigLinkedEntry quickLodChunkRenderDistance = new ConfigLinkedEntry(Advanced.Graphics.Quality.lodChunkRenderDistance);
        public static ConfigEntry<EQualityPreset> qualityPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EQualityPreset.MEDIUM)).comment("Changing this setting will modify a number of different settings that will change the \nvisual fidelity of the rendered LODs.\n\nHigher settings will improve the graphical quality while increasing GPU and memory use.\n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(RenderQualityPresetConfigEventHandler.INSTANCE).build();
        public static ConfigEntry<EThreadPreset> threadPresetSetting = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EThreadPreset.LOW_IMPACT)).comment("Changing this setting will modify a number of different settings that will change \nthe load that Distant Horizons is allowed to put on your CPU. \n\nHigher options will improve LOD generation and loading speed, \nbut will increase CPU load and may introduce stuttering.\n\nNote: on CPUs with 4 cores or less these settings will be less effective \n      and some settings will give similar results. \n").setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(ThreadPresetConfigEventHandler.INSTANCE).build();
        public static ConfigLinkedEntry quickEnableWorldGenerator = new ConfigLinkedEntry(Advanced.WorldGenerator.enableDistantGeneration);
        public static ConfigEntry<Boolean> optionsButton = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should Distant Horizon's config button appear in the options screen next to fov slider?").build();
        public static ConfigCategory advanced = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Advanced.class)).build();

        public static class Advanced {
            public static ConfigCategory graphics = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Graphics.class)).build();
            public static ConfigCategory worldGenerator = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(WorldGenerator.class)).build();
            public static ConfigCategory multiplayer = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Multiplayer.class)).build();
            public static ConfigCategory multiThreading = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(MultiThreading.class)).build();
            public static ConfigCategory buffers = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(GpuBuffers.class)).build();
            public static ConfigCategory autoUpdater = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AutoUpdater.class)).build();
            public static ConfigCategory logging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Logging.class)).build();
            public static ConfigCategory debugging = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Debugging.class)).build();

            public static class Graphics {
                public static ConfigCategory quality = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Quality.class)).build();
                public static ConfigCategory fog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Fog.class)).build();
                public static ConfigCategory ssao = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(Ssao.class)).build();
                public static ConfigCategory noiseTextureSettings = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(NoiseTextureSettings.class)).build();
                public static ConfigCategory advancedGraphics = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AdvancedGraphics.class)).build();

                public static class Quality {
                    public static ConfigEntry<EMaxHorizontalResolution> maxHorizontalResolution = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EMaxHorizontalResolution.BLOCK)).comment("What is the maximum detail LODs should be drawn at? \nHigher settings will increase memory and GPU usage. \n\n" + (Object)((Object)EMaxHorizontalResolution.CHUNK) + ": render 1 LOD for each Chunk. \n" + (Object)((Object)EMaxHorizontalResolution.HALF_CHUNK) + ": render 4 LODs for each Chunk. \n" + (Object)((Object)EMaxHorizontalResolution.FOUR_BLOCKS) + ": render 16 LODs for each Chunk. \n" + (Object)((Object)EMaxHorizontalResolution.TWO_BLOCKS) + ": render 64 LODs for each Chunk. \n" + (Object)((Object)EMaxHorizontalResolution.BLOCK) + ": render 256 LODs for each Chunk (width of one block). \n\nLowest Quality: " + (Object)((Object)EMaxHorizontalResolution.CHUNK) + "\nHighest Quality: " + (Object)((Object)EMaxHorizontalResolution.BLOCK)).setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Integer> lodChunkRenderDistance = new ConfigEntry.Builder<Integer>().setMinDefaultMax(32, 128, 4096).comment("The radius of the mod's render distance. (measured in chunks)").setPerformance(EConfigEntryPerformance.HIGH).build();
                    public static ConfigEntry<EVerticalQuality> verticalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EVerticalQuality.MEDIUM)).comment("This indicates how well LODs will represent \noverhangs, caves, floating islands, etc. \nHigher options will make the world more accurate, butwill increase memory and GPU usage. \n\nLowest Quality: " + (Object)((Object)EVerticalQuality.HEIGHT_MAP) + "\nHighest Quality: " + (Object)((Object)EVerticalQuality.EXTREME)).setPerformance(EConfigEntryPerformance.VERY_HIGH).build();
                    public static ConfigEntry<EHorizontalQuality> horizontalQuality = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EHorizontalQuality.MEDIUM)).comment("This indicates how quickly LODs decrease in quality the further away they are. \nHigher settings will render higher quality fake chunks farther away, \nbut will increase memory and GPU usage.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<ETransparency> transparency = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ETransparency.COMPLETE)).comment("How should LOD transparency be handled. \n\n" + (Object)((Object)ETransparency.COMPLETE) + ": LODs will render transparent. \n" + (Object)((Object)ETransparency.FAKE) + ": LODs will be opaque, but shaded to match the blocks underneath. \n" + (Object)((Object)ETransparency.DISABLED) + ": LODs will be opaque. \n").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<EBlocksToAvoid> blocksToIgnore = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EBlocksToAvoid.NON_COLLIDING)).comment("What blocks shouldn't be rendered as LODs? \n\n" + (Object)((Object)EBlocksToAvoid.NONE) + ": Represent all blocks in the LODs \n" + (Object)((Object)EBlocksToAvoid.NON_COLLIDING) + ": Only represent solid blocks in the LODs (tall grass, torches, etc. won't count for a LOD's height) \n").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> tintWithAvoidedBlocks = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should the blocks underneath avoided blocks gain the color of the avoided block? \n\nTrue: a red flower will tint the grass below it red. \nFalse: skipped blocks will not change color of surface below them. ").setPerformance(EConfigEntryPerformance.NONE).build();
                }

                public static class Fog {
                    public static ConfigEntry<EFogDrawMode> drawMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EFogDrawMode.FOG_ENABLED)).comment("When should fog be drawn? \n\n" + (Object)((Object)EFogDrawMode.USE_OPTIFINE_SETTING) + ": Use whatever Fog setting Optifine is using.\nIf Optifine isn't installed this defaults to " + (Object)((Object)EFogDrawMode.FOG_ENABLED) + ". \n" + (Object)((Object)EFogDrawMode.FOG_ENABLED) + ": Never draw fog on the LODs \n" + (Object)((Object)EFogDrawMode.FOG_DISABLED) + ": Always draw fast fog on the LODs \n\nDisabling fog will improve GPU performance.").setPerformance(EConfigEntryPerformance.VERY_LOW).build();
                    public static ConfigEntry<EFogDistance> distance = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EFogDistance.FAR)).comment("At what distance should Fog be drawn on the LODs?").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<EFogColorMode> colorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EFogColorMode.USE_WORLD_FOG_COLOR)).comment("What color should fog use? \n\n" + (Object)((Object)EFogColorMode.USE_WORLD_FOG_COLOR) + ": Use the world's fog color. \n" + (Object)((Object)EFogColorMode.USE_SKY_COLOR) + ": Use the sky's color.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> disableVanillaFog = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should Minecraft's fog be disabled? \n\nNote: Other mods may conflict with this setting.").build();
                    public static ConfigCategory advancedFog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(AdvancedFog.class)).build();

                    public static class AdvancedFog {
                        private static final Double FOG_RANGE_MIN = 0.0;
                        private static final Double FOG_RANGE_MAX = Math.sqrt(2.0);
                        public static ConfigEntry<Double> farFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 0.0, FOG_RANGE_MAX).comment("At what distance should the far fog start? \n\n0.0: Fog starts at the player's position. \n1.0: Fog starts at the closest edge of the vanilla render distance. \n1.414: Fog starts at the corner of the vanilla render distance.").build();
                        public static ConfigEntry<Double> farFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, FOG_RANGE_MAX).comment("Where should the far fog end? \n\n0.0: Fog ends at player's position.\n1.0: Fog ends at the closest edge of the vanilla render distance. \n1.414: Fog ends at the corner of the vanilla render distance.").build();
                        public static ConfigEntry<Double> farFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(-5.0, 0.0, FOG_RANGE_MAX).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<Double> farFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(FOG_RANGE_MIN, 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                        public static ConfigEntry<EFogFalloff> farFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the fog thickness should be calculated? \n\n" + (Object)((Object)EFogFalloff.LINEAR) + ": Linear based on distance (will ignore 'density')\n" + (Object)((Object)EFogFalloff.EXPONENTIAL) + ": 1/(e^(distance*density)) \n" + (Object)((Object)EFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((distance*density)^2)").build();
                        public static ConfigEntry<Double> farFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 2.5, 50.0).comment("Used in conjunction with the Fog Falloff.").build();
                        public static ConfigCategory heightFog = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(HeightFog.class)).build();

                        static /* synthetic */ Double access$000() {
                            return FOG_RANGE_MIN;
                        }

                        static /* synthetic */ Double access$100() {
                            return FOG_RANGE_MAX;
                        }

                        public static class HeightFog {
                            public static ConfigEntry<EHeightFogMixMode> heightFogMixMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EHeightFogMixMode.BASIC)).comment("How should height effect the fog thickness? \nNote: height fog is combined with the other fog settings. \n\n" + (Object)((Object)EHeightFogMixMode.BASIC) + ": No special height fog effect. Fog is calculated based on camera distance \n" + (Object)((Object)EHeightFogMixMode.IGNORE_HEIGHT) + ": Ignore height completely. Fog is only calculated with horizontal distance \n" + (Object)((Object)EHeightFogMixMode.ADDITION) + ": heightFog + farFog \n" + (Object)((Object)EHeightFogMixMode.MAX) + ": max(heightFog, farFog) \n" + (Object)((Object)EHeightFogMixMode.MULTIPLY) + ": heightFog * farFog \n" + (Object)((Object)EHeightFogMixMode.INVERSE_MULTIPLY) + ": 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EHeightFogMixMode.LIMITED_ADDITION) + ": farFog + max(farFog, heightFog) \n" + (Object)((Object)EHeightFogMixMode.MULTIPLY_ADDITION) + ": farFog + farFog * heightFog \n" + (Object)((Object)EHeightFogMixMode.INVERSE_MULTIPLY_ADDITION) + ": farFog + 1 - (1-heightFog) * (1-farFog) \n" + (Object)((Object)EHeightFogMixMode.AVERAGE) + ": farFog*0.5 + heightFog*0.5 \n\nNote: height fog settings are ignored if '" + (Object)((Object)EHeightFogMixMode.BASIC) + "' or '" + (Object)((Object)EHeightFogMixMode.IGNORE_HEIGHT) + "' are selected.").build();
                            public static ConfigEntry<EHeightFogMode> heightFogMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EHeightFogMode.ABOVE_AND_BELOW_CAMERA)).comment("Where should the height fog start? \n\n" + (Object)((Object)EHeightFogMode.ABOVE_CAMERA) + ": Height fog starts at the camera and goes towards the sky \n" + (Object)((Object)EHeightFogMode.BELOW_CAMERA) + ": Height fog starts at the camera and goes towards the void \n" + (Object)((Object)EHeightFogMode.ABOVE_AND_BELOW_CAMERA) + ": Height fog starts from the camera to goes towards both the sky and void \n" + (Object)((Object)EHeightFogMode.ABOVE_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the sky \n" + (Object)((Object)EHeightFogMode.BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards the void \n" + (Object)((Object)EHeightFogMode.ABOVE_AND_BELOW_SET_HEIGHT) + ": Height fog starts from a set height and goes towards both the sky and void").build();
                            public static ConfigEntry<Double> heightFogBaseHeight = new ConfigEntry.Builder<Double>().setMinDefaultMax(-4096.0, 70.0, 4096.0).comment("If the height fog is calculated around a set height, what is that height position?").build();
                            public static ConfigEntry<Double> heightFogStart = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 0.0, AdvancedFog.access$100()).comment("Should the start of the height fog be offset? \n\n0.0: Fog start with no offset.\n1.0: Fog start with offset of the entire world's height. (Includes depth)").build();
                            public static ConfigEntry<Double> heightFogEnd = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 1.0, AdvancedFog.access$100()).comment("Should the end of the height fog be offset? \n\n0.0: Fog end with no offset.\n1.0: Fog end with offset of the entire world's height. (Include depth)").build();
                            public static ConfigEntry<Double> heightFogMin = new ConfigEntry.Builder<Double>().setMinDefaultMax(-5.0, 0.0, AdvancedFog.access$100()).comment("What is the minimum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                            public static ConfigEntry<Double> heightFogMax = new ConfigEntry.Builder<Double>().setMinDefaultMax(AdvancedFog.access$000(), 1.0, 5.0).comment("What is the maximum fog thickness? \n\n0.0: No fog. \n1.0: Fully opaque fog.").build();
                            public static ConfigEntry<EFogFalloff> heightFogFalloff = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EFogFalloff.EXPONENTIAL_SQUARED)).comment("How should the height fog thickness should be calculated? \n\n" + (Object)((Object)EFogFalloff.LINEAR) + ": Linear based on height (will ignore 'density')\n" + (Object)((Object)EFogFalloff.EXPONENTIAL) + ": 1/(e^(height*density)) \n" + (Object)((Object)EFogFalloff.EXPONENTIAL_SQUARED) + ": 1/(e^((height*density)^2)").build();
                            public static ConfigEntry<Double> heightFogDensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, 2.5, 50.0).comment("What is the height fog's density?").build();
                        }
                    }
                }

                public static class Ssao {
                    public static ConfigEntry<Boolean> enabled = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Enable Screen Space Ambient Occlusion").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Integer> sampleCount = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)6)).comment("Determines how many points in space are sampled for the occlusion test. \nHigher numbers will improve quality and reduce banding, but will increase GPU load.").setPerformance(EConfigEntryPerformance.MEDIUM).build();
                    public static ConfigEntry<Double> radius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)4.0)).comment("Determines the radius Screen Space Ambient Occlusion is applied, measured in blocks.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> strength = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.2)).comment("Determines how dark the Screen Space Ambient Occlusion effect will be.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> bias = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.02)).comment("Increasing the value can reduce banding at the cost of reducing the strength of the effect.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> minLight = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)0.25)).comment("Determines how dark the occlusion shadows can be. \n0 = totally black at the corners \n1 = no shadow").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Integer> blurRadius = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)2)).comment("The radius, measured in pixels, that blurring is calculated for the SSAO. \nHigher numbers will reduce banding at the cost of GPU performance.").setPerformance(EConfigEntryPerformance.HIGH).build();
                }

                public static class NoiseTextureSettings {
                    public static ConfigEntry<Boolean> noiseEnabled = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("Should a noise texture be applied to LODs? \n\nThis is done to simulate textures and make the LODs appear more detailed. \n").build();
                    public static ConfigEntry<Integer> noiseSteps = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, 4, null).comment("How many steps of noise should be applied to LODs?").build();
                    public static ConfigEntry<Double> noiseIntensity = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 5.0, 100.0).comment("How intense should the noise should be?").build();
                    public static ConfigEntry<Integer> noiseDropoff = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 1024, null).comment("Defines how far should the noise texture render before it fades away. (in blocks) \nSet to 0 to disable noise from fading away").build();
                }

                public static class AdvancedGraphics {
                    public static ConfigEntry<EOverdrawPrevention> overdrawPrevention = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EOverdrawPrevention.MEDIUM)).comment("Determines how far Distant Horizon's near clip plane will render. \n\nHigher values will prevent LODs from rendering behind vanilla blocks at a higher distance,\nbut may cause holes to appear in the LODs. \nHoles are most likely at the left and right edges of the screen \nwhen flying through unloaded terrain. \n\nIncreasing the vanilla render distance increases the effectiveness of these options.").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Boolean> seamlessOverdraw = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Buggy experimental option that will attempt to match up \nDistant Horizons' and Minecraft's near/far clip planes, \nreducing overdraw. \n\nOnly functional on Fabric.\nWorks best with an overdraw prevention setting of " + (Object)((Object)EOverdrawPrevention.MEDIUM) + " or higher \n and cave culling is disabled. \n").setPerformance(EConfigEntryPerformance.NONE).build();
                    public static ConfigEntry<Double> brightnessMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How bright LOD colors are. \n\n0 = black \n1 = normal \n2 = near white").build();
                    public static ConfigEntry<Double> saturationMultiplier = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)1.0)).comment("How saturated LOD colors are. \n\n0 = black and white \n1 = normal \n2 = very saturated").build();
                    public static ConfigEntry<Boolean> enableCaveCulling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If enabled caves will be culled \n\nNOTE: This feature is under development and \n it is VERY experimental! Please don't report \n any issues related to this feature. \n\nAdditional Info: Currently this cull all faces \n with skylight value of 0 in dimensions that \n does not have a ceiling.").build();
                    public static ConfigEntry<Integer> caveCullingHeight = new ConfigEntry.Builder<Integer>().setMinDefaultMax(-4096, 40, 4096).comment("At what Y value should cave culling start?").build();
                    public static ConfigEntry<Integer> earthCurveRatio = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 5000).comment("This is the earth size ratio when applying the curvature shader effect. \nNote: Enabling this feature may cause rendering bugs. \n\n0 = flat/disabled \n1 = 1 to 1 (6,371,000 blocks) \n100 = 1 to 100 (63,710 blocks) \n10000 = 1 to 10000 (637.1 blocks) \n\nNote: Due to current limitations, the min value is 50 \nand the max value is 5000. Any values outside this range \nwill be set to 0 (disabled).").addListener(WorldCurvatureConfigEventHandler.INSTANCE).build();
                    public static ConfigEntry<Double> lodBias = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, null).comment("What the value should vanilla Minecraft's texture LodBias be? \nIf set to 0 the mod wont overwrite vanilla's default (which so happens to also be 0)").build();
                    public static ConfigEntry<ELodShading> lodShading = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELodShading.MINECRAFT)).comment("How should LODs be shaded? \n\n" + (Object)((Object)ELodShading.MINECRAFT) + ": Uses the same side shading as vanilla Minecraft blocks. \n" + (Object)((Object)ELodShading.OLD_LIGHTING) + ": Simulates Minecraft's block shading for LODs. \n              Can be used to force LOD shading when using some shaders. \n" + (Object)((Object)ELodShading.NONE) + ": All LOD sides will be rendered with the same brightness. \n").setPerformance(EConfigEntryPerformance.NONE).build();
                }
            }

            public static class WorldGenerator {
                public static ConfigEntry<Boolean> enableDistantGeneration = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment(" Should Distant Horizons slowly generate LODs \n outside the vanilla render distance?\n\n Note: when on a server, distant generation isn't supported \n and will always be disabled.").build();
                public static ConfigEntry<EDhApiDistantGeneratorMode> distantGeneratorMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDhApiDistantGeneratorMode.FEATURES)).comment("How detailed should LODs be generated outside the vanilla render distance? \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + " \nOnly create LOD data for already generated chunks. \n\n\n" + (Object)((Object)EDhApiDistantGeneratorMode.SURFACE) + " \nGenerate the world surface, \nthis does NOT include trees, \nor structures. \n\n" + (Object)((Object)EDhApiDistantGeneratorMode.FEATURES) + " \nGenerate everything except structures. \nWARNING: This may cause world generator bugs or instability when paired with certain world generator mods. \n").build();
                public static ConfigEntry<Integer> worldGenerationTimeoutLengthInSeconds = new ConfigEntry.Builder<Integer>().setMinDefaultMax(5, 60, 600).comment("How long should a world generator thread run for before timing out? \nNote: If you are experiencing timeout errors it is better to lower your CPU usage first \nvia the thread config before changing this value. \n").build();
                @Deprecated
                private static ConfigEntry<EGenerationPriority> generationPriority = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EGenerationPriority.NEAR_FIRST)).comment("In what priority should fake chunks be generated outside the vanilla render distance? \n\n" + (Object)((Object)EGenerationPriority.FAR_FIRST) + " \nFake chunks are generated from lowest to highest detail \n with a priority for far away regions. \nThis fills in the world fastest, but you will have large low detail \n blocks for a while while the generation happens. \n\n" + (Object)((Object)EGenerationPriority.NEAR_FIRST) + " \nFake chunks are generated around the player \n in a spiral, similar to vanilla minecraft. \nBest used when on a server since we can't generate \n fake chunks. \n\n" + (Object)((Object)EGenerationPriority.BALANCED) + " \nA mix between " + (Object)((Object)EGenerationPriority.NEAR_FIRST) + "and" + (Object)((Object)EGenerationPriority.FAR_FIRST) + ". \nFirst prioritise completing nearby highest detail chunks, \n then focus on filling in the low detail areas away from the player. \n\n" + (Object)((Object)EGenerationPriority.AUTO) + " \nUses " + (Object)((Object)EGenerationPriority.BALANCED) + " when on a single player world \n and " + (Object)((Object)EGenerationPriority.NEAR_FIRST) + " when connected to a server.").setPerformance(EConfigEntryPerformance.NONE).build();
            }

            public static class Multiplayer {
                public static ConfigEntry<EServerFolderNameMode> serverFolderNameMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EServerFolderNameMode.NAME_ONLY)).comment("How should multiplayer save folders should be named? \n\n" + (Object)((Object)EServerFolderNameMode.NAME_ONLY) + ": Example: \"Minecraft Server\" \n" + (Object)((Object)EServerFolderNameMode.NAME_IP) + ": Example: \"Minecraft Server IP 192.168.1.40\" \n" + (Object)((Object)EServerFolderNameMode.NAME_IP_PORT) + ": Example: \"Minecraft Server IP 192.168.1.40:25565\"" + (Object)((Object)EServerFolderNameMode.NAME_IP_PORT_MC_VERSION) + ": Example: \"Minecraft Server IP 192.168.1.40:25565 GameVersion 1.16.5\"").build();
                public static ConfigEntry<Double> multiverseSimilarityRequiredPercent = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.0, 0.0, 1.0).comment("AKA: Multiverse support. \n\nWhen matching levels (dimensions) of the same type (overworld, nether, etc.) the \nloaded chunks must be at least this percent the same \nin order to be considered the same world. \n\nNote: If you use portals to enter a dimension at two \ndifferent locations the system will think the dimension \nit is two different levels. \n\n1.0 (100%) the chunks must be identical. \n0.5 (50%)  the chunks must be half the same. \n0.0 (0%)   disables multi-dimension support, \n            only one world will be used per dimension. \n\nIf multiverse support is needed start with a value of 0.2 \nand tweak the sensitivity from there.Lower values mean the matching is less strict.\nHigher values mean the matching is more strict.\n").build();
                private static ConfigEntry<Boolean> enableMultiverseNetworking = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true Distant Horizons will attempt to communicate with the connected \nserver in order to improve multiverse support. \n").build();
                private static ConfigEntry<Boolean> enableServerNetworking = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Attention: this is only for developers and hasn't been implemented.\n\nIf true Distant Horizons will attempt to communicate with the connected \nserver in order to load LODs outside your vanilla render distance. \n\nNote: This requires DH to be installed on the server in order to function. \n").build();
            }

            public static class MultiThreading {
                public static final String THREAD_NOTE = "Multi-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.";
                public static final String THREAD_RUN_TIME_RATIO_NOTE = "If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.";
                public static final ConfigEntry<Integer> numberOfWorldGenerationThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getWorldGenDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when generating LOD \nchunks outside the normal render distance? \n\nIf you experience stuttering when generating distant LODs, \ndecrease this number. \nIf you want to increase LOD \ngeneration speed, increase this number. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForWorldGenerationThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getWorldGenDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
                public static ConfigEntry<Integer> numberOfBufferBuilderThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getBufferBuilderDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads are used when building geometry data for the GPU? \n\nIf you experience high CPU usage when NOT generating distant \nLODs, lower this number. A higher number will make \nLODs' transition faster when moving around the world. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForBufferBuilderThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getBufferBuilderDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
                public static final ConfigEntry<Integer> numberOfFileHandlerThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getFileHandlerDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when reading in LOD data from disk? \n\nIncreasing this number will cause LODs to load in faster, \nbut may cause lag when loading a new world or when \nquickly flying through existing LODs. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForFileHandlerThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getFileHandlerDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
                public static final ConfigEntry<Integer> numberOfDataTransformerThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getDataTransformerDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used when converting full ID data to render data? \n\nThese threads run both when terrain is generated and when\ncertain graphics settings are changed. \n\nGenerally this number should be equal to the number of world\ngenerator threads, although these threads shouldn't run as\noften (or as long) as the world generator threads.\n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForDataTransformerThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getDataTransformerDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
                public static final ConfigEntry<Integer> numberOfChunkLodConverterThreads = new ConfigEntry.Builder<Integer>().setMinDefaultMax(1, ThreadPresetConfigEventHandler.getChunkLodConverterDefaultThreadCount(), Runtime.getRuntime().availableProcessors()).comment("How many threads should be used to convert Minecraft chunks into LOD data? \n\nThese threads run both when terrain is generated and when\nchunks are loaded, unloaded, and modified. \n\nMulti-threading Note: \nIf the total thread count in Distant Horizon's config is more threads than your CPU has cores, \nCPU performance may suffer if Distant Horizons has a lot to load or generate. \nThis can be an issue when first loading into a world, when flying, and/or when generating new terrain.").build();
                public static final ConfigEntry<Double> runTimeRatioForChunkLodConverterThreads = new ConfigEntry.Builder<Double>().setMinDefaultMax(0.01, ThreadPresetConfigEventHandler.getChunkLodConverterDefaultRunTimeRatio(), 1.0).comment("If this value is less than 1.0, it will be treated as a percentage \nof time each thread can run before going idle. \n\nThis can be used to reduce CPU usage if the thread count \nis already set to 1 for the given option, or more finely \ntune CPU performance.").build();
            }

            public static class GpuBuffers {
                public static ConfigEntry<EGpuUploadMethod> gpuUploadMethod = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EGpuUploadMethod.AUTO)).comment("What method should be used to upload geometry to the GPU? \n\n" + (Object)((Object)EGpuUploadMethod.AUTO) + ": Picks the best option based on the GPU you have. \n\n" + (Object)((Object)EGpuUploadMethod.BUFFER_STORAGE) + ": Default if OpenGL 4.5 is supported. \n    Fast rendering, no stuttering. \n\n" + (Object)((Object)EGpuUploadMethod.SUB_DATA) + ": Backup option for NVIDIA. \n    Fast rendering but may stutter when uploading. \n\n" + (Object)((Object)EGpuUploadMethod.BUFFER_MAPPING) + ": Slow rendering but won't stutter when uploading. \n    Generally the best option for integrated GPUs. \n    Default option for AMD/Intel if OpenGL 4.5 isn't supported. \n    May end up storing buffers in System memory. \n    Fast rendering if in GPU memory, slow if in system memory, \n    but won't stutter when uploading.  \n\n" + (Object)((Object)EGpuUploadMethod.DATA) + ": Fast rendering but will stutter when uploading. \n    Backup option for AMD/Intel. \n    Fast rendering but may stutter when uploading. \n\nIf you don't see any difference when changing these settings, \nor the world looks corrupted: restart your game.").build();
                public static ConfigEntry<Integer> gpuUploadPerMegabyteInMilliseconds = new ConfigEntry.Builder<Integer>().setMinDefaultMax(0, 0, 50).comment("How long should a buffer wait per Megabyte of data uploaded? \nHelpful resource for frame times: https://fpstoms.com \n\nLonger times may reduce stuttering but will make LODs \ntransition and load slower. Change this to [0] for no timeout. \n\nNOTE:\nBefore changing this config, try changing the \"GPU Upload method\" first. \n").build();
                public static ConfigEntry<Boolean> gpuUploadAsync = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)true)).comment("If true geometry data will be uploaded on a DH controlled thread, reducing FPS stuttering. \nIf false uploading will be done on Minecraft's main rendering thread. \n\nSetting this to false may reduce crashes or corrupted geometry on systems with an AMD GPU when Sodium is installed.\n").build();
                @Deprecated
                private static ConfigEntry<EBufferRebuildTimes> rebuildTimes = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EBufferRebuildTimes.NORMAL)).comment("How frequently should vertex buffers (geometry) be rebuilt and sent to the GPU? \nHigher settings may cause stuttering, but will prevent holes in the world").build();
            }

            public static class AutoUpdater {
                public static ConfigEntry<Boolean> enableAutoUpdater = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(!SingletonInjector.INSTANCE.get(IMinecraftSharedWrapper.class).getInstallationDirectory().getName().equals("run") ? 1 : 0))).comment("Automatically check for updates on game launch?").build();
                public static ConfigEntry<Boolean> enableSilentUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Should Distant Horizons silently, automatically download and install new versions?").build();
                public static ConfigEntry<EUpdateBranch> updateBranch = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(ModInfo.IS_DEV_BUILD ? EUpdateBranch.NIGHTLY : EUpdateBranch.STABLE))).comment(" If DH should use the nightly (provided by Gitlab), or stable (provided by Modrinth) build").build();
            }

            public static class Logging {
                public static ConfigEntry<ELoggerMode> logWorldGenEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logWorldGenPerformance = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_FILE)).comment("If enabled, the mod will log performance about the world generation process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logWorldGenLoadEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_FILE)).comment("If enabled, the mod will log information about the world generation process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logLodBuilderEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the LOD generation process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logRendererBufferEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer buffer process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logRendererGLEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about the renderer OpenGL process. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logFileReadWriteEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about file read/write operations. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logFileSubDimEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about file sub-dimension operations. \nThis can be useful for debugging.").build();
                public static ConfigEntry<ELoggerMode> logNetworkEvent = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ELoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE)).comment("If enabled, the mod will log information about network operations. \nThis can be useful for debugging.").build();
            }

            public static class Debugging {
                public static ConfigEntry<ERendererMode> rendererMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ERendererMode.DEFAULT)).comment("What renderer is active? \n\n" + (Object)((Object)ERendererMode.DEFAULT) + ": Default lod renderer \n" + (Object)((Object)ERendererMode.DEBUG) + ": Debug testing renderer \n" + (Object)((Object)ERendererMode.DISABLED) + ": Disable rendering").build();
                public static ConfigEntry<EDebugRendering> debugRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)EDebugRendering.OFF)).comment("Should specialized colors/rendering modes be used? \n\n" + (Object)((Object)EDebugRendering.OFF) + ": Fake chunks will be drawn with their normal colors. \n" + (Object)((Object)EDebugRendering.SHOW_DETAIL) + ": Fake chunks color will be based on their detail level. \n" + (Object)((Object)EDebugRendering.SHOW_GENMODE) + ": Fake chunks color will be based on their distant generation mode. \n" + (Object)((Object)EDebugRendering.SHOW_OVERLAPPING_QUADS) + ": Fake chunks will be drawn with total white, but overlapping quads will be drawn with red. \n    but overlapping quads will be drawn with red, drawn as a wireframe.").build();
                public static ConfigEntry<Boolean> renderWireframe = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled the LODs will render as wireframe.").build();
                public static ConfigEntry<Boolean> enableDebugKeybindings = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If true the F8 key can be used to cycle through the different debug modes. \nand the F6 key can be used to enable and disable LOD rendering.").build();
                public static ConfigEntry<Boolean> lodOnlyMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled this will disable (most) vanilla Minecraft rendering. \n\nNOTE: Do not report any issues when this mode is on! \n   This setting is only for fun and debugging. \n   Mod compatibility is not guaranteed.").build();
                public static ConfigEntry<Boolean> enableWhiteWorld = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Stops vertex colors from being passed. \nUseful for debugging shaders").build();
                public static ConfigEntry<Boolean> allowUnsafeValues = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).addListener(UnsafeValuesConfigListener.INSTANCE).build();
                public static ConfigEntry<Boolean> overrideVanillaGLLogger = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)ModInfo.IS_DEV_BUILD)).comment("Requires a reboot to change. \n").build();
                public static ConfigEntry<EGLErrorHandlingMode> glErrorHandlingMode = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)(ModInfo.IS_DEV_BUILD ? EGLErrorHandlingMode.LOG : EGLErrorHandlingMode.IGNORE))).comment("Defines how OpenGL errors are handled. \nMay incorrectly catch OpenGL errors thrown by other mods. \n\n" + (Object)((Object)EGLErrorHandlingMode.IGNORE) + ": Do nothing. \n" + (Object)((Object)EGLErrorHandlingMode.LOG) + ": write an error to the log. \n" + (Object)((Object)EGLErrorHandlingMode.LOG_THROW) + ": write to the log and throw an exception. \n           Warning: this should only be enabled when debugging the LOD renderer \n           as it may break Minecraft's renderer when an exception is thrown. \n").build();
                public static ConfigEntry<Boolean> skipChunkLoadUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("").build();
                public static ConfigEntry<Boolean> skipChunkUnloadUpdates = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("").build();
                public static ConfigEntry<Boolean> skipFullDataUpdateQueue = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("").build();
                public static ConfigCategory debugWireframe = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(DebugWireframe.class)).build();
                public static ConfigCategory exampleConfigScreen = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(ExampleConfigScreen.class)).build();

                public static class DebugWireframe {
                    public static ConfigEntry<Boolean> enableRendering = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("If enabled, various wireframes for debugging internal functions will be drawn. \n\nNOTE: There WILL be performance hit! \n   Additionally, only stuff that's loaded after you enable this \n   will render their debug wireframes.").build();
                    public static ConfigEntry<Boolean> showWorldGenQueue = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render queued world gen tasks?").build();
                    public static ConfigEntry<Boolean> showRenderSectionStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render LOD section status?").build();
                    public static ConfigEntry<Boolean> showFullDataFileStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render full data file status?").build();
                    public static ConfigEntry<Boolean> showFullDataFileSampling = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render full data file sampling progress?").build();
                    public static ConfigEntry<Boolean> showRenderDataFileStatus = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).comment("Render render data file status?").build();
                }

                public static class ExampleConfigScreen {
                    public static ConfigUIComment debugConfigScreenNote = new ConfigUIComment();
                    public static ConfigEntry<Boolean> boolTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).build();
                    public static ConfigEntry<Byte> byteTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)8)).build();
                    public static ConfigEntry<Integer> intTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69420)).build();
                    public static ConfigEntry<Double> doubleTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420.69)).build();
                    public static ConfigEntry<Short> shortTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)69)).build();
                    public static ConfigEntry<Long> longTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)42069L)).build();
                    public static ConfigEntry<Float> floatTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(Float.valueOf(0.42069f))).build();
                    public static ConfigEntry<String> stringTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set("Test input box")).build();
                    public static ConfigEntry<List<String>> listTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new ArrayList<String>(Arrays.asList("option 1", "option 2", "option 3")))).build();
                    public static ConfigEntry<Map<String, String>> mapTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set(new HashMap())).build();
                    public static ConfigUIButton uiButtonTest = new ConfigUIButton(() -> new Thread(() -> {
                        System.setProperty("java.awt.headless", "false");
                        JOptionPane.showMessageDialog(null, "Button pressed!", "UITester dialog", 1);
                    }));
                    public static ConfigCategory categoryTest = ((ConfigCategory.Builder)new ConfigCategory.Builder().set(CategoryTest.class)).build();
                    public static ConfigEntry<Integer> linkableTest = ((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)420)).build();

                    public static class CategoryTest {
                        public static ConfigLinkedEntry linkableTest = new ConfigLinkedEntry(linkableTest);
                    }
                }
            }
        }

        public static class ResetConfirmation {
            public static ConfigUIComment resetConfirmationNote = new ConfigUIComment();
            public static ConfigEntry<Boolean> resetAllSettings = ((ConfigEntry.Builder)((ConfigEntry.Builder)new ConfigEntry.Builder().set((Object)false)).setAppearance(EConfigEntryAppearance.ONLY_IN_GUI)).build();
        }
    }
}

