/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBufferBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.ChunkToLodBuilder;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataFileHandler;
import com.seibel.distanthorizons.core.generation.WorldGenerationQueue;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;

public class SharedApi {
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        currentWorld = newWorld;
        if (currentWorld != null) {
            FullDataToRenderDataTransformer.setupExecutorService();
            FullDataFileHandler.setupExecutorService();
            ColumnRenderBufferBuilder.setupExecutorService();
            WorldGenerationQueue.setupWorldGenThreadPool();
            ChunkToLodBuilder.setupExecutorService();
        } else {
            FullDataToRenderDataTransformer.shutdownExecutorService();
            FullDataFileHandler.shutdownExecutorService();
            ColumnRenderBufferBuilder.shutdownExecutorService();
            WorldGenerationQueue.shutdownWorldGenThreadPool();
            ChunkToLodBuilder.shutdownExecutorService();
            DebugRenderer.clearRenderables();
            System.gc();
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld != null && DhClientServerWorld.class.isInstance(currentWorld) ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld != null && IDhClientWorld.class.isInstance(currentWorld) ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld != null && IDhServerWorld.class.isInstance(currentWorld) ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    static {
        lastWorldGenTickDelta = 0;
    }
}

