/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelUnloadEvent;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.DhServerWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.Logger;

public class ServerApi {
    public static final ServerApi INSTANCE = new ServerApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadPoolExecutor LIGHT_POPULATOR_THREAD_POOL = ThreadUtil.makeRateLimitedThreadPool(Runtime.getRuntime().availableProcessors() <= 12 ? 1 : 2, "Server Light Populator", 0.5, ThreadUtil.MINIMUM_RELATIVE_PRIORITY);
    private int lastWorldGenTickDelta = 0;

    private ServerApi() {
    }

    public void serverTickEvent() {
        try {
            IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
            if (serverWorld != null) {
                serverWorld.serverTick();
                SharedApi.worldGenTick(serverWorld::doWorldGen);
            }
        }
        catch (Exception e) {
            LOGGER.error("ServerTickEvent error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void serverLevelTickEvent(IServerLevelWrapper level) {
    }

    public void serverLoadEvent(boolean isDedicatedEnvironment) {
        LOGGER.debug("Server World loading with (dedicated?:" + isDedicatedEnvironment + ")");
        SharedApi.setDhWorld(isDedicatedEnvironment ? new DhServerWorld() : new DhClientServerWorld());
    }

    public void serverUnloadEvent() {
        LOGGER.debug("Server World " + SharedApi.getAbstractDhWorld() + " unloading");
        SharedApi.getAbstractDhWorld().close();
        SharedApi.setDhWorld(null);
    }

    public void serverLevelLoadEvent(IServerLevelWrapper level) {
        LOGGER.debug("Server Level " + level + " loading");
        AbstractDhWorld serverWorld = SharedApi.getAbstractDhWorld();
        if (serverWorld != null) {
            serverWorld.getOrLoadLevel(level);
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelLoadEvent.class, new DhApiLevelLoadEvent.EventParam(level));
        }
    }

    public void serverLevelUnloadEvent(IServerLevelWrapper level) {
        LOGGER.debug("Server Level " + level + " unloading");
        AbstractDhWorld serverWorld = SharedApi.getAbstractDhWorld();
        if (serverWorld != null) {
            serverWorld.unloadLevel(level);
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelUnloadEvent.class, new DhApiLevelUnloadEvent.EventParam(level));
        }
    }

    @Deprecated
    public void serverSaveEvent() {
        LOGGER.debug("Server world " + SharedApi.getAbstractDhWorld() + " saving");
        AbstractDhWorld serverWorld = SharedApi.getAbstractDhWorld();
        if (serverWorld != null) {
            serverWorld.saveAndFlush();
        }
    }

    public void serverChunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        IDhLevel dhLevel;
        if (Config.Client.Advanced.Debugging.skipChunkLoadUpdates.get().booleanValue()) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld != null && (dhLevel = dhWorld.getLevel(level)) != null) {
            dhLevel.updateChunkAsync(chunk);
        }
    }

    public void serverChunkSaveEvent(IChunkWrapper chunkWrapper, ILevelWrapper level) {
        if (Config.Client.Advanced.Debugging.skipChunkUnloadUpdates.get().booleanValue()) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            return;
        }
        IDhLevel dhLevel = SharedApi.getAbstractDhWorld().getLevel(level);
        if (dhLevel == null) {
            return;
        }
        LIGHT_POPULATOR_THREAD_POOL.execute(() -> {
            if (chunkWrapper.isLightCorrect()) {
                try {
                    chunkWrapper.bakeDhLightingUsingMcLightingEngine();
                }
                catch (IllegalStateException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            } else {
                ArrayList<IChunkWrapper> nearbyChunkList = new ArrayList<IChunkWrapper>(1);
                nearbyChunkList.add(chunkWrapper);
                DhLightingEngine.INSTANCE.lightChunk(chunkWrapper, nearbyChunkList, level.hasSkyLight() ? 15 : 0);
            }
            dhLevel.updateChunkAsync(chunkWrapper);
        });
    }

    public void serverPlayerJoinEvent(IServerPlayerWrapper player) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            LOGGER.debug("Waiting for player to connect: " + player.getUUID());
            ((DhServerWorld)serverWorld).addPlayer(player);
        }
    }

    public void serverPlayerDisconnectEvent(IServerPlayerWrapper player) {
        IDhServerWorld serverWorld = SharedApi.getIDhServerWorld();
        if (serverWorld instanceof DhServerWorld) {
            LOGGER.debug("Removing player from connect wait list: " + player.getUUID());
            ((DhServerWorld)serverWorld).removePlayer(player);
        }
    }
}

