/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TooltipsUtils {
    public static List<Component> formatActiveSpellTooltip(ItemStack stack, CastSource castSource, @Nonnull LocalPlayer player) {
        SpellData spellData = stack.m_41720_() instanceof SpellBook ? SpellBookData.getSpellBookData(stack).getActiveSpell() : SpellData.getSpellData(stack);
        AbstractSpell spell = spellData.getSpell();
        MutableComponent levelText = TooltipsUtils.getLevelComponenet(spellData, (LivingEntity)player);
        MutableComponent title = Component.m_237110_((String)"tooltip.irons_spellbooks.selected_spell", (Object[])new Object[]{spell.getDisplayName(), levelText}).m_130948_(spell.getSchoolType().getDisplayName().m_7383_());
        List<MutableComponent> uniqueInfo = spell.getUniqueInfo(spellData.getLevel(), (LivingEntity)player);
        MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost(spellData.getLevel(), (LivingEntity)player)).m_130940_(ChatFormatting.BLUE);
        MutableComponent cooldownTime = Component.m_237110_((String)"tooltip.irons_spellbooks.cooldown_length_seconds", (Object[])new Object[]{Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spell, (Player)player, castSource), 1)}).m_130940_(ChatFormatting.BLUE);
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237119_());
        lines.add((Component)title);
        uniqueInfo.forEach(line -> lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)line.m_130940_(ChatFormatting.DARK_GREEN))));
        if (spell.getCastType() != CastType.INSTANT) {
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime(spellData.getLevel(), (LivingEntity)player), 1)).m_130940_(ChatFormatting.BLUE)));
        }
        if (castSource != CastSource.SWORD || ((Boolean)ServerConfigs.SWORDS_CONSUME_MANA.get()).booleanValue()) {
            lines.add((Component)manaCost);
        }
        if (castSource != CastSource.SWORD || ((Double)ServerConfigs.SWORDS_CD_MULTIPLIER.get()).floatValue() > 0.0f) {
            lines.add((Component)cooldownTime);
        }
        return lines;
    }

    public static List<Component> formatScrollTooltip(ItemStack stack, @Nonnull LocalPlayer player) {
        SpellData spellData = SpellData.getSpellData(stack);
        if (spellData.equals(SpellData.EMPTY)) {
            return List.of();
        }
        AbstractSpell spell = spellData.getSpell();
        MutableComponent levelText = TooltipsUtils.getLevelComponenet(spellData, (LivingEntity)player);
        MutableComponent title = Component.m_237110_((String)"tooltip.irons_spellbooks.level", (Object[])new Object[]{levelText}).m_130946_(" ").m_7220_((Component)Component.m_237110_((String)"tooltip.irons_spellbooks.rarity", (Object[])new Object[]{spell.getRarity(spellData.getLevel()).getDisplayName()}).m_130948_(spell.getRarity(spellData.getLevel()).getDisplayName().m_7383_())).m_130940_(ChatFormatting.GRAY);
        List<MutableComponent> uniqueInfo = spell.getUniqueInfo(spellData.getLevel(), (LivingEntity)player);
        MutableComponent whenInSpellBook = Component.m_237115_((String)"tooltip.irons_spellbooks.scroll_tooltip").m_130940_(ChatFormatting.GRAY);
        MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost(spellData.getLevel(), (LivingEntity)player)).m_130940_(ChatFormatting.BLUE);
        MutableComponent cooldownTime = Component.m_237110_((String)"tooltip.irons_spellbooks.cooldown_length_seconds", (Object[])new Object[]{Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spell, (Player)player, CastSource.SCROLL), 1)}).m_130940_(ChatFormatting.BLUE);
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)title));
        uniqueInfo.forEach(line -> lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)line.m_130940_(ChatFormatting.DARK_GREEN))));
        if (spell.getCastType() != CastType.INSTANT) {
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime(spellData.getLevel(), (LivingEntity)player), 1)).m_130940_(ChatFormatting.BLUE)));
        }
        lines.add((Component)Component.m_237119_());
        lines.add((Component)whenInSpellBook);
        lines.add((Component)manaCost);
        lines.add((Component)cooldownTime);
        lines.add((Component)spell.getSchoolType().getDisplayName().m_6881_());
        return lines;
    }

    public static MutableComponent getLevelComponenet(SpellData spellData, LivingEntity caster) {
        int levelTotal = spellData.getSpell().getLevel(spellData.getLevel(), caster);
        int diff = levelTotal - spellData.getLevel();
        if (diff > 0) {
            return Component.m_237110_((String)"tooltip.irons_spellbooks.level_plus", (Object[])new Object[]{levelTotal, diff});
        }
        return Component.m_237113_((String)String.valueOf(levelTotal));
    }

    public static MutableComponent getCastTimeComponent(CastType type, String castTime) {
        return switch (type) {
            case CastType.CONTINUOUS -> Component.m_237110_((String)"tooltip.irons_spellbooks.cast_continuous", (Object[])new Object[]{castTime});
            case CastType.LONG -> Component.m_237110_((String)"tooltip.irons_spellbooks.cast_long", (Object[])new Object[]{castTime});
            default -> Component.m_237115_((String)"ui.irons_spellbooks.cast_instant");
        };
    }

    public static MutableComponent getManaCostComponent(CastType castType, int manaCost) {
        if (castType == CastType.CONTINUOUS) {
            return Component.m_237110_((String)"tooltip.irons_spellbooks.mana_cost_per_second", (Object[])new Object[]{manaCost * 2});
        }
        return Component.m_237110_((String)"tooltip.irons_spellbooks.mana_cost", (Object[])new Object[]{manaCost});
    }

    public static List<FormattedCharSequence> createSpellDescriptionTooltip(AbstractSpell spell, Font font) {
        MutableComponent name = spell.getDisplayName();
        List description = font.m_92923_((FormattedText)Component.m_237115_((String)String.format("%s.guide", spell.getComponentId())).m_130940_(ChatFormatting.GRAY), 180);
        ArrayList<FormattedCharSequence> hoverText = new ArrayList<FormattedCharSequence>();
        hoverText.add(FormattedCharSequence.m_13714_((String)name.getString(), (Style)Style.f_131099_.m_131162_(Boolean.valueOf(true))));
        hoverText.addAll(description);
        return hoverText;
    }
}

