/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.void_school;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.void_tentacle.VoidTentacle;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class VoidTentaclesSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("irons_spellbooks", "void_tentacles");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(3).setCooldownSeconds(30.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation(this.getDamage(spellLevel, caster), 1)}), Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((float)this.getRings(spellLevel, caster) * 1.3f, 1)}));
    }

    public VoidTentaclesSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 150;
    }

    @Override
    public CastType getCastType() {
        return CastType.LONG;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.VOID_TENTACLES_START.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.VOID_TENTACLES_FINISH.get());
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Player player;
        int rings = this.getRings(spellLevel, entity);
        int count = 2;
        Vec3 center = Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, 48.0).m_82450_();
        level.m_6263_(entity instanceof Player ? (player = (Player)entity) : null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)SoundRegistry.VOID_TENTACLES_FINISH.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        for (int r = 0; r < rings; ++r) {
            float tentacles = count + r * 2;
            int i = 0;
            while ((float)i < tentacles) {
                Vec3 random = new Vec3(Utils.getRandomScaled(1.0), Utils.getRandomScaled(1.0), Utils.getRandomScaled(1.0));
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, 1.3 * (double)(r + 1)).m_82524_(6.281f / tentacles * (float)i)).m_82549_(random);
                if (!level.m_8055_(BlockPos.m_274446_((Position)(spawn = new Vec3(spawn.f_82479_, (double)Utils.findRelativeGroundLevel(level, spawn, 8), spawn.f_82481_))).m_7495_()).m_60795_()) {
                    VoidTentacle tentacle = new VoidTentacle(level, entity, this.getDamage(spellLevel, entity));
                    tentacle.m_20219_(spawn);
                    tentacle.m_146922_(level.m_213780_().m_188503_(360));
                    level.m_7967_((Entity)tentacle);
                }
                ++i;
            }
        }
        level.m_220400_(null, GameEvent.f_223709_, center);
        super.onCast(level, spellLevel, entity, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }

    private int getRings(int spellLevel, LivingEntity entity) {
        return 1 + this.getLevel(spellLevel, entity);
    }
}

