/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.player.ClientInputEvents;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostStepSpell;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ClientSpellCastHelper {
    private static boolean suppressRightClicks;
    private static boolean didModify;

    public static boolean shouldSuppressRightClicks() {
        return suppressRightClicks;
    }

    public static void setSuppressRightClicks(boolean suppressRightClicks) {
        ClientSpellCastHelper.suppressRightClicks = suppressRightClicks;
    }

    public static void handleClientboundBloodSiphonParticles(Vec3 pos1, Vec3 pos2) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        Level level = Minecraft.m_91087_().f_91074_.f_19853_;
        Vec3 direction = pos2.m_82546_(pos1).m_82490_((double)0.1f);
        for (int i = 0; i < 40; ++i) {
            Vec3 scaledDirection = direction.m_82490_(1.0 + Utils.getRandomScaled(0.35));
            Vec3 random = new Vec3(Utils.getRandomScaled(0.08f), Utils.getRandomScaled(0.08f), Utils.getRandomScaled(0.08f));
            level.m_7106_(ParticleHelper.BLOOD, pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, scaledDirection.f_82479_ + random.f_82479_, scaledDirection.f_82480_ + random.f_82480_, scaledDirection.f_82481_ + random.f_82481_);
        }
    }

    public static void handleClientsideHealParticles(Vec3 pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = Minecraft.m_91087_().f_91074_.f_19853_;
            int i = PotionUtils.m_43559_((Potion)Potion.m_43489_((String)"healing"));
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < 15; ++j) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, pos.f_82479_ + Utils.getRandomScaled(0.25), pos.f_82480_ + Utils.getRandomScaled(1.0) + 1.0, pos.f_82481_ + Utils.getRandomScaled(0.25), d0, d1, d2);
            }
        }
    }

    public static void handleClientsideAbsorptionParticles(Vec3 pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = Minecraft.m_91087_().f_91074_.f_19853_;
            int i = 16239960;
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < 15; ++j) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, pos.f_82479_ + Utils.getRandomScaled(0.25), pos.f_82480_ + Utils.getRandomScaled(1.0), pos.f_82481_ + Utils.getRandomScaled(0.25), d0, d1, d2);
            }
        }
    }

    public static void handleClientboundOakskinParticles(Vec3 pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        RandomSource randomsource = player.m_217043_();
        for (int i = 0; i < 50; ++i) {
            double d0 = Mth.m_216283_((RandomSource)randomsource, (float)-0.5f, (float)0.5f);
            double d1 = Mth.m_216283_((RandomSource)randomsource, (float)0.0f, (float)2.0f);
            double d2 = Mth.m_216283_((RandomSource)randomsource, (float)-0.5f, (float)0.5f);
            ParticleOptions particleType = randomsource.m_188501_() < 0.1f ? ParticleHelper.FIREFLY : new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50011_.m_49966_());
            player.f_19853_.m_7106_(particleType, pos.f_82479_ + d0, pos.f_82480_ + d1, pos.f_82481_ + d2, d0 * 0.05, 0.05, d2 * 0.05);
        }
    }

    public static void handleClientsideRegenCloudParticles(Vec3 pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = player.f_19853_;
            int ySteps = 16;
            int xSteps = 48;
            float yDeg = 180.0f / (float)ySteps * ((float)Math.PI / 180);
            float xDeg = 360.0f / (float)xSteps * ((float)Math.PI / 180);
            for (int x = 0; x < xSteps; ++x) {
                for (int y = 0; y < ySteps; ++y) {
                    Vec3 offset = new Vec3(0.0, 0.0, 5.0).m_82524_((float)y * yDeg).m_82496_((float)x * xDeg).m_82535_(-1.5707964f).m_82542_(1.0, (double)0.85f, 1.0);
                    level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, pos.f_82479_ + offset.f_82479_, pos.f_82480_ + offset.f_82480_, pos.f_82481_ + offset.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void handleClientsideFortifyAreaParticles(Vec3 pos) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = player.f_19853_;
            int ySteps = 128;
            float yDeg = 180.0f / (float)ySteps * ((float)Math.PI / 180);
            for (int y = 0; y < ySteps; ++y) {
                Vec3 offset = new Vec3(0.0, 0.0, 16.0).m_82524_((float)y * yDeg);
                Vec3 motion = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82490_(0.1);
                level.m_7106_(ParticleHelper.WISP, pos.f_82479_ + offset.f_82479_, 1.0 + pos.f_82480_ + offset.f_82480_, pos.f_82481_ + offset.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
    }

    private static void animatePlayerStart(Player player, ResourceLocation resourceLocation) {
        ModifierLayer animation;
        KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)resourceLocation);
        if (keyframeAnimation != null && (animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(SpellAnimations.ANIMATION_RESOURCE)) != null) {
            KeyframeAnimationPlayer castingAnimationPlayer = new KeyframeAnimationPlayer(keyframeAnimation);
            ClientMagicData.castingAnimationPlayerLookup.put(player.m_20148_(), castingAnimationPlayer);
            Boolean armsFlag = (Boolean)ClientConfigs.SHOW_FIRST_PERSON_ARMS.get();
            Boolean itemsFlag = (Boolean)ClientConfigs.SHOW_FIRST_PERSON_ITEMS.get();
            if (armsFlag.booleanValue() || itemsFlag.booleanValue()) {
                castingAnimationPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
                castingAnimationPlayer.setFirstPersonConfiguration(new FirstPersonConfiguration(armsFlag.booleanValue(), armsFlag.booleanValue(), itemsFlag.booleanValue(), itemsFlag.booleanValue()));
            } else {
                castingAnimationPlayer.setFirstPersonMode(FirstPersonMode.DISABLED);
            }
            animation.setAnimation((IAnimation)castingAnimationPlayer);
        }
    }

    public static void handleClientboundOnClientCast(String spellId, int level, CastSource castSource, ICastData castData) {
        AbstractSpell spell = SpellRegistry.getSpell(spellId);
        spell.onClientCast(Minecraft.m_91087_().f_91074_.f_19853_, level, (LivingEntity)Minecraft.m_91087_().f_91074_, castData);
    }

    public static void handleClientboundTeleport(Vec3 pos1, Vec3 pos2) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = Minecraft.m_91087_().f_91074_.f_19853_;
            TeleportSpell.particleCloud(level, pos1);
            TeleportSpell.particleCloud(level, pos2);
        }
    }

    public static void handleClientboundFrostStep(Vec3 pos1, Vec3 pos2) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Level level = Minecraft.m_91087_().f_91074_.f_19853_;
            FrostStepSpell.particleCloud(level, pos1);
            FrostStepSpell.particleCloud(level, pos2);
        }
    }

    public static void handleClientBoundOnCastStarted(UUID castingEntityId, String spellId, int spellLevel) {
        Player player = Minecraft.m_91087_().f_91074_.f_19853_.m_46003_(castingEntityId);
        AbstractSpell spell = SpellRegistry.getSpell(spellId);
        spell.getCastStartAnimation().getForPlayer().ifPresent(resourceLocation -> ClientSpellCastHelper.animatePlayerStart(player, resourceLocation));
        spell.onClientPreCast(player.f_19853_, spellLevel, (LivingEntity)player, player.m_7655_(), null);
    }

    public static void handleClientBoundOnCastFinished(UUID castingEntityId, String spellId, boolean cancelled) {
        ClientMagicData.resetClientCastState(castingEntityId);
        Player player = Minecraft.m_91087_().f_91074_.f_19853_.m_46003_(castingEntityId);
        AbstractSpell spell = SpellRegistry.getSpell(spellId);
        spell.getCastFinishAnimation().getForPlayer().ifPresent(resourceLocation -> {
            if (!cancelled) {
                ClientSpellCastHelper.animatePlayerStart(player, resourceLocation);
            }
        });
        if (castingEntityId.equals(Minecraft.m_91087_().f_91074_.m_20148_()) && ClientInputEvents.isUseKeyDown) {
            if (spell.getCastType().holdToCast()) {
                ClientSpellCastHelper.setSuppressRightClicks(true);
            }
            ClientInputEvents.hasReleasedSinceCasting = false;
        }
    }

    static {
        didModify = false;
    }
}

