/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.registries.ParticleRegistry;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3;

public class ZapParticleOption
implements ParticleOptions {
    public static final Codec<ZapParticleOption> CODEC = RecordCodecBuilder.create(p_235978_ -> p_235978_.group((App)PositionSource.f_157868_.fieldOf("destination").forGetter(p_235982_ -> p_235982_.destination)).apply((Applicative)p_235978_, ZapParticleOption::new));
    public static final ParticleOptions.Deserializer<ZapParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ZapParticleOption>(){

        public ZapParticleOption fromCommand(ParticleType<ZapParticleOption> p_175859_, StringReader p_175860_) throws CommandSyntaxException {
            p_175860_.expect(' ');
            float f = (float)p_175860_.readDouble();
            p_175860_.expect(' ');
            float f1 = (float)p_175860_.readDouble();
            p_175860_.expect(' ');
            float f2 = (float)p_175860_.readDouble();
            BlockPos blockpos = new BlockPos((int)f, (int)f1, (int)f2);
            return new ZapParticleOption((PositionSource)new BlockPositionSource(blockpos));
        }

        public ZapParticleOption fromNetwork(ParticleType<ZapParticleOption> p_175862_, FriendlyByteBuf p_175863_) {
            PositionSource positionsource = PositionSourceType.m_157885_((FriendlyByteBuf)p_175863_);
            return new ZapParticleOption(positionsource);
        }
    };
    private final PositionSource destination;

    public ZapParticleOption(PositionSource p_235975_) {
        this.destination = p_235975_;
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        PositionSourceType.m_157874_((PositionSource)this.destination, (FriendlyByteBuf)pBuffer);
    }

    public String m_5942_() {
        Vec3 vec3 = (Vec3)this.destination.m_142502_((Level)null).get();
        double d0 = vec3.m_7096_();
        double d1 = vec3.m_7098_();
        double d2 = vec3.m_7094_();
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), d0, d1, d2);
    }

    public ParticleType<ZapParticleOption> m_6012_() {
        return (ParticleType)ParticleRegistry.ZAP_PARTICLE.get();
    }

    public PositionSource getDestination() {
        return this.destination;
    }
}

