/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.MagicHelper;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCancelCast {
    private final boolean triggerCooldown;

    public ServerboundCancelCast(boolean triggerCooldown) {
        this.triggerCooldown = triggerCooldown;
    }

    public ServerboundCancelCast(FriendlyByteBuf buf) {
        this.triggerCooldown = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.triggerCooldown);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            ServerboundCancelCast.cancelCast(serverPlayer, this.triggerCooldown);
        });
        return true;
    }

    public static void cancelCast(ServerPlayer serverPlayer, boolean triggerCooldown) {
        MagicData playerMagicData;
        if (serverPlayer != null && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer)).isCasting()) {
            SpellData spellData = playerMagicData.getCastingSpell();
            if (triggerCooldown) {
                MagicHelper.MAGIC_MANAGER.addCooldown(serverPlayer, spellData.getSpell(), playerMagicData.getCastSource());
            }
            playerMagicData.getCastingSpell().getSpell().onServerCastComplete(serverPlayer.f_19853_, spellData.getLevel(), (LivingEntity)serverPlayer, playerMagicData, true);
            if (spellData.getSpell().getCastType() == CastType.CONTINUOUS) {
                Scroll.attemptRemoveScrollAfterCast(serverPlayer);
            }
        }
    }
}

