/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.entity.mobs.AnimatedAttacker;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncAnimation<T extends Entity> {
    int entityId;
    int animationId;

    public ClientboundSyncAnimation(int animationId, T entity) {
        this.entityId = entity.m_19879_();
        this.animationId = animationId;
    }

    public ClientboundSyncAnimation(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.animationId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.animationId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (entity instanceof AnimatedAttacker) {
                AnimatedAttacker animatedAttacker = (AnimatedAttacker)entity;
                animatedAttacker.playAnimation(this.animationId);
            }
        });
        return true;
    }
}

